/*  GUBI - Gtk+ User Interface Builder
 *  Copyright (C) 1997	Tim Janik	<timj@psynet.net>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
#include	"rcs.h"
RCS_ID("$Id: misc.c,v 1.4 1997/08/18 03:38:12 timj Exp $")


#define		__misc_c__

#include	"misc.h"
#include	"config.h"
#include	<glib.h>
#include	<ctype.h>
#include	<sys/stat.h>
#include	<stdarg.h>



/* --- variables --- */
static	FILE	*verbosity_strem=stderr;
static	guint	verbosity_level=MIN_VERBOSE;



/* --- functions --- */
int
get_stat_mode	(const	char	*file_name)
{
	static struct	stat	*stat_buf;
	register int		st_mode;
	
	stat_buf=g_new0(struct stat, 1);
	
	stat(file_name, stat_buf);
	
	st_mode=stat_buf->st_mode;
	
	g_free(stat_buf);
	
	return st_mode;
}


gchar*
string_to_case		(const gchar	*string,
			 gboolean	to_upper,
			 gboolean	all_chars)
{
	static	 gchar	*buffer=NULL;
	register gchar	*free_buffer;
	register guint	i;
	register guint	len;
	
	if (!string)
		return NULL;
	
	
	len=strlen(string);
	
	free_buffer=buffer;
	buffer=g_new(gchar, len+1);
	
	strcpy(buffer, string);
	
	if (buffer[0]) {
		if (to_upper)
			buffer[0]=toupper(buffer[0]);
		else
			buffer[0]=tolower(buffer[0]);
	}
	
	for (i=1; i<len; i++)
		if (all_chars || buffer[i-1]=='_' || buffer[i-1]==' ') {
		if (to_upper)
			buffer[i]=toupper(buffer[i]);
		else
			buffer[i]=tolower(buffer[i]);
		}
	
	g_free(free_buffer);
	
	return buffer;
}


gchar*
symbol_name_make_valid	(gchar	*src_string)
{
	register gchar	*dest_string;
	register guint	len;
	register guint	i = 0;
	register guint	j = 0;
	
	if (!src_string)
		return NULL;
	
	dest_string = src_string;
	src_string = g_strdup(src_string);
	
	len=strlen(src_string);
	for (i = 0; i < len; i++) {
		switch (src_string[i]) {
		
		case '0'...'9':
			if (!j)
				break;
		case 'a'...'z':
		case 'A'...'Z':
		case '_':
			dest_string[j] = src_string[i];
			j++;
			break;
		
		default:
			break;
		}
	}
	dest_string[j]=0;
	
	g_free(src_string);
	return dest_string;
}


void
verbosity_set		(guint	level)
{
	verbosity_level=CLAMP(level, MIN_VERBOSE, MAX_VERBOSE);
}


guint
verbosity_get		(void)
{
	return verbosity_level;
}


int
verbose_printf	(guint		level,
		 const char	*format,
		 ...)
{
	register int		i;
		 va_list	args;
	
	g_assert(format);
	
	if (level>verbosity_level)
		return 0;
	
	va_start(args, format);
	if (verbosity_strem)
		i=vfprintf(verbosity_strem, format, args);
	else
		i=0;
	va_end(args);
	
	if (verbosity_strem)
		fflush(verbosity_strem);
	
	return i;
}
