/*  GUBI - Gtk+ User Interface Builder
 *  Copyright (C) 1997  Tim Janik
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* treelist.h: widget tree list functions
 * RCS_ID("$Id: treelist.h,v 1.5 1997/05/09 16:29:43 tim Exp $")
*/


#ifndef		__treelist_h__
#define		__treelist_h__

#ifdef		__cplusplus
  extern	"C"	{
#endif

#include	"gbconf.h"
#include	"windows.h"
#include	"wdtree.h"



/* --- prototypes --- */
void	SigH_TreeList_selection_changed	(GtkList	*gtklist,
					 gpointer	func_data);
void	SigH_TreeList_Hints_changed	(GtkWidget	*widget,
					 gpointer	func_data);
void	SigH_TreeList_Add_clicked	(GtkWidget	*widget,
					 gpointer	func_data);
void	SigH_TreeList_List_clicked	(GtkWidget	*widget,
					 gpointer	func_data);
void	SigH_TreeList_Delete_clicked	(GtkWidget	*widget,
					 gpointer	func_data);
void	SigH_TreeList_Rebuild_clicked	(GtkWidget	*widget,
					 gpointer	func_data);
void	SigH_Delete_window_real		(GtkWidget	*widget,
					 tree_S		*tree);

void	TreeList_refresh		(gboolean	select_last);
void	TreeList_hints_update		(tree_S		*tree);






#ifdef		__cplusplus
  }
#endif
#endif		/*__treelist_h__*/
