/*  GUBI - Gtk+ User Interface Builder
 *  Copyright (C) 1997  Tim Janik
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
#include	"RCS.h"
RCS_ID("$Id: treelist.c,v 1.9 1997/05/20 21:17:50 tim Exp $")


#define		__treelist_c__

#include	"treelist.h"
#include	"browser.h"
#include	"widgets.h"
#include	"builder.h"
#include	"widdata.h"
#include	"ufunc.h"
#include	"gbcio.h"
#include	"defines.h"
#include	"config.h"



/* --- variables --- */
static	gboolean	ignore_hints=FALSE;



/* --- functions --- */
void
TreeList_refresh	(gboolean	select_last)
{
	register GList		*list;
	register tree_S		*old_tree;
	
	if (GTK_LIST(TreeList_List->widget)->selection) {
		register GtkWidget	*item;
		register gb_wdat_base_S	*WinDat;
		
		item=GTK_LIST(TreeList_List->widget)->selection->data;
		
		g_assert((WinDat=gtk_object_get_user_data(GTK_OBJECT(item))));
		g_assert(GB_IS_WIDDAT_WINDOW(WinDat));
		g_assert((old_tree=GUBI_DATA(WinDat)->tree));
	} else
		old_tree=NULL;
	
	gtk_list_clear_items(GTK_LIST(TreeList_List->widget), 0, -1);
	
	
	list=UD_tree_list;
	while (list) {
		register tree_S		*tree;
		register gb_wdat_base_S	*WinDat;
		register GtkWidget	*item;
		
		g_assert((tree=list->data));
		g_assert(tree->widget_data_list);
		WinDat=tree->widget_data_list->data;
		g_assert(GB_IS_WIDDAT_WINDOW(WinDat));
		
		item=widget_data_item_new(WinDat,
					  0,
					  GTK_LIST(TreeList_List->widget),
					  -1);
		gtk_signal_connect(GTK_OBJECT(item),
				   "button_press_event",
				   GTK_SIGNAL_FUNC(SigH_WidDat_item_clicked),
				   NULL);
		gtk_signal_connect(GTK_OBJECT(item),
				   "button_release_event",
				   GTK_SIGNAL_FUNC(SigH_WidDat_item_clicked),
				   NULL);
		if (tree==old_tree)
			gtk_list_select_child(GTK_LIST(TreeList_List->widget), item);
		list=list->next;
        }
        
        if (select_last)
		gtk_list_select_item(GTK_LIST(TreeList_List->widget),
				     g_list_length(GTK_LIST(TreeList_List->widget)->children)-1);
	
	
	if (!GTK_LIST(TreeList_List->widget)->selection)
		gtk_list_select_item(GTK_LIST(TreeList_List->widget), 0);
}


void
SigH_TreeList_selection_changed	(GtkList	*gtklist,
				 gpointer	func_data)
{
	register tree_S			*tree;
	register gb_wdat_window_S	*WinDat;
	
	if (gtklist->selection) {
		register GtkObject	*item;
		g_assert((item=gtklist->selection->data));
		g_assert((WinDat=gtk_object_get_user_data(item)));
		g_assert(GB_IS_WIDDAT_WINDOW(WinDat));
		g_assert((tree=GUBI_DATA(WinDat)->tree));
	} else {
		tree=NULL;
		WinDat=NULL;
	}
	
	tree_set_current(tree);
	
	TreeList_hints_update(tree);
	
	if (WinDat && WinDat->widget)
		_gtk_widget_raise(WinDat->widget);
}


void
TreeList_hints_update	(tree_S	*tree)
{
	ignore_hints=TRUE;
	if (tree==tree_get_current()) {
		gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(TreeList_Toggle_Visible->widget),
					    tree ? tree->visible     : FALSE);
		gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(TreeList_Toggle_Resize->widget),
					    tree ? tree->auto_resize : FALSE);
	}
	ignore_hints=FALSE;
}


void
SigH_TreeList_Rebuild_clicked	(GtkWidget	*widget,
				 gpointer	func_data)
{
	register GList			*list;
	register gb_wdat_window_S	*WinDat;
	
	list=UD_tree_list;
	while (list) {
		tree_rebuild(list->data);
		tree_show(list->data);
		list=list->next;
	}
	
	WinDat=window_data_get_current();
	if (WinDat && WinDat->widget)
		_gtk_widget_raise(WinDat->widget);
}


void
SigH_TreeList_Hints_changed	(GtkWidget	*widget,
				 gpointer	func_data)
{
	if (ignore_hints)
		return;
		
	if (GTK_LIST(TreeList_List->widget)->selection) {
		register tree_S		*tree;
		register GtkWidget	*item;
		register gb_wdat_base_S	*WinDat;
		register gboolean	old_resize;
		
		item=GTK_LIST(TreeList_List->widget)->selection->data;
		g_assert((WinDat=gtk_object_get_user_data(GTK_OBJECT(item))));
		g_assert(GB_IS_WIDDAT_WINDOW(WinDat));
		g_assert((tree=GUBI_DATA(WinDat)->tree));
		
		tree->visible=GTK_TOGGLE_BUTTON(TreeList_Toggle_Visible->widget)->active;
		old_resize=tree->auto_resize;
		tree->auto_resize=GTK_TOGGLE_BUTTON(TreeList_Toggle_Resize->widget)->active;
		
		if (old_resize!=tree->auto_resize)
			tree_rebuild(tree);
		tree_show(tree);
	}
}


void
SigH_TreeList_Add_clicked	(GtkWidget	*widget,
				 gpointer	func_data)
{
	register gb_wdat_window_S	*WinDat;
	register tree_S			*tree;
	
	
	/* we need a new tree
	*/
	tree=tree_new(TRUE, TRUE);
	
	
	/* create a new window widget data structure
	 * (add window to widget tree)
	*/
	WinDat=GB_wCAST(window, widget_data_new(GB_WIDGET_WINDOW, NULL, FALSE));
	tree_widget_data_insert_R(tree, NULL, GB_wCAST(base, WinDat), 0);
	tree_set_current_widget_data(tree, GB_wCAST(base, WinDat));
	
	
	/* *first* show tree, otherwise
	 * we can't raise the window!
	*/
	tree_show(tree);
	TreeList_refresh(TRUE);
}


void
SigH_TreeList_List_clicked	(GtkWidget	*widget,
				 gpointer	func_data)
{
	register gb_wdat_base_S	*WidDat;
	
	WidDat=GB_wCAST(base, window_data_get_current());
	
	if (WidDat) {
		if (GUBI_DATA(WidDat)->browser)
			_gtk_widget_raise(GUBI_DATA(WidDat)->browser);
		else
			Browser_create(WidDat);
	}
}


void
SigH_TreeList_Delete_clicked	(GtkWidget	*widget,
				 gpointer	func_data)
{
	static	 GtkWidget	*Dialog_delete=NULL;
	register gb_wdat_base_S	*DelWin;
	
	DelWin=GB_wCAST(base, window_data_get_current());
	
	if (!Dialog_delete && DelWin)
		Dialog_delete=
			Dialog_create(GTK_OBJECT(widget),
				      &Dialog_delete,
				      "Delete",
				      GTK_SIGNAL_FUNC(SigH_Delete_window_real),
				      tree_get_current(),
				      "Delete  <%s> %s ?",
				      widget_data_symbol_name_get(DelWin),
				      g_list_length(GUBI_DATA(DelWin)->children)>0 ?
				      	" recursively" : "" );
}


void
SigH_Delete_window_real	(GtkWidget	*widget,
			 tree_S		*tree)
{
	register gb_wdat_window_S	*WinDat;
	
	g_assert(tree);
	g_assert(tree->widget_data_list);
	WinDat=tree->widget_data_list->data;
	g_assert(GB_IS_WIDDAT_WINDOW(WinDat));
	
	if (g_list_length(GUBI_DATA(WinDat)->children)>0) {
		register gb_wdat_base_S	*WidDat;
		
		WidDat=GUBI_DATA(WinDat)->children->data;
		
		
		/* unlink and delete children
		*/
		tree_widget_data_unlink_R(tree, WidDat);
		widget_data_delete_R(WidDat);
	}
	
	
	/* delete tree entry with window
	*/
	tree_delete(tree);
}
