
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>

#include "buffer_flat.h"


#if 0
#include "temp_buf.h"
#include "tile_manager.h"
#include "tile_manager_pvt.h"

char temp_path[] = "/tmp";
void copy_region () {};
int stingy_memory_use = 0;
int tile_cache_size = 15000000;

#endif



void
create (int count,
        char * type,
        int x,
        int y)
{
  int i;
  
  for (i=0; i<count; i++)
    {
      if (strcmp (type, "flat") == 0)
        {
          GimpFlatBuffer * b;
          GimpPortion portion;
          GimpArea roi;
          b = gimp_flat_buffer_new (tag_new (PRECISION_U8, FORMAT_RGB, ALPHA_YES), x, y);
          roi.a.x = 1; roi.b.x = 2;
          roi.a.y = 1; roi.b.y = 2;
          gimp_buffer_focus (GIMP_BUFFER(b), &portion, &roi);
          gimp_buffer_alloc (GIMP_BUFFER(b), &portion, ALLOC_ALLOC);
          gimp_buffer_alloc (GIMP_BUFFER(b), &portion, ALLOC_UNALLOC);
          gimp_buffer_delete (GIMP_BUFFER (b));
        }
#if 0
      else if (strcmp (type, "temp") == 0)
        {
          TempBuf * t;
          unsigned char col[4] = {0, 0, 0, 0};
          t = temp_buf_new (x, y, 4, 0, 0, col);
          temp_buf_free (t);
        }
      else if (strcmp (type, "tile") == 0)
        {
          TileManager * tm;
          int n, i;
          tm = tile_manager_new (x, y, 4);
          n = tm->ntile_rows * tm->ntile_cols;
          for (i=0; i<n; i++)
            {
              Tile * t = tile_manager_get (tm, i, TRUE, FALSE);
              tile_release (t, FALSE);
            }
          tile_manager_destroy (tm);
        }
#endif
    }
}


void
set (int count,
     char * type,
     int x,
     int y)
{
  int i;
  
  if (strcmp (type, "flat") == 0)
    {
      GimpFlatBuffer * b;
      GimpPortion portion, *p;
      GimpArea roi;
      p = & portion;
      b = gimp_flat_buffer_new (tag_new (PRECISION_U8, FORMAT_RGB, ALPHA_YES), x, y);
      roi.a.x = 1; roi.b.x = 2;
      roi.a.y = 1; roi.b.y = 2;
      gimp_buffer_focus (GIMP_BUFFER(b), p, &roi);
      gimp_buffer_alloc (GIMP_BUFFER(b), p, ALLOC_ALLOC);
      for (i=0; i<count; i++)
        {
          GimpPixelArray a;
          gimp_buffer_use (GIMP_BUFFER(b), p, USE_READ);
          gimp_buffer_data (GIMP_BUFFER(b), p, &a);
          gimp_buffer_use (GIMP_BUFFER(b), p, USE_RELEASE);
        }
      gimp_buffer_alloc (GIMP_BUFFER(b), p, ALLOC_UNALLOC);
      gimp_buffer_delete (GIMP_BUFFER (b));
    }
#if 0
  else if (strcmp (type, "temp") == 0)
    {
      TempBuf * t;
      unsigned char col[4] = {0, 0, 0, 0};
      t = temp_buf_new (x, y, 4, 0, 0, col);
      for (i=0; i<count; i++)
        {
          temp_buf_data (t);
        }
      temp_buf_free (t);
    }
  else if (strcmp (type, "tile") == 0)
    {
      TileManager * tm;
      int i;
      tm = tile_manager_new (x, y, 4);
      for (i=0; i<count; i++)
        {
          Tile * t = tile_manager_get (tm, 0, TRUE, FALSE);
          tile_release (t, FALSE);
        }
     tile_manager_destroy (tm);
    }
#endif
}


int
main (int    argc,
      char **argv)
{
  int count;
  char * type;
  int x, y;

  gtk_init (&argc, &argv);

  count = atoi (argv[1]);
  type = argv[2];
  x = atoi (argv[3]);
  y = atoi (argv[4]);

  g_warning ("start %d runs of a %d x %d %s doing %s", count, x, y, type, argv[0]);

  if (strcmp (argv[0], "./create") == 0)
    {
      create (count, type, x, y);
    }
  else if (strcmp (argv[0], "./set") == 0)
    {
      set (count, type, x, y);
    }         

  g_warning ("stop");

  return 0;
}

