static const char* op_c_source =
"/* This file is an image processing operation for GEGL                        \n"
" *                                                                            \n"
" * GEGL is free software; you can redistribute it and/or                      \n"
" * modify it under the terms of the GNU Lesser General Public                 \n"
" * License as published by the Free Software Foundation; either               \n"
" * version 3 of the License, or (at your option) any later version.           \n"
" *                                                                            \n"
" * GEGL is distributed in the hope that it will be useful,                    \n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of             \n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU          \n"
" * Lesser General Public License for more details.                            \n"
" *                                                                            \n"
" * You should have received a copy of the GNU Lesser General Public           \n"
" * License along with GEGL; if not, see <http://www.gnu.org/licenses/>.       \n"
" *                                                                            \n"
" * Copyright 2012 Ville Sokk <ville.sokk@gmail.com>                           \n"
" */                                                                           \n"
"                                                                              \n"
"#include \"config.h\"                                                         \n"
"#include <glib/gi18n-lib.h>                                                   \n"
"                                                                              \n"
"#ifdef GEGL_PROPERTIES                                                        \n"
"                                                                              \n"
"property_int (offset_x, _(\"Horizontal offset\"), 0)                          \n"
"    ui_range (0, 1024)                                                        \n"
"    ui_meta  (\"unit\", \"pixel-coordinate\")                                 \n"
"    ui_meta  (\"axis\", \"x\")                                                \n"
"                                                                              \n"
"property_int (offset_y, _(\"Vertical offset\"), 0)                            \n"
"    ui_range (0, 1024)                                                        \n"
"    ui_meta  (\"unit\", \"pixel-coordinate\")                                 \n"
"    ui_meta  (\"axis\", \"y\")                                                \n"
"                                                                              \n"
"#else                                                                         \n"
"                                                                              \n"
"#define GEGL_OP_FILTER                                                        \n"
"#define GEGL_OP_C_SOURCE tile.c                                               \n"
"                                                                              \n"
"#include \"gegl-op.h\"                                                        \n"
"                                                                              \n"
"static void                                                                   \n"
"prepare (GeglOperation *operation)                                            \n"
"{                                                                             \n"
"  const Babl *format;                                                         \n"
"                                                                              \n"
"  format = gegl_operation_get_source_format (operation, \"input\");           \n"
"                                                                              \n"
"  gegl_operation_set_format (operation, \"input\", format);                   \n"
"  gegl_operation_set_format (operation, \"output\", format);                  \n"
"}                                                                             \n"
"                                                                              \n"
"static GeglRectangle                                                          \n"
"get_bounding_box (GeglOperation *operation)                                   \n"
"{                                                                             \n"
"  return gegl_rectangle_infinite_plane ();                                    \n"
"}                                                                             \n"
"                                                                              \n"
"static GeglRectangle                                                          \n"
"get_required_for_output (GeglOperation       *operation,                      \n"
"                         const gchar         *input_pad,                      \n"
"                         const GeglRectangle *roi)                            \n"
"{                                                                             \n"
"  GeglRectangle *rect = gegl_operation_source_get_bounding_box (operation, input_pad);\n"
"                                                                              \n"
"  if (rect)                                                                   \n"
"    {                                                                         \n"
"      return *rect;                                                           \n"
"    }                                                                         \n"
"  else                                                                        \n"
"    {                                                                         \n"
"      GeglRectangle empty = {0,};                                             \n"
"      return empty;                                                           \n"
"    }                                                                         \n"
"}                                                                             \n"
"                                                                              \n"
"static GeglRectangle                                                          \n"
"get_invalidated_by_change (GeglOperation       *operation,                    \n"
"                           const gchar         *input_pad,                    \n"
"                           const GeglRectangle *input_roi)                    \n"
"{                                                                             \n"
"  return gegl_rectangle_infinite_plane ();                                    \n"
"}                                                                             \n"
"                                                                              \n"
"static gboolean                                                               \n"
"process (GeglOperation       *operation,                                      \n"
"         GeglBuffer          *input,                                          \n"
"         GeglBuffer          *output,                                         \n"
"         const GeglRectangle *result,                                         \n"
"         gint                 level)                                          \n"
"{                                                                             \n"
"  GeglProperties *o = GEGL_PROPERTIES (operation);                            \n"
"                                                                              \n"
"  gegl_buffer_set_pattern (output, result, input,                             \n"
"                           o->offset_x,                                       \n"
"                           o->offset_y);                                      \n"
"                                                                              \n"
"  return TRUE;                                                                \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"gegl_op_class_init (GeglOpClass *klass)                                       \n"
"{                                                                             \n"
"  GeglOperationClass       *operation_class;                                  \n"
"  GeglOperationFilterClass *filter_class;                                     \n"
"  gchar                    *composition = \"<?xml version='1.0' encoding='UTF-8'?>\"\n"
"    \"<gegl>\"                                                                \n"
"    \"<node operation='gegl:crop'>\"                                          \n"
"    \"  <params>\"                                                            \n"
"    \"    <param name='width'>200.0</param>\"                                 \n"
"    \"    <param name='height'>200.0</param>\"                                \n"
"    \"  </params>\"                                                           \n"
"    \"</node>\"                                                               \n"
"    \"<node operation='gegl:tile'>\"                                          \n"
"    \"</node>\"                                                               \n"
"    \"<node operation='gegl:load'>\"                                          \n"
"    \"  <params>\"                                                            \n"
"    \"    <param name='path'>standard-aux.png</param>\"                       \n"
"    \"  </params>\"                                                           \n"
"    \"</node>\"                                                               \n"
"    \"</gegl>\";                                                              \n"
"                                                                              \n"
"  operation_class  = GEGL_OPERATION_CLASS (klass);                            \n"
"  filter_class     = GEGL_OPERATION_FILTER_CLASS (klass);                     \n"
"                                                                              \n"
"  filter_class->process                      = process;                       \n"
"  operation_class->prepare                   = prepare;                       \n"
"  operation_class->get_bounding_box          = get_bounding_box;              \n"
"  operation_class->get_required_for_output   = get_required_for_output;       \n"
"  operation_class->get_invalidated_by_change = get_invalidated_by_change;     \n"
"                                                                              \n"
"  gegl_operation_class_set_keys (operation_class,                             \n"
"      \"name\",                 \"gegl:tile\",                                \n"
"      \"title\",                _(\"Tile\"),                                  \n"
"      \"categories\",           \"tile\",                                     \n"
"      \"position-dependent\",   \"true\",                                     \n"
"      \"reference-composition\", composition,                                 \n"
"      \"description\",                                                        \n"
"      _(\"Infinitely repeats the input image.\"),                             \n"
"      NULL);                                                                  \n"
"}                                                                             \n"
"#endif                                                                        \n"
;
