static const char* op_c_source =
"/* This file is an image processing operation for GEGL                        \n"
" *                                                                            \n"
" * GEGL is free software; you can redistribute it and/or                      \n"
" * modify it under the terms of the GNU Lesser General Public                 \n"
" * License as published by the Free Software Foundation; either               \n"
" * version 3 of the License, or (at your option) any later version.           \n"
" *                                                                            \n"
" * GEGL is distributed in the hope that it will be useful,                    \n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of             \n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU          \n"
" * Lesser General Public License for more details.                            \n"
" *                                                                            \n"
" * You should have received a copy of the GNU Lesser General Public           \n"
" * License along with GEGL; if not, see <http://www.gnu.org/licenses/>.       \n"
" *                                                                            \n"
" * Copyright 1997 Brian Degenhardt <bdegenha@ucsd.edu>                        \n"
" * Copyright 1997 Federico Mena Quinter <quartic@polloux.fciencias.unam.mx>   \n"
" * Copyright 2012 Hans Lo <hansshulo@gmail.com>                               \n"
" */                                                                           \n"
"                                                                              \n"
"#include \"config.h\"                                                         \n"
"#include <glib/gi18n-lib.h>                                                   \n"
"                                                                              \n"
"#ifdef GEGL_PROPERTIES                                                        \n"
"                                                                              \n"
"property_int  (shift, _(\"Shift\"), 5)                                        \n"
"    description(_(\"Maximum amount to shift\"))                               \n"
"    value_range (0, 200)                                                      \n"
"    ui_meta    (\"unit\", \"pixel-distance\")                                 \n"
"                                                                              \n"
"property_enum (direction, _(\"Shift direction\"),                             \n"
"    GeglOrientation, gegl_orientation,                                        \n"
"    GEGL_ORIENTATION_HORIZONTAL)                                              \n"
"                                                                              \n"
"property_seed (seed, _(\"Random seed\"), rand)                                \n"
"                                                                              \n"
"#else                                                                         \n"
"                                                                              \n"
"#define GEGL_OP_AREA_FILTER                                                   \n"
"#define GEGL_OP_C_SOURCE shift.c                                              \n"
"                                                                              \n"
"#include \"gegl-op.h\"                                                        \n"
"                                                                              \n"
"static void                                                                   \n"
"prepare (GeglOperation *operation)                                            \n"
"{                                                                             \n"
"  GeglProperties          *o       = GEGL_PROPERTIES (operation);             \n"
"  GeglOperationAreaFilter *op_area = GEGL_OPERATION_AREA_FILTER (operation);  \n"
"  const Babl              *format;                                            \n"
"                                                                              \n"
"  if (o->direction == GEGL_ORIENTATION_HORIZONTAL)                            \n"
"    {                                                                         \n"
"      op_area->left   = o->shift;                                             \n"
"      op_area->right  = o->shift;                                             \n"
"      op_area->top    = 0;                                                    \n"
"      op_area->bottom = 0;                                                    \n"
"    }                                                                         \n"
"  else if (o->direction == GEGL_ORIENTATION_VERTICAL)                         \n"
"    {                                                                         \n"
"      op_area->top    = o->shift;                                             \n"
"      op_area->bottom = o->shift;                                             \n"
"      op_area->left   = 0;                                                    \n"
"      op_area->right  = 0;                                                    \n"
"    }                                                                         \n"
"                                                                              \n"
"  format = gegl_operation_get_source_format (operation, \"input\");           \n"
"                                                                              \n"
"  gegl_operation_set_format (operation, \"input\",  format);                  \n"
"  gegl_operation_set_format (operation, \"output\", format);                  \n"
"}                                                                             \n"
"                                                                              \n"
"                                                                              \n"
"static gboolean                                                               \n"
"process (GeglOperation       *operation,                                      \n"
"         GeglBuffer          *input,                                          \n"
"         GeglBuffer          *output,                                         \n"
"         const GeglRectangle *result,                                         \n"
"         gint                 level)                                          \n"
"{                                                                             \n"
"  GeglProperties    *o = GEGL_PROPERTIES (operation);                         \n"
"  gint           size, i, pos;                                                \n"
"  GeglRectangle  dst_rect;                                                    \n"
"                                                                              \n"
"                                                                              \n"
"  if (o->direction == GEGL_ORIENTATION_HORIZONTAL)                            \n"
"    {                                                                         \n"
"      size = result->height;                                                  \n"
"      dst_rect.width  = result->width;                                        \n"
"      dst_rect.height = 1;                                                    \n"
"      pos = result->y;                                                        \n"
"    }                                                                         \n"
"  else                                                                        \n"
"    {                                                                         \n"
"      size = result->width;                                                   \n"
"      dst_rect.width  = 1;                                                    \n"
"      dst_rect.height = result->height;                                       \n"
"      pos = result->x;                                                        \n"
"    }                                                                         \n"
"                                                                              \n"
"  dst_rect.x = result->x;                                                     \n"
"  dst_rect.y = result->y;                                                     \n"
"                                                                              \n"
"  for (i = 0; i < size; i++)                                                  \n"
"    {                                                                         \n"
"      GeglRectangle src_rect;                                                 \n"
"      gint shift = gegl_random_int_range (o->rand, i + pos, 0, 0, 0,          \n"
"                                          -o->shift, o->shift + 1);           \n"
"                                                                              \n"
"      if (o->direction == GEGL_ORIENTATION_HORIZONTAL)                        \n"
"        {                                                                     \n"
"          dst_rect.y = i + result->y;                                         \n"
"          src_rect = dst_rect;                                                \n"
"          src_rect.x = result->x + shift;                                     \n"
"        }                                                                     \n"
"      else                                                                    \n"
"        {                                                                     \n"
"          dst_rect.x = i + result->x;                                         \n"
"          src_rect = dst_rect;                                                \n"
"          src_rect.y = result->y + shift;                                     \n"
"        }                                                                     \n"
"                                                                              \n"
"      gegl_buffer_copy (input, &src_rect, GEGL_ABYSS_CLAMP,                   \n"
"                        output, &dst_rect);                                   \n"
"    }                                                                         \n"
"                                                                              \n"
"  return  TRUE;                                                               \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"gegl_op_class_init (GeglOpClass *klass)                                       \n"
"{                                                                             \n"
"  GeglOperationClass       *operation_class;                                  \n"
"  GeglOperationFilterClass *filter_class;                                     \n"
"                                                                              \n"
"  operation_class = GEGL_OPERATION_CLASS (klass);                             \n"
"  filter_class    = GEGL_OPERATION_FILTER_CLASS (klass);                      \n"
"                                                                              \n"
"  filter_class->process    = process;                                         \n"
"  operation_class->prepare = prepare;                                         \n"
"                                                                              \n"
"  gegl_operation_class_set_keys (operation_class,                             \n"
"    \"name\",        \"gegl:shift\",                                          \n"
"    \"title\",       _(\"Shift\"),                                            \n"
"    \"categories\",  \"distort\",                                             \n"
"    \"license\",     \"GPL3+\",                                               \n"
"    \"description\", _(\"Shift each row or column of pixels by a random amount\"),\n"
"    NULL);                                                                    \n"
"}                                                                             \n"
"                                                                              \n"
"#endif                                                                        \n"
;
