/* CSL - Common Sound Layer
 * Copyright (C) 2000-2001 Stefan Westerfeld and Tim Janik
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General
 * Public License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 */
#ifndef __ARTS_MD5_H__
#define __ARTS_MD5_H__

#include        <csl/csldefs.h>

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */



/* you don't want to change this! */
#define ARTS_MD5_COOKIE_LEN 32

/* calculate the md5sum of data */
void		_arts_md5_sum		(int		 length,
					 unsigned char	*data,
					 char		 md5sum[ARTS_MD5_COOKIE_LEN + 1]);

/* use this routine to set the "secret cookie" - you can pass a newly
 * generated random cookie here, or the secret cookie you got from
 * elsewhere (to communicate with others). you have to set a cookie
 * with this function, before using any of the following functions.
 */
void		_arts_md5_auth_set_cookie	(const char	*cookie);
const char*	_arts_md5_auth_cookie	(void);

/* generate a new random cookie R (also be used to generate secret cookies)
 * the new cookie is strdup()ed.
 */
char*		_arts_md5_auth_mangle	(const char	*cookie);
       
/* using _arts_md5_auth_init_seed(), the security will be improved by loading a
 * random seed from that file, and (if it has no recent date) saving a new
 * seed to it - this will ensure that the _arts_md5_auth_mkcookie() routine will
 * return a really unpredictable result (as it depends on all processes that
 * ever have touched the seed)
 */
void		_arts_md5_auth_init_seed	(const char	*seedfile_name);
/* generate a random md5 cookie */
char*		_arts_md5_auth_mkcookie	(void);
unsigned long	_arts_md5_auth_mkrand	(void);
     
CslBool		_arts_md5_load_cookie	(const char	*filename,
					 char		 cookie[ARTS_MD5_COOKIE_LEN + 1]);
       


#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* __ARTS_MD5_H__ */
