
/**
 ** Generated data (by mkcproc.pl)
 **/
#line 1 "bseitem.proc"

#include <bse/bseplugin.h>
#include <bse/bseprocedure.h>
#include <bse/bseitem.h>
#include <bse/bsecontainer.h>
#include <bse/bseundostack.h>
#include <bse/bseparasite.h>	// FIXME


#line 29 "bseitem.proc"


/* --- get-type --- */
static void
get_type_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 31 "bseitem.proc"
 {
#line 33 "bseitem.proc"
  *(in_pspecs++) = bse_param_spec_object ("item", "Item", NULL,
				 BSE_TYPE_ITEM, SFI_PARAM_DEFAULT);
  *(out_pspecs++) = sfi_pspec_string ("type_id", "Type ID", NULL,
			    NULL, SFI_PARAM_DEFAULT);
#line 32 "bseitem.proc"
  proc->help = "Retrieve an item's type ID.";
#line 27 "bseitem.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 28 "bseitem.proc"
  proc->copyright = "Copyright (C) 2001-2002 Tim Janik";
#line 37 "bseitem.proc"
}  }
static BseErrorType
#line 37 "bseitem.proc"
get_type_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 40 "bseitem.proc"
{
#line 41 "bseitem.proc"
  
  BseItem *item = (BseItem*) bse_value_get_object (in_values++);
  
#line 44 "bseitem.proc"
  
  if (!BSE_IS_ITEM (item))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 48 "bseitem.proc"
  
  sfi_value_set_static_string (out_values++, g_type_name (G_OBJECT_TYPE (item)));
  
  return BSE_ERROR_NONE;
}

/* --- get-type-name --- */
static void
get_type_name_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 54 "bseitem.proc"
 {
#line 56 "bseitem.proc"
  *(in_pspecs++) = bse_param_spec_object ("item", "Item", NULL,
				 BSE_TYPE_ITEM, SFI_PARAM_DEFAULT);
  *(out_pspecs++) = sfi_pspec_string ("type_name", "Type Name", NULL,
			    NULL,
			    SFI_PARAM_DEFAULT);
#line 55 "bseitem.proc"
  proc->help = "Retrieve an item's type name.";
#line 27 "bseitem.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 28 "bseitem.proc"
  proc->copyright = "Copyright (C) 2001-2002 Tim Janik";
#line 61 "bseitem.proc"
}  }
static BseErrorType
#line 61 "bseitem.proc"
get_type_name_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 64 "bseitem.proc"
{
#line 65 "bseitem.proc"
  
  BseItem *item = (BseItem*) bse_value_get_object (in_values++);
  
#line 68 "bseitem.proc"
  
  if (!BSE_IS_ITEM (item))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 72 "bseitem.proc"
  
  sfi_value_set_string (out_values++, g_type_name (G_OBJECT_TYPE (item)));
  
  return BSE_ERROR_NONE;
}

/* --- get-type-blurb --- */
static void
get_type_blurb_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 78 "bseitem.proc"
 {
#line 80 "bseitem.proc"
  *(in_pspecs++) = bse_param_spec_object ("item", "Item", NULL,
				 BSE_TYPE_ITEM, SFI_PARAM_DEFAULT);
  *(out_pspecs++) = sfi_pspec_string ("type_blurb", "Type Blurb", NULL,
			    NULL,
			    SFI_PARAM_DEFAULT);
#line 79 "bseitem.proc"
  proc->help = "Retrieve an item's type description.";
#line 27 "bseitem.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 28 "bseitem.proc"
  proc->copyright = "Copyright (C) 2001-2002 Tim Janik";
#line 85 "bseitem.proc"
}  }
static BseErrorType
#line 85 "bseitem.proc"
get_type_blurb_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 88 "bseitem.proc"
{
#line 89 "bseitem.proc"
  
  BseItem *item = (BseItem*) bse_value_get_object (in_values++);
  
#line 92 "bseitem.proc"
  
  if (!BSE_IS_ITEM (item))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 96 "bseitem.proc"
  
  sfi_value_set_string (out_values++, bse_type_blurb (G_OBJECT_TYPE (item)));
  
  return BSE_ERROR_NONE;
}

/* --- get-parent --- */
static void
get_parent_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 102 "bseitem.proc"
 {
#line 104 "bseitem.proc"
  *(in_pspecs++) = bse_param_spec_object ("item", "Item", NULL,
				 BSE_TYPE_ITEM, SFI_PARAM_DEFAULT);
  *(out_pspecs++) = bse_param_spec_object ("parent", "Parent", NULL,
				 BSE_TYPE_ITEM, SFI_PARAM_DEFAULT);
#line 103 "bseitem.proc"
  proc->help = "Retrieve an item's parent.";
#line 27 "bseitem.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 28 "bseitem.proc"
  proc->copyright = "Copyright (C) 2001-2002 Tim Janik";
#line 108 "bseitem.proc"
}  }
static BseErrorType
#line 108 "bseitem.proc"
get_parent_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 111 "bseitem.proc"
{
#line 112 "bseitem.proc"
  
  BseItem *item = (BseItem*) bse_value_get_object (in_values++);
  
#line 115 "bseitem.proc"
  
  if (!BSE_IS_ITEM (item))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 119 "bseitem.proc"
  
  bse_value_set_object (out_values++, item->parent);
  
  return BSE_ERROR_NONE;
}

/* --- get-project --- */
static void
get_project_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 125 "bseitem.proc"
 {
#line 127 "bseitem.proc"
  *(in_pspecs++) = bse_param_spec_object ("item", "Item", NULL,
				 BSE_TYPE_ITEM, SFI_PARAM_DEFAULT);
  *(out_pspecs++) = bse_param_spec_object ("project", "Project", NULL,
				 BSE_TYPE_ITEM, SFI_PARAM_DEFAULT);
#line 126 "bseitem.proc"
  proc->help = "Retrieve an item's project.";
#line 27 "bseitem.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 28 "bseitem.proc"
  proc->copyright = "Copyright (C) 2001-2002 Tim Janik";
#line 131 "bseitem.proc"
}  }
static BseErrorType
#line 131 "bseitem.proc"
get_project_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 134 "bseitem.proc"
{
#line 135 "bseitem.proc"
  
  BseItem *item = (BseItem*) bse_value_get_object (in_values++);
  
#line 138 "bseitem.proc"
  
  if (!BSE_IS_ITEM (item))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 142 "bseitem.proc"
  
  bse_value_set_object (out_values++, bse_item_get_project (item));
  
  return BSE_ERROR_NONE;
}

/* --- get-uname-path --- */
static void
get_uname_path_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 148 "bseitem.proc"
 {
#line 150 "bseitem.proc"
  *(in_pspecs++) = bse_param_spec_object ("item", NULL, NULL,
				 BSE_TYPE_ITEM, SFI_PARAM_DEFAULT);
  *(out_pspecs++) = sfi_pspec_string ("uname_path", NULL, NULL,
			    NULL, SFI_PARAM_DEFAULT);
#line 149 "bseitem.proc"
  proc->help = "Retrieve the project relative uname path for this item.";
#line 27 "bseitem.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 28 "bseitem.proc"
  proc->copyright = "Copyright (C) 2001-2002 Tim Janik";
#line 154 "bseitem.proc"
}  }
static BseErrorType
#line 154 "bseitem.proc"
get_uname_path_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 157 "bseitem.proc"
{
#line 158 "bseitem.proc"
  
  BseItem *item = bse_value_get_object (in_values++);
  BseProject *project;
  
#line 162 "bseitem.proc"
  
  if (!BSE_IS_ITEM (item))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
  project = bse_item_get_project (item);
  
#line 168 "bseitem.proc"
  
  sfi_value_take_string (out_values++,
			 project ? bse_container_make_upath (BSE_CONTAINER (project), item) : NULL);
  
  return BSE_ERROR_NONE;
}

/* --- internal --- */
static void
internal_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 175 "bseitem.proc"
 {
#line 177 "bseitem.proc"
  *(in_pspecs++) = bse_param_spec_object ("item", "Item", NULL,
				 BSE_TYPE_ITEM, SFI_PARAM_DEFAULT);
  *(out_pspecs++) = sfi_pspec_bool ("internal", "Internal", NULL,
                          FALSE, SFI_PARAM_DEFAULT);
#line 176 "bseitem.proc"
  proc->help = "Check whether an item is internal, i.e. owned by another non-internal item.";
#line 27 "bseitem.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 28 "bseitem.proc"
  proc->copyright = "Copyright (C) 2001-2002 Tim Janik";
#line 181 "bseitem.proc"
}  }
static BseErrorType
#line 181 "bseitem.proc"
internal_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 184 "bseitem.proc"
{
#line 185 "bseitem.proc"
  
  BseItem *item = (BseItem*) bse_value_get_object (in_values++);
  
#line 188 "bseitem.proc"
  
  if (!BSE_IS_ITEM (item))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 192 "bseitem.proc"
  
  sfi_value_set_bool (out_values++, BSE_ITEM_INTERNAL (item));
  
  return BSE_ERROR_NONE;
}

/* --- use --- */
static void
use_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 198 "bseitem.proc"
 {
#line 200 "bseitem.proc"
  *(in_pspecs++) = bse_param_spec_object ("item", "Item", NULL,
				 BSE_TYPE_ITEM, SFI_PARAM_DEFAULT);
  *(out_pspecs++) = bse_param_spec_object ("used_item", "Item", NULL,
				 BSE_TYPE_ITEM, SFI_PARAM_DEFAULT);
#line 199 "bseitem.proc"
  proc->help = "Increment use count to keep an item alive.";
#line 27 "bseitem.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 28 "bseitem.proc"
  proc->copyright = "Copyright (C) 2001-2002 Tim Janik";
#line 204 "bseitem.proc"
}  }
static BseErrorType
#line 204 "bseitem.proc"
use_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 207 "bseitem.proc"
{
#line 208 "bseitem.proc"
  
  BseItem *item = (BseItem*) bse_value_get_object (in_values++);
  
#line 211 "bseitem.proc"
  
  if (!BSE_IS_ITEM (item) || (!item->parent && !item->use_count))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 215 "bseitem.proc"
  
  bse_item_use (item);
  
#line 218 "bseitem.proc"
  
  bse_value_set_object (out_values++, item);
  
  return BSE_ERROR_NONE;
}

/* --- unuse --- */
static void
unuse_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 224 "bseitem.proc"
 {
#line 226 "bseitem.proc"
  *(in_pspecs++) = bse_param_spec_object ("item", "Item", NULL,
				 BSE_TYPE_ITEM, SFI_PARAM_DEFAULT);
#line 225 "bseitem.proc"
  proc->help = "Decrement use count for when an item is not needed anymore.";
#line 27 "bseitem.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 28 "bseitem.proc"
  proc->copyright = "Copyright (C) 2001-2002 Tim Janik";
#line 228 "bseitem.proc"
}  }
static BseErrorType
#line 228 "bseitem.proc"
unuse_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 231 "bseitem.proc"
{
#line 232 "bseitem.proc"
  
  BseItem *item = (BseItem*) bse_value_get_object (in_values++);
  
#line 235 "bseitem.proc"
  
  if (!BSE_IS_ITEM (item))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 239 "bseitem.proc"
  
  if (item->use_count < 1)
    return BSE_ERROR_NOT_OWNER;

  bse_item_unuse (item);
  
  return BSE_ERROR_NONE;
}

/* --- set-name --- */
static void
set_name_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 248 "bseitem.proc"
 {
#line 250 "bseitem.proc"
  *(in_pspecs++) = bse_param_spec_object ("item", "Item", NULL,
				 BSE_TYPE_ITEM, SFI_PARAM_DEFAULT);
  *(in_pspecs++) = sfi_pspec_string ("name", "Name", NULL,
			    NULL, SFI_PARAM_DEFAULT);
#line 249 "bseitem.proc"
  proc->help = "Set an item's name.";
#line 27 "bseitem.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 28 "bseitem.proc"
  proc->copyright = "Copyright (C) 2001-2002 Tim Janik";
#line 254 "bseitem.proc"
}  }
static BseErrorType
#line 254 "bseitem.proc"
set_name_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 257 "bseitem.proc"
{
#line 258 "bseitem.proc"
  
  BseItem *item     = bse_value_get_object (in_values++);
  const gchar *name = g_value_get_string (in_values++);

#line 262 "bseitem.proc"
  
  if (!BSE_IS_ITEM (item))
    return BSE_ERROR_PROC_PARAM_INVAL;

#line 266 "bseitem.proc"
  
  if (!bse_string_equals (name, BSE_OBJECT_UNAME (item)))
    bse_item_set (item, "uname", name, NULL);

  return BSE_ERROR_NONE;
}


/* --- get-name --- */
static void
get_name_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 274 "bseitem.proc"
 {
#line 276 "bseitem.proc"
  *(in_pspecs++) = bse_param_spec_object ("item", "Item", NULL,
				 BSE_TYPE_ITEM, SFI_PARAM_DEFAULT);
  *(out_pspecs++) = sfi_pspec_string ("name", "Name", NULL,
			    NULL, SFI_PARAM_DEFAULT);
#line 275 "bseitem.proc"
  proc->help = "Retrieve an item's name.";
#line 27 "bseitem.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 28 "bseitem.proc"
  proc->copyright = "Copyright (C) 2001-2002 Tim Janik";
#line 280 "bseitem.proc"
}  }
static BseErrorType
#line 280 "bseitem.proc"
get_name_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 283 "bseitem.proc"
{
#line 284 "bseitem.proc"
  
  BseItem *item = (BseItem*) bse_value_get_object (in_values++);
  
#line 287 "bseitem.proc"
  
  if (!BSE_IS_ITEM (item))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 291 "bseitem.proc"
  
  sfi_value_set_string (out_values++, BSE_OBJECT_UNAME (item));
  
  return BSE_ERROR_NONE;
}

/* --- get-name-or-type --- */
static void
get_name_or_type_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 297 "bseitem.proc"
 {
#line 299 "bseitem.proc"
  *(in_pspecs++) = bse_param_spec_object ("item", "Item", NULL,
				 BSE_TYPE_ITEM, SFI_PARAM_DEFAULT);
  *(out_pspecs++) = sfi_pspec_string ("name", "Name", NULL,
			    NULL, SFI_PARAM_DEFAULT);
#line 298 "bseitem.proc"
  proc->help = "Retrieve an item's name or type if it has no name.";
#line 27 "bseitem.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 28 "bseitem.proc"
  proc->copyright = "Copyright (C) 2001-2002 Tim Janik";
#line 303 "bseitem.proc"
}  }
static BseErrorType
#line 303 "bseitem.proc"
get_name_or_type_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 306 "bseitem.proc"
{
#line 307 "bseitem.proc"
  
  BseItem *item = (BseItem*) bse_value_get_object (in_values++);
  gchar *name = NULL;
  
#line 311 "bseitem.proc"
  
  if (!BSE_IS_ITEM (item))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 315 "bseitem.proc"
  
  name = BSE_OBJECT_UNAME (item);
  if (name)
    sfi_value_set_string (out_values++, name);
  else
    sfi_value_set_string (out_values++, BSE_OBJECT_TYPE_NAME (item));
  
  return BSE_ERROR_NONE;
}

/* --- common-ancestor --- */
static void
common_ancestor_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 325 "bseitem.proc"
 {
#line 327 "bseitem.proc"
  *(in_pspecs++) = bse_param_spec_object ("item", "Item", "First item",
				 BSE_TYPE_ITEM, SFI_PARAM_DEFAULT);
  *(in_pspecs++) = bse_param_spec_object ("item2", "Item2", "Second item",
				 BSE_TYPE_ITEM, SFI_PARAM_DEFAULT);
  *(out_pspecs++) = bse_param_spec_object ("ancestor", "ancestor", "Common ancestor of both items",
				 BSE_TYPE_ITEM, SFI_PARAM_DEFAULT);
#line 326 "bseitem.proc"
  proc->help = "Retrieve the common ancestor of two items if there's any.";
#line 27 "bseitem.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 28 "bseitem.proc"
  proc->copyright = "Copyright (C) 2001-2002 Tim Janik";
#line 333 "bseitem.proc"
}  }
static BseErrorType
#line 333 "bseitem.proc"
common_ancestor_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 336 "bseitem.proc"
{
#line 337 "bseitem.proc"
  
  BseItem *item  = bse_value_get_object (in_values++);
  BseItem *item2 = bse_value_get_object (in_values++);
  
#line 341 "bseitem.proc"
  
  if (!BSE_IS_ITEM (item) || !BSE_IS_ITEM (item2))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 345 "bseitem.proc"
  
  bse_value_set_object (out_values++, bse_item_common_ancestor (item, item2));
  
  return BSE_ERROR_NONE;
}

/* --- get-seqid --- */
static void
get_seqid_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 351 "bseitem.proc"
 {
#line 355 "bseitem.proc"
  *(in_pspecs++) = bse_param_spec_object ("item", "Item", NULL,
				 BSE_TYPE_ITEM, SFI_PARAM_DEFAULT);
  *(out_pspecs++) = sfi_pspec_int ("seq_id", "Sequential ID", NULL,
			 0, 0, G_MAXINT, 1, SFI_PARAM_DEFAULT);
#line 352 "bseitem.proc"
  proc->help = ("Retrieve an item's sequential ID. The sequential ID depends "
	   "on the item's type an it's position inbetween siblings "
	   "of the same type within it's immediate container.");
#line 27 "bseitem.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 28 "bseitem.proc"
  proc->copyright = "Copyright (C) 2001-2002 Tim Janik";
#line 359 "bseitem.proc"
}  }
static BseErrorType
#line 359 "bseitem.proc"
get_seqid_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 362 "bseitem.proc"
{
#line 363 "bseitem.proc"
  
  BseItem *item = (BseItem*) bse_value_get_object (in_values++);
  
#line 366 "bseitem.proc"
  
  if (!BSE_IS_ITEM (item))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 370 "bseitem.proc"
  
  sfi_value_set_int (out_values++, bse_item_get_seqid (item));
  
  return BSE_ERROR_NONE;
}

/* --- check-is-a --- */
static void
check_is_a_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 376 "bseitem.proc"
 {
#line 378 "bseitem.proc"
  *(in_pspecs++)    = bse_param_spec_object ("item", "Item", "The Item",
				 BSE_TYPE_ITEM, SFI_PARAM_DEFAULT);
  *(in_pspecs++)    = sfi_pspec_string ("type_name", "Type Name", NULL,
			    NULL, SFI_PARAM_DEFAULT);
  *(out_pspecs++)   = sfi_pspec_bool ("is_a", NULL, NULL,
			  FALSE, SFI_PARAM_DEFAULT);
#line 27 "bseitem.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 28 "bseitem.proc"
  proc->copyright = "Copyright (C) 2001-2002 Tim Janik";
#line 384 "bseitem.proc"
}  }
static BseErrorType
#line 384 "bseitem.proc"
check_is_a_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 387 "bseitem.proc"
{
#line 388 "bseitem.proc"
  
  BseItem *item    = bse_value_get_object (in_values++);
  gchar *type_name = sfi_value_get_string (in_values++);
  GType type;
  gboolean is_a;
  
#line 394 "bseitem.proc"
  
  if (!type_name)
    type_name = "";
  
#line 398 "bseitem.proc"
  
  type = g_type_from_name (type_name);
  is_a = item && g_type_is_a (G_OBJECT_TYPE (item), type);
  
#line 402 "bseitem.proc"
  
  sfi_value_set_bool (out_values++, is_a);
  
  return BSE_ERROR_NONE;
}

/* --- list-proxies --- */
static void
list_proxies_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 408 "bseitem.proc"
 {
#line 410 "bseitem.proc"
  *(in_pspecs++) = bse_param_spec_object ("item", NULL, NULL,
				 BSE_TYPE_ITEM, SFI_PARAM_DEFAULT);
  *(in_pspecs++) = sfi_pspec_string ("property_name", NULL, "Proxy property name",
			    NULL, SFI_PARAM_DEFAULT);
  *(out_pspecs++) = bse_param_spec_boxed ("proxy_list", "Proxy List", NULL, BSE_TYPE_PROXY_SEQ, SFI_PARAM_DEFAULT);
#line 409 "bseitem.proc"
  proc->help = "List possible values for a proxy property of an item.";
#line 27 "bseitem.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 28 "bseitem.proc"
  proc->copyright = "Copyright (C) 2001-2002 Tim Janik";
#line 415 "bseitem.proc"
}  }
static BseErrorType
#line 415 "bseitem.proc"
list_proxies_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 418 "bseitem.proc"
{
#line 419 "bseitem.proc"
  
  BseItem *self     = bse_value_get_object (in_values++);
  gchar   *property = sfi_value_get_string (in_values++);
  
#line 423 "bseitem.proc"
  
  if (!BSE_IS_ITEM (self) || !property)
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 427 "bseitem.proc"
  
  bse_value_take_boxed (out_values++, bse_item_list_proxies (self, property));
  
  return BSE_ERROR_NONE;
}

/* --- get-icon --- */
static void
get_icon_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 433 "bseitem.proc"
 {
#line 435 "bseitem.proc"
  *(in_pspecs++) = bse_param_spec_object ("item", NULL, NULL,
				 BSE_TYPE_ITEM, SFI_PARAM_DEFAULT);
  *(out_pspecs++) = bse_param_spec_boxed ("icon", NULL, NULL,
				BSE_TYPE_ICON, SFI_PARAM_DEFAULT);
#line 434 "bseitem.proc"
  proc->help = "Get the current icon of an item.";
#line 27 "bseitem.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 28 "bseitem.proc"
  proc->copyright = "Copyright (C) 2001-2002 Tim Janik";
#line 439 "bseitem.proc"
}  }
static BseErrorType
#line 439 "bseitem.proc"
get_icon_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 442 "bseitem.proc"
{
#line 443 "bseitem.proc"
  
  BseItem *self     = bse_value_get_object (in_values++);
  
#line 446 "bseitem.proc"
  
  if (!BSE_IS_ITEM (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 450 "bseitem.proc"
  
  bse_value_set_boxed (out_values++, bse_object_get_icon (BSE_OBJECT (self)));
  
  return BSE_ERROR_NONE;
}

/* --- group-undo --- */
static void
group_undo_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 456 "bseitem.proc"
 {
#line 458 "bseitem.proc"
  *(in_pspecs++) = bse_param_spec_object ("item", NULL, NULL,
				 BSE_TYPE_ITEM, SFI_PARAM_DEFAULT);
  *(in_pspecs++) = sfi_pspec_string ("name", NULL, "A name for the undo group to be created",
                            NULL, SFI_PARAM_DEFAULT);
#line 457 "bseitem.proc"
  proc->help = "Request multiple modifying actions on an item to be grouped together as single undo operation.";
#line 27 "bseitem.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 28 "bseitem.proc"
  proc->copyright = "Copyright (C) 2001-2002 Tim Janik";
#line 462 "bseitem.proc"
}  }
static BseErrorType
#line 462 "bseitem.proc"
group_undo_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 465 "bseitem.proc"
{
#line 466 "bseitem.proc"
  
  BseItem *self     = bse_value_get_object (in_values++);
  gchar *name       = sfi_value_get_string (in_values++);
  BseUndoStack *ustack;

#line 471 "bseitem.proc"
  
  if (!BSE_IS_ITEM (self) || !name)
    return BSE_ERROR_PROC_PARAM_INVAL;

  ustack = bse_item_undo_open (self, "item-group-undo");
  bse_undo_stack_add_merger (ustack, name);
  bse_item_undo_close (ustack);
  
  return BSE_ERROR_NONE;
}

/* --- ungroup-undo --- */
static void
ungroup_undo_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 482 "bseitem.proc"
 {
#line 484 "bseitem.proc"
  *(in_pspecs++) = bse_param_spec_object ("item", NULL, NULL,
				 BSE_TYPE_ITEM, SFI_PARAM_DEFAULT);
#line 483 "bseitem.proc"
  proc->help = "Ends the undo grouping opened up by a previous group-undo() call.";
#line 27 "bseitem.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 28 "bseitem.proc"
  proc->copyright = "Copyright (C) 2001-2002 Tim Janik";
#line 486 "bseitem.proc"
}  }
static BseErrorType
#line 486 "bseitem.proc"
ungroup_undo_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 489 "bseitem.proc"
{
#line 490 "bseitem.proc"
  
  BseItem *self     = bse_value_get_object (in_values++);
  BseUndoStack *ustack;

#line 494 "bseitem.proc"
  
  if (!BSE_IS_ITEM (self))
    return BSE_ERROR_PROC_PARAM_INVAL;

  ustack = bse_item_undo_open (self, "item-ungroup-undo");
  bse_undo_stack_remove_merger (ustack);
  bse_item_undo_close (ustack);
  
  return BSE_ERROR_NONE;
}

/* --- undo --- */
static void
undo_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 505 "bseitem.proc"
 {
#line 507 "bseitem.proc"
  *(in_pspecs++) = bse_param_spec_object ("item", NULL, NULL,
				 BSE_TYPE_ITEM, SFI_PARAM_DEFAULT);
#line 506 "bseitem.proc"
  proc->help = "Call the undo function of the project corresponding to this item if any.";
#line 27 "bseitem.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 28 "bseitem.proc"
  proc->copyright = "Copyright (C) 2001-2002 Tim Janik";
#line 509 "bseitem.proc"
}  }
static BseErrorType
#line 509 "bseitem.proc"
undo_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 512 "bseitem.proc"
{
#line 513 "bseitem.proc"
  
  BseItem *self     = bse_value_get_object (in_values++);
  BseProject *project;

#line 517 "bseitem.proc"
  
  if (!BSE_IS_ITEM (self))
    return BSE_ERROR_PROC_PARAM_INVAL;

  project = bse_item_get_project (self);
  if (project)
    bse_item_exec_void (project, "undo");

  return BSE_ERROR_NONE;
}

/* --- redo --- */
static void
redo_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 528 "bseitem.proc"
 {
#line 530 "bseitem.proc"
  *(in_pspecs++) = bse_param_spec_object ("item", NULL, NULL,
				 BSE_TYPE_ITEM, SFI_PARAM_DEFAULT);
#line 529 "bseitem.proc"
  proc->help = "Call the redo function of the project corresponding to this item if any.";
#line 27 "bseitem.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 28 "bseitem.proc"
  proc->copyright = "Copyright (C) 2001-2002 Tim Janik";
#line 532 "bseitem.proc"
}  }
static BseErrorType
#line 532 "bseitem.proc"
redo_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 535 "bseitem.proc"
{
#line 536 "bseitem.proc"
  
  BseItem *self     = bse_value_get_object (in_values++);
  BseProject *project;

#line 540 "bseitem.proc"
  
  if (!BSE_IS_ITEM (self))
    return BSE_ERROR_PROC_PARAM_INVAL;

  project = bse_item_get_project (self);
  if (project)
    bse_item_exec_void (project, "redo");

  return BSE_ERROR_NONE;
}

/* --- clear-undo --- */
static void
clear_undo_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 551 "bseitem.proc"
 {
#line 553 "bseitem.proc"
  *(in_pspecs++) = bse_param_spec_object ("item", NULL, NULL,
				 BSE_TYPE_ITEM, SFI_PARAM_DEFAULT);
#line 552 "bseitem.proc"
  proc->help = "Call the clear-undo function of the project corresponding to this item if any.";
#line 27 "bseitem.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 28 "bseitem.proc"
  proc->copyright = "Copyright (C) 2001-2002 Tim Janik";
#line 555 "bseitem.proc"
}  }
static BseErrorType
#line 555 "bseitem.proc"
clear_undo_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 558 "bseitem.proc"
{
#line 559 "bseitem.proc"
  
  BseItem *self     = bse_value_get_object (in_values++);
  BseProject *project;

#line 563 "bseitem.proc"
  
  if (!BSE_IS_ITEM (self))
    return BSE_ERROR_PROC_PARAM_INVAL;

  project = bse_item_get_project (self);
  if (project)
    bse_item_exec_void (project, "clear-undo");

  return BSE_ERROR_NONE;
}

/* --- undo-depth --- */
static void
undo_depth_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 574 "bseitem.proc"
 {
#line 576 "bseitem.proc"
  *(in_pspecs++)    = bse_param_spec_object ("item", NULL, NULL,
                                 BSE_TYPE_ITEM, SFI_PARAM_DEFAULT);
  *(out_pspecs++)   = sfi_pspec_int ("undo_depth", NULL, "Number of times undo can be called",
                         0, 0, G_MAXINT, 1, SFI_PARAM_DEFAULT);
#line 575 "bseitem.proc"
  proc->help = "Call the undo-depth function of the project corresponding to this item if any.";
#line 27 "bseitem.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 28 "bseitem.proc"
  proc->copyright = "Copyright (C) 2001-2002 Tim Janik";
#line 580 "bseitem.proc"
}  }
static BseErrorType
#line 580 "bseitem.proc"
undo_depth_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 583 "bseitem.proc"
{
#line 584 "bseitem.proc"
  
  BseItem *self     = bse_value_get_object (in_values++);
  gint depth = 0;
  BseProject *project;

#line 589 "bseitem.proc"
  
  if (!BSE_IS_ITEM (self))
    return BSE_ERROR_PROC_PARAM_INVAL;

  project = bse_item_get_project (self);
  if (project)
    bse_item_exec (project, "undo-depth", &depth);

#line 597 "bseitem.proc"
  
  sfi_value_set_int (out_values++, depth);

  return BSE_ERROR_NONE;
}

/* --- redo-depth --- */
static void
redo_depth_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 603 "bseitem.proc"
 {
#line 605 "bseitem.proc"
  *(in_pspecs++)    = bse_param_spec_object ("item", NULL, NULL,
                                 BSE_TYPE_ITEM, SFI_PARAM_DEFAULT);
  *(out_pspecs++)   = sfi_pspec_int ("redo_depth", NULL, "Number of times redo can be called",
                         0, 0, G_MAXINT, 1, SFI_PARAM_DEFAULT);
#line 604 "bseitem.proc"
  proc->help = "Call the redo-depth function of the project corresponding to this item if any.";
#line 27 "bseitem.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 28 "bseitem.proc"
  proc->copyright = "Copyright (C) 2001-2002 Tim Janik";
#line 609 "bseitem.proc"
}  }
static BseErrorType
#line 609 "bseitem.proc"
redo_depth_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 612 "bseitem.proc"
{
#line 613 "bseitem.proc"
  
  BseItem *self     = bse_value_get_object (in_values++);
  gint depth = 0;
  BseProject *project;

#line 618 "bseitem.proc"
  
  if (!BSE_IS_ITEM (self))
    return BSE_ERROR_PROC_PARAM_INVAL;

  project = bse_item_get_project (self);
  if (project)
    bse_item_exec (project, "redo-depth", &depth);

#line 626 "bseitem.proc"
  
  sfi_value_set_int (out_values++, depth);

  return BSE_ERROR_NONE;
}

/* --- fixme-set-parasite --- */
static void
fixme_set_parasite_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 632 "bseitem.proc"
 {
#line 633 "bseitem.proc"
  *(in_pspecs++)    = bse_param_spec_object ("item", NULL, NULL,
				 BSE_TYPE_ITEM, SFI_PARAM_DEFAULT);
  *(in_pspecs++)    = sfi_pspec_string ("name", NULL, NULL, NULL, SFI_PARAM_DEFAULT);
  *(in_pspecs++)    = sfi_pspec_fblock ("parasite", NULL, NULL, SFI_PARAM_DEFAULT);
#line 27 "bseitem.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 28 "bseitem.proc"
  proc->copyright = "Copyright (C) 2001-2002 Tim Janik";
#line 637 "bseitem.proc"
}  }
static BseErrorType
#line 637 "bseitem.proc"
fixme_set_parasite_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 640 "bseitem.proc"
{
#line 641 "bseitem.proc"
  
  BseItem *self     = bse_value_get_object (in_values++);
  const gchar *name = sfi_value_get_string (in_values++);
  SfiFBlock *fblock = sfi_value_get_fblock (in_values++);
  
#line 646 "bseitem.proc"
  
  if (!BSE_IS_ITEM (self) || !name || !fblock)
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 650 "bseitem.proc"
  
  bse_parasite_set_floats (BSE_OBJECT (self), name, fblock->n_values, fblock->values);
  
  return BSE_ERROR_NONE;
}

/* --- fixme-get-parasite --- */
static void
fixme_get_parasite_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 656 "bseitem.proc"
 {
#line 657 "bseitem.proc"
  *(in_pspecs++)    = bse_param_spec_object ("item", NULL, NULL,
				 BSE_TYPE_ITEM, SFI_PARAM_DEFAULT);
  *(in_pspecs++)    = sfi_pspec_string ("name", NULL, NULL, NULL, SFI_PARAM_DEFAULT);
  *(out_pspecs++)   = sfi_pspec_fblock ("parasite", NULL, NULL, SFI_PARAM_DEFAULT);
#line 27 "bseitem.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 28 "bseitem.proc"
  proc->copyright = "Copyright (C) 2001-2002 Tim Janik";
#line 661 "bseitem.proc"
}  }
static BseErrorType
#line 661 "bseitem.proc"
fixme_get_parasite_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 664 "bseitem.proc"
{
#line 665 "bseitem.proc"
  
  BseItem *self     = bse_value_get_object (in_values++);
  const gchar *name = sfi_value_get_string (in_values++);
  
#line 669 "bseitem.proc"
  
  if (!BSE_IS_ITEM (self) || !name)
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 673 "bseitem.proc"
  
  sfi_value_take_fblock (out_values++, bse_parasite_get_floats (BSE_OBJECT (self), name));
  
  return BSE_ERROR_NONE;
}

/* --- Export to BSE --- */
static BseExportNodeProc __enode_get_type = {
  { NULL, BSE_EXPORT_NODE_PROC,
    "BseItem+get-type", "/Methods/BseItem/General/Get Type", NULL },
  0, get_type_setup, get_type_exec, 
};
static BseExportNodeProc __enode_get_type_name = {
  { (BseExportNode*) &__enode_get_type, BSE_EXPORT_NODE_PROC,
    "BseItem+get-type-name", "/Methods/BseItem/General/Get Type Name", NULL },
  0, get_type_name_setup, get_type_name_exec, 
};
static BseExportNodeProc __enode_get_type_blurb = {
  { (BseExportNode*) &__enode_get_type_name, BSE_EXPORT_NODE_PROC,
    "BseItem+get-type-blurb", "/Methods/BseItem/General/Get Type Blurb", NULL },
  0, get_type_blurb_setup, get_type_blurb_exec, 
};
static BseExportNodeProc __enode_get_parent = {
  { (BseExportNode*) &__enode_get_type_blurb, BSE_EXPORT_NODE_PROC,
    "BseItem+get-parent", "/Methods/BseItem/General/Get Parent", NULL },
  0, get_parent_setup, get_parent_exec, 
};
static BseExportNodeProc __enode_get_project = {
  { (BseExportNode*) &__enode_get_parent, BSE_EXPORT_NODE_PROC,
    "BseItem+get-project", "/Methods/BseItem/General/Get Project", NULL },
  0, get_project_setup, get_project_exec, 
};
static BseExportNodeProc __enode_get_uname_path = {
  { (BseExportNode*) &__enode_get_project, BSE_EXPORT_NODE_PROC,
    "BseItem+get-uname-path", "/Methods/BseItem/General/Get Uname Path", NULL },
  0, get_uname_path_setup, get_uname_path_exec, 
};
static BseExportNodeProc __enode_internal = {
  { (BseExportNode*) &__enode_get_uname_path, BSE_EXPORT_NODE_PROC,
    "BseItem+internal", "/Methods/BseItem/General/Internal", NULL },
  0, internal_setup, internal_exec, 
};
static BseExportNodeProc __enode_use = {
  { (BseExportNode*) &__enode_internal, BSE_EXPORT_NODE_PROC,
    "BseItem+use", "/Methods/BseItem/General/Use", NULL },
  0, use_setup, use_exec, 
};
static BseExportNodeProc __enode_unuse = {
  { (BseExportNode*) &__enode_use, BSE_EXPORT_NODE_PROC,
    "BseItem+unuse", "/Methods/BseItem/General/Unuse", NULL },
  0, unuse_setup, unuse_exec, 
};
static BseExportNodeProc __enode_set_name = {
  { (BseExportNode*) &__enode_unuse, BSE_EXPORT_NODE_PROC,
    "BseItem+set-name", "/Methods/BseItem/General/Set Name", NULL },
  0, set_name_setup, set_name_exec, 
};
static BseExportNodeProc __enode_get_name = {
  { (BseExportNode*) &__enode_set_name, BSE_EXPORT_NODE_PROC,
    "BseItem+get-name", "/Methods/BseItem/General/Get Name", NULL },
  0, get_name_setup, get_name_exec, 
};
static BseExportNodeProc __enode_get_name_or_type = {
  { (BseExportNode*) &__enode_get_name, BSE_EXPORT_NODE_PROC,
    "BseItem+get-name-or-type", "/Methods/BseItem/General/Get Name Or Type", NULL },
  0, get_name_or_type_setup, get_name_or_type_exec, 
};
static BseExportNodeProc __enode_common_ancestor = {
  { (BseExportNode*) &__enode_get_name_or_type, BSE_EXPORT_NODE_PROC,
    "BseItem+common-ancestor", "/Methods/BseItem/General/Common Ancestor", NULL },
  0, common_ancestor_setup, common_ancestor_exec, 
};
static BseExportNodeProc __enode_get_seqid = {
  { (BseExportNode*) &__enode_common_ancestor, BSE_EXPORT_NODE_PROC,
    "BseItem+get-seqid", "/Methods/BseItem/General/Get Seqid", NULL },
  0, get_seqid_setup, get_seqid_exec, 
};
static BseExportNodeProc __enode_check_is_a = {
  { (BseExportNode*) &__enode_get_seqid, BSE_EXPORT_NODE_PROC,
    "BseItem+check-is-a", "/Methods/BseItem/General/Check Is A", "Check whether an item has a certain type." },
  0, check_is_a_setup, check_is_a_exec, 
};
static BseExportNodeProc __enode_list_proxies = {
  { (BseExportNode*) &__enode_check_is_a, BSE_EXPORT_NODE_PROC,
    "BseItem+list-proxies", "/Methods/BseItem/General/List Proxies", NULL },
  0, list_proxies_setup, list_proxies_exec, 
};
static BseExportNodeProc __enode_get_icon = {
  { (BseExportNode*) &__enode_list_proxies, BSE_EXPORT_NODE_PROC,
    "BseItem+get-icon", "/Methods/BseItem/General/Get Icon", NULL },
  0, get_icon_setup, get_icon_exec, 
};
static BseExportNodeProc __enode_group_undo = {
  { (BseExportNode*) &__enode_get_icon, BSE_EXPORT_NODE_PROC,
    "BseItem+group-undo", "/Methods/BseItem/General/Group Undo", NULL },
  0, group_undo_setup, group_undo_exec, 
};
static BseExportNodeProc __enode_ungroup_undo = {
  { (BseExportNode*) &__enode_group_undo, BSE_EXPORT_NODE_PROC,
    "BseItem+ungroup-undo", "/Methods/BseItem/General/Ungroup Undo", NULL },
  0, ungroup_undo_setup, ungroup_undo_exec, 
};
static BseExportNodeProc __enode_undo = {
  { (BseExportNode*) &__enode_ungroup_undo, BSE_EXPORT_NODE_PROC,
    "BseItem+undo", "/Methods/BseItem/General/Undo", NULL },
  0, undo_setup, undo_exec, 
};
static BseExportNodeProc __enode_redo = {
  { (BseExportNode*) &__enode_undo, BSE_EXPORT_NODE_PROC,
    "BseItem+redo", "/Methods/BseItem/General/Redo", NULL },
  0, redo_setup, redo_exec, 
};
static BseExportNodeProc __enode_clear_undo = {
  { (BseExportNode*) &__enode_redo, BSE_EXPORT_NODE_PROC,
    "BseItem+clear-undo", "/Methods/BseItem/General/Clear Undo", NULL },
  0, clear_undo_setup, clear_undo_exec, 
};
static BseExportNodeProc __enode_undo_depth = {
  { (BseExportNode*) &__enode_clear_undo, BSE_EXPORT_NODE_PROC,
    "BseItem+undo-depth", "/Methods/BseItem/General/Undo Depth", NULL },
  0, undo_depth_setup, undo_depth_exec, 
};
static BseExportNodeProc __enode_redo_depth = {
  { (BseExportNode*) &__enode_undo_depth, BSE_EXPORT_NODE_PROC,
    "BseItem+redo-depth", "/Methods/BseItem/General/Redo Depth", NULL },
  0, redo_depth_setup, redo_depth_exec, 
};
static BseExportNodeProc __enode_fixme_set_parasite = {
  { (BseExportNode*) &__enode_redo_depth, BSE_EXPORT_NODE_PROC,
    "BseItem+fixme-set-parasite", "/Methods/BseItem/General/Fixme Set Parasite", NULL },
  0, fixme_set_parasite_setup, fixme_set_parasite_exec, 
};
static BseExportNodeProc __enode_fixme_get_parasite = {
  { (BseExportNode*) &__enode_fixme_set_parasite, BSE_EXPORT_NODE_PROC,
    "BseItem+fixme-get-parasite", "/Methods/BseItem/General/Fixme Get Parasite", NULL },
  0, fixme_get_parasite_setup, fixme_get_parasite_exec, 
};
BseExportNode* bse__builtin_init_bseitem_gen_proc_c (void);
BseExportNode* bse__builtin_init_bseitem_gen_proc_c (void)
{
  return (BseExportNode*) &__enode_fixme_get_parasite;
}

/**
 ** Generated data ends here
 **/
