
/**
 ** Generated data (by mkcproc.pl)
 **/
#line 1 "bseserver.proc"

#include <bse/bseplugin.h>
#include <bse/bseprocedure.h>
#include <bse/bseserver.h>
#include <bse/bseproject.h>
#include <bse/gslloader.h>
#include <bse/bsemidinotifier.h>
#include <bse/bsemidievent.h>
#include <bse/bsejanitor.h>
#include <bse/bsescripthelper.h>
#include <bse/bsegconfig.h>
#include <bse/bseladspa.h>
#include "PKG_config.h"
#include <string.h>


#line 35 "bseserver.proc"


/* --- use-new-project --- */
static GType type_id_use_new_project = 0;
static void
use_new_project_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 37 "bseserver.proc"
 {
#line 39 "bseserver.proc"
  *(in_pspecs++) = bse_param_spec_object ("server", "Server", NULL,
				 BSE_TYPE_SERVER, SFI_PARAM_DEFAULT);
  *(in_pspecs++) = sfi_pspec_string ("name", "Project Name", NULL,
			    NULL, SFI_PARAM_DEFAULT);
  *(out_pspecs++) = bse_param_spec_object ("project", "Project", NULL,
				 BSE_TYPE_PROJECT, SFI_PARAM_DEFAULT);
}
#line 38 "bseserver.proc"
  proc->help = "Create a new project, owned by the caller (name is modified to be unique if necessary)";
#line 33 "bseserver.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 34 "bseserver.proc"
  proc->copyright = "Copyright (C) 2001-2002 Tim Janik";
#line 46 "bseserver.proc"
 }
static BseErrorType
#line 46 "bseserver.proc"
use_new_project_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 49 "bseserver.proc"
{
#line 50 "bseserver.proc"
  
  BseServer *server     = (BseServer*) bse_value_get_object (in_values++);
  gchar *name           = sfi_value_get_string (in_values++);
  gchar *uname;
  guint num = 1;
  BseProject *project;
  
#line 57 "bseserver.proc"
  
  if (!BSE_IS_SERVER (server) || !name)
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 61 "bseserver.proc"
  
  uname = g_strdup (name);
  while (bse_server_find_project (server, uname))
    {
      g_free (uname);
      uname = g_strdup_printf ("%s-%u", name, num++);
    }
  
#line 69 "bseserver.proc"
  
  project = bse_server_create_project (server, uname);
  g_free (uname);
  bse_item_use (BSE_ITEM (project));
  g_object_unref (project);
  
#line 75 "bseserver.proc"
  
  bse_value_set_object (out_values++, G_OBJECT (project));
  
  return BSE_ERROR_NONE;
}

/* --- get-midi-notifier --- */
static GType type_id_get_midi_notifier = 0;
static void
get_midi_notifier_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 81 "bseserver.proc"
 {
#line 83 "bseserver.proc"
  *(in_pspecs++) = bse_param_spec_object ("server", "Server", NULL,
				 BSE_TYPE_SERVER, SFI_PARAM_DEFAULT);
  *(out_pspecs++) = bse_param_spec_object ("midi_notifier", "Midi Notifier", NULL,
				 BSE_TYPE_MIDI_NOTIFIER, SFI_PARAM_DEFAULT);
}
#line 82 "bseserver.proc"
  proc->help = "Retrieve the global midi notifier object.";
#line 33 "bseserver.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 34 "bseserver.proc"
  proc->copyright = "Copyright (C) 2001-2002 Tim Janik";
#line 88 "bseserver.proc"
 }
static BseErrorType
#line 88 "bseserver.proc"
get_midi_notifier_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 91 "bseserver.proc"
{
#line 92 "bseserver.proc"
  
  BseServer *self = bse_value_get_object (in_values++);
  BseMidiReceiver *midi_receiver;
  BseMidiNotifier *notifier;
  
#line 97 "bseserver.proc"
  
  if (!BSE_IS_SERVER (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
  midi_receiver = bse_server_get_midi_receiver (self, "default");
  notifier = bse_midi_receiver_get_notifier (midi_receiver);
  if (!notifier)
    {
      notifier = g_object_new (BSE_TYPE_MIDI_NOTIFIER, NULL);
      bse_midi_receiver_set_notifier (midi_receiver, notifier);
      g_object_unref (notifier);
    }
  
#line 110 "bseserver.proc"
  
  bse_value_set_object (out_values++, G_OBJECT (notifier));
  
  return BSE_ERROR_NONE;
}

/* --- can-load --- */
static GType type_id_can_load = 0;
static void
can_load_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 116 "bseserver.proc"
 {
#line 118 "bseserver.proc"
  *(in_pspecs++) = bse_param_spec_object ("server", "Server", NULL,
				 BSE_TYPE_SERVER, SFI_PARAM_DEFAULT);
  *(in_pspecs++)    = sfi_pspec_string ("file_name", "File Name", "The file to find a loader for",
			    NULL, SFI_PARAM_DEFAULT);
  *(out_pspecs++)   = sfi_pspec_bool ("can-load", NULL, NULL,
			  FALSE, SFI_PARAM_DEFAULT);
}
#line 117 "bseserver.proc"
  proc->help = "Check whether a loader can be found for a wave file";
#line 33 "bseserver.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 34 "bseserver.proc"
  proc->copyright = "Copyright (C) 2001-2002 Tim Janik";
#line 125 "bseserver.proc"
 }
static BseErrorType
#line 125 "bseserver.proc"
can_load_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 128 "bseserver.proc"
{
#line 129 "bseserver.proc"
  
  BseServer *server	= bse_value_get_object (in_values++);
  gchar *file_name	= sfi_value_get_string (in_values++);
  GslWaveFileInfo *finfo;
  
#line 134 "bseserver.proc"
  
  if (!BSE_IS_SERVER (server) || !file_name)
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 138 "bseserver.proc"
  
  finfo = gsl_wave_file_info_load (file_name, NULL);
  sfi_value_set_bool (out_values++, finfo != NULL);
  if (finfo)
    gsl_wave_file_info_unref (finfo);
  
  return BSE_ERROR_NONE;
}

/* --- describe-note --- */
static GType type_id_describe_note = 0;
static void
describe_note_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 147 "bseserver.proc"
 {
#line 149 "bseserver.proc"
  *(in_pspecs++) = bse_param_spec_object ("server", "Server", NULL,
				 BSE_TYPE_SERVER, SFI_PARAM_DEFAULT);
  *(in_pspecs++)    = bse_pspec_note_simple ("note", "Note", NULL, SFI_PARAM_DEFAULT);
  *(in_pspecs++)    = bse_param_spec_fine_tune ("fine_tune", "Fine Tune", NULL);
  *(out_pspecs++)   = bse_param_spec_boxed ("note-description", "Note Description", NULL,
			 BSE_TYPE_NOTE_DESCRIPTION, SFI_PARAM_DEFAULT);
}
#line 148 "bseserver.proc"
  proc->help = "Describe a note, providing information about its octave, semitone, frequency, etc.";
#line 33 "bseserver.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 34 "bseserver.proc"
  proc->copyright = "Copyright (C) 2001-2002 Tim Janik";
#line 156 "bseserver.proc"
 }
static BseErrorType
#line 156 "bseserver.proc"
describe_note_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 159 "bseserver.proc"
{
#line 160 "bseserver.proc"
  
  BseServer *server	= bse_value_get_object (in_values++);
  gint       note	= sfi_value_get_int (in_values++);
  gint       fine_tune	= sfi_value_get_int (in_values++);
  
#line 165 "bseserver.proc"
  
  if (!BSE_IS_SERVER (server))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 169 "bseserver.proc"
  
  bse_value_take_boxed (out_values++, bse_note_description (note, fine_tune));
  
  return BSE_ERROR_NONE;
}

/* --- note-from-freq --- */
static GType type_id_note_from_freq = 0;
static void
note_from_freq_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 175 "bseserver.proc"
 {
#line 177 "bseserver.proc"
  *(in_pspecs++) = bse_param_spec_object ("server", "Server", NULL,
				 BSE_TYPE_SERVER, SFI_PARAM_DEFAULT);
  *(in_pspecs++)    = sfi_pspec_real ("freq", "Frequency", NULL,
			  BSE_KAMMER_FREQUENCY_f,
			  0, BSE_MAX_FREQUENCY_f,
			  10.0, SFI_PARAM_DEFAULT);
  *(out_pspecs++)   = bse_param_spec_boxed ("note-description", "Note Description", NULL,
			 BSE_TYPE_NOTE_DESCRIPTION, SFI_PARAM_DEFAULT);
}
#line 176 "bseserver.proc"
  proc->help = "Describe a note, given its frequency.";
#line 33 "bseserver.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 34 "bseserver.proc"
  proc->copyright = "Copyright (C) 2001-2002 Tim Janik";
#line 186 "bseserver.proc"
 }
static BseErrorType
#line 186 "bseserver.proc"
note_from_freq_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 189 "bseserver.proc"
{
#line 190 "bseserver.proc"
  
  BseServer *server	= bse_value_get_object (in_values++);
  gfloat     freq	= sfi_value_get_real (in_values++);
  gint note;
  
#line 195 "bseserver.proc"
  
  if (!BSE_IS_SERVER (server))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 199 "bseserver.proc"
  
  note = bse_note_from_freq (freq);
  bse_value_take_boxed (out_values++, bse_note_description (note, 0));
  
  return BSE_ERROR_NONE;
}

/* --- note-from-string --- */
static GType type_id_note_from_string = 0;
static void
note_from_string_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 206 "bseserver.proc"
 {
#line 208 "bseserver.proc"
  *(in_pspecs++) = bse_param_spec_object ("server", "Server", NULL,
				 BSE_TYPE_SERVER, SFI_PARAM_DEFAULT);
  *(in_pspecs++)    = sfi_pspec_string ("name", "Name", NULL,
			    "", SFI_PARAM_DEFAULT);
  *(out_pspecs++)   = bse_param_spec_boxed ("note-description", "Note Description", NULL,
			 BSE_TYPE_NOTE_DESCRIPTION, SFI_PARAM_DEFAULT);
}
#line 207 "bseserver.proc"
  proc->help = "Describe a note, given its name and octave offset.";
#line 33 "bseserver.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 34 "bseserver.proc"
  proc->copyright = "Copyright (C) 2001-2002 Tim Janik";
#line 215 "bseserver.proc"
 }
static BseErrorType
#line 215 "bseserver.proc"
note_from_string_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 218 "bseserver.proc"
{
#line 219 "bseserver.proc"
  
  BseServer *server	= bse_value_get_object (in_values++);
  gchar     *name     	= sfi_value_get_string (in_values++);
  gint note;
  
#line 224 "bseserver.proc"
  
  if (!BSE_IS_SERVER (server) || !name)
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 228 "bseserver.proc"
  
  note = bse_note_from_string (name);
  bse_value_take_boxed (out_values++, bse_note_description (note, 0));
  
  return BSE_ERROR_NONE;
}

/* --- construct-note --- */
static GType type_id_construct_note = 0;
static void
construct_note_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 235 "bseserver.proc"
 {
#line 237 "bseserver.proc"
  *(in_pspecs++) = bse_param_spec_object ("server", "Server", NULL,
				 BSE_TYPE_SERVER, SFI_PARAM_DEFAULT);
  *(in_pspecs++)    = sfi_pspec_int ("semitone", NULL, NULL,
			 9, 0, 11, 1,
			 SFI_PARAM_DEFAULT);
  *(in_pspecs++)    = bse_param_spec_octave ("octave", NULL, NULL);
  *(in_pspecs++)    = bse_param_spec_fine_tune ("fine_tune", "Fine Tune", NULL);
  *(out_pspecs++)   = bse_param_spec_boxed ("note-description", "Note Description", NULL,
			 BSE_TYPE_NOTE_DESCRIPTION, SFI_PARAM_DEFAULT);
}
#line 236 "bseserver.proc"
  proc->help = "Describe a note, given its semitone, octave and fine tune.";
#line 33 "bseserver.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 34 "bseserver.proc"
  proc->copyright = "Copyright (C) 2001-2002 Tim Janik";
#line 247 "bseserver.proc"
 }
static BseErrorType
#line 247 "bseserver.proc"
construct_note_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 250 "bseserver.proc"
{
#line 251 "bseserver.proc"
  
  BseServer *server	= bse_value_get_object (in_values++);
  guint      semitone	= sfi_value_get_int (in_values++);
  gint       octave	= sfi_value_get_int (in_values++);
  gint       fine_tune	= sfi_value_get_int (in_values++);
  gint note;
  
#line 258 "bseserver.proc"
  
  if (!BSE_IS_SERVER (server))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 262 "bseserver.proc"
  
  note = BSE_NOTE_GENERIC (octave, semitone);
  bse_value_take_boxed (out_values++, bse_note_description (note, fine_tune));
  
  return BSE_ERROR_NONE;
}

/* --- n-scripts --- */
static GType type_id_n_scripts = 0;
static void
n_scripts_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 269 "bseserver.proc"
 {
#line 271 "bseserver.proc"
  *(in_pspecs++) = bse_param_spec_object ("server", "Server", NULL,
				 BSE_TYPE_SERVER, SFI_PARAM_DEFAULT);
  *(out_pspecs++)   = sfi_pspec_int ("n_connections", NULL, "Number of Connections",
			 0, 0, G_MAXINT, 1,
			 SFI_PARAM_DEFAULT);
}
#line 270 "bseserver.proc"
  proc->help = "Return the number of scripts currently running on this server.";
#line 33 "bseserver.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 34 "bseserver.proc"
  proc->copyright = "Copyright (C) 2001-2002 Tim Janik";
#line 277 "bseserver.proc"
 }
static BseErrorType
#line 277 "bseserver.proc"
n_scripts_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 280 "bseserver.proc"
{
#line 281 "bseserver.proc"
  
  BseServer *server	= bse_value_get_object (in_values++);
  GSList *slist;
  guint n_scripts = 0;
  
#line 286 "bseserver.proc"
  
  if (!BSE_IS_SERVER (server))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 290 "bseserver.proc"
  
  for (slist = server->children; slist; slist = slist->next)
    if (BSE_IS_JANITOR (slist->data))
      n_scripts++;
  
#line 295 "bseserver.proc"
  
  sfi_value_set_int (out_values++, n_scripts);
  
  return BSE_ERROR_NONE;
}

/* --- preferences-locked --- */
static GType type_id_preferences_locked = 0;
static void
preferences_locked_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 301 "bseserver.proc"
 {
#line 303 "bseserver.proc"
  *(in_pspecs++) = bse_param_spec_object ("server", "Server", NULL,
				 BSE_TYPE_SERVER, SFI_PARAM_DEFAULT);
  *(out_pspecs++)   = sfi_pspec_bool ("locked", NULL, NULL,
			  FALSE, SFI_PARAM_DEFAULT);
}
#line 302 "bseserver.proc"
  proc->help = "Returns whether the bse-preferences property is currently locked against modifications or not.";
#line 33 "bseserver.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 34 "bseserver.proc"
  proc->copyright = "Copyright (C) 2001-2002 Tim Janik";
#line 308 "bseserver.proc"
 }
static BseErrorType
#line 308 "bseserver.proc"
preferences_locked_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 311 "bseserver.proc"
{
#line 312 "bseserver.proc"
  
  BseServer *server	= bse_value_get_object (in_values++);
  
#line 315 "bseserver.proc"
  
  if (!BSE_IS_SERVER (server))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 319 "bseserver.proc"
  
  sfi_value_set_int (out_values++, bse_gconfig_locked ());
  
  return BSE_ERROR_NONE;
}

typedef struct _ScriptRegistration ScriptRegistration;
struct _ScriptRegistration
{
  gchar         *script;
  BseErrorType (*register_func) (const gchar *script,
				 BseJanitor **janitor_p);
  ScriptRegistration *next;
};

static gboolean	register_scripts (gpointer data);

static void
script_janitor_closed (BseJanitor *janitor,
		       BseServer  *server)
{
  bse_server_registration (server, BSE_REGISTER_SCRIPT, bse_janitor_get_script (janitor), NULL);
  bse_idle_normal (register_scripts, server);
}

static gboolean
register_scripts (gpointer data)
{
  BseServer *server = data;
  ScriptRegistration *scr = g_object_get_data (server, "script-registration-queue");
  BseJanitor *janitor = NULL;
  BseErrorType error;

  if (!scr)
    {
      bse_server_registration (server, BSE_REGISTER_DONE, NULL, NULL);
      return FALSE;
    }
  g_object_set_data (server, "script-registration-queue", scr->next);

  error = scr->register_func (scr->script, &janitor);
  if (!janitor)
    {
      bse_server_registration (server, BSE_REGISTER_SCRIPT, scr->script, bse_error_blurb (error));
      g_free (scr->script);
      g_free (scr);
      return TRUE;
    }
  g_object_connect (janitor, "signal::closed", script_janitor_closed, server, NULL);
  return FALSE;
}

/* --- register-scripts --- */
static GType type_id_register_scripts = 0;
static void
register_scripts_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 371 "bseserver.proc"
 {
#line 373 "bseserver.proc"
  *(in_pspecs++) = bse_param_spec_object ("server", "Server", NULL,
				 BSE_TYPE_SERVER, SFI_PARAM_DEFAULT);
}
#line 372 "bseserver.proc"
  proc->help = "Register external scripts.";
#line 33 "bseserver.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 34 "bseserver.proc"
  proc->copyright = "Copyright (C) 2001-2002 Tim Janik";
#line 376 "bseserver.proc"
 }
static BseErrorType
#line 376 "bseserver.proc"
register_scripts_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 379 "bseserver.proc"
{
  static gboolean registration_done = FALSE;
#line 381 "bseserver.proc"
  
  BseServer *server	       = bse_value_get_object (in_values++);
  const gchar *path            = BSE_PATH_SCRIPTS;
  ScriptRegistration *scr_list = NULL;
  GSList *free_list, *list;

#line 387 "bseserver.proc"
  
  if (!BSE_IS_SERVER (server))
    return BSE_ERROR_PROC_PARAM_INVAL;

  if (registration_done)
    {
      bse_server_registration (server, BSE_REGISTER_DONE, NULL, NULL);
      return BSE_ERROR_NONE;
    }
  registration_done = TRUE;

  list = bse_search_path_list_files (path, "*.scm", NULL, G_FILE_TEST_IS_REGULAR);
  free_list = g_slist_sort (list, (GCompareFunc) strcmp);
  for (list = free_list; list; list = list->next)
    {
      ScriptRegistration *scr = g_new0 (ScriptRegistration, 1);
      scr->script = list->data;
      scr->register_func = bse_script_file_register;
      scr->next = scr_list;
      scr_list = scr;
    }
  g_slist_free (free_list);

  g_object_set_data (server, "script-registration-queue", scr_list);
  bse_idle_normal (register_scripts, server);

  return BSE_ERROR_NONE;
}

static gboolean
register_plugins (gpointer data)
{
  BseServer *server = data;
  GSList *plugin_slist = g_object_get_data (server, "plugin-registration-queue");
  GSList *ladspa_slist = g_object_get_data (server, "ladspa-registration-queue");
  const gchar *error;

  if (plugin_slist)
    {
      g_object_set_data (server, "plugin-registration-queue", plugin_slist->next);
      error = bse_plugin_check_load (plugin_slist->data);
      bse_server_registration (server, BSE_REGISTER_PLUGIN, plugin_slist->data, error);
      g_free (plugin_slist->data);
      g_slist_free_1 (plugin_slist);
    }
  else if (ladspa_slist)
    {
      g_object_set_data (server, "ladspa-registration-queue", ladspa_slist->next);
      error = bse_ladspa_plugin_check_load (ladspa_slist->data);
      bse_server_registration (server, BSE_REGISTER_PLUGIN, ladspa_slist->data, error);
      g_free (ladspa_slist->data);
      g_slist_free_1 (ladspa_slist);
    }
  else
    {
      bse_server_registration (server, BSE_REGISTER_DONE, NULL, NULL);
      return FALSE;
    }
  return TRUE;
}

/* --- register-plugins --- */
static GType type_id_register_plugins = 0;
static void
register_plugins_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 448 "bseserver.proc"
 {
#line 450 "bseserver.proc"
  *(in_pspecs++) = bse_param_spec_object ("server", "Server", NULL,
				 BSE_TYPE_SERVER, SFI_PARAM_DEFAULT);
}
#line 449 "bseserver.proc"
  proc->help = "Register core plugins.";
#line 33 "bseserver.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 34 "bseserver.proc"
  proc->copyright = "Copyright (C) 2001-2002 Tim Janik";
#line 453 "bseserver.proc"
 }
static BseErrorType
#line 453 "bseserver.proc"
register_plugins_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 456 "bseserver.proc"
{
  static gboolean registration_done = FALSE;
#line 458 "bseserver.proc"
  
  BseServer *server	= bse_value_get_object (in_values++);
  gchar *paths;
  GSList *slist;

#line 463 "bseserver.proc"
  
  if (!BSE_IS_SERVER (server))
    return BSE_ERROR_PROC_PARAM_INVAL;

  if (registration_done)
    {
      bse_server_registration (server, BSE_REGISTER_DONE, NULL, NULL);
      return BSE_ERROR_NONE;
    }
  registration_done = TRUE;

  slist = bse_plugin_dir_list_files (BSE_PATH_PLUGINS);
  g_object_set_data (server, "plugin-registration-queue", slist);

  slist = bse_ladspa_plugin_dir_list_files (BSE_PATH_LADSPA);
  paths = g_getenv ("LADSPA_PATH");
  if (paths)
    {
      GSList *slist2 = bse_ladspa_plugin_dir_list_files (paths);
      slist = g_slist_concat (slist, slist2);
    }
  g_object_set_data (server, "ladspa-registration-queue", slist);
  bse_idle_normal (register_plugins, server);

  return BSE_ERROR_NONE;
}

#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>

/* --- save-preferences --- */
static GType type_id_save_preferences = 0;
static void
save_preferences_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 495 "bseserver.proc"
 {
#line 497 "bseserver.proc"
  *(in_pspecs++) = bse_param_spec_object ("server", "Server", NULL,
				 BSE_TYPE_SERVER, SFI_PARAM_DEFAULT);
}
#line 496 "bseserver.proc"
  proc->help = "Request the bse-preferences property to be saved into BSE's configuration file.";
#line 33 "bseserver.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 34 "bseserver.proc"
  proc->copyright = "Copyright (C) 2001-2002 Tim Janik";
#line 500 "bseserver.proc"
 }
static BseErrorType
#line 500 "bseserver.proc"
save_preferences_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 503 "bseserver.proc"
{
#line 504 "bseserver.proc"
  
  BseServer *server = bse_value_get_object (in_values++);
  SfiWStore *wstore;
  gchar *file_name;
  GValue *value;
  SfiRec *rec;
  gint fd;
  
#line 512 "bseserver.proc"
  
  if (!BSE_IS_SERVER (server))
    return BSE_ERROR_PROC_PARAM_INVAL;

  file_name = g_strconcat (g_get_home_dir (), "/.bserc", NULL);
  fd = open (file_name,
#line 518 "bseserver.proc"
	     O_WRONLY | O_CREAT | O_TRUNC, 
	     0666);
  g_free (file_name);
  if (fd < 0)
    return BSE_ERROR_NONE;

  wstore = sfi_wstore_new ();
  sfi_wstore_printf (wstore, "; rc-file for BSE v%s\n", BSE_VERSION);

#line 527 "bseserver.proc"
  
  sfi_wstore_puts (wstore, "\n; BseGConfig Dump\n");
  rec = bse_gconfig_to_rec (bse_global_config);
  value = sfi_value_rec (rec);
  sfi_wstore_put_param (wstore, value, bse_gconfig_pspec ());
  sfi_value_free (value);
  sfi_rec_unref (rec);
  sfi_wstore_puts (wstore, "\n");

#line 536 "bseserver.proc"
  
  sfi_wstore_flush_fd (wstore, fd);
  sfi_wstore_destroy (wstore);
  close (fd);

  return BSE_ERROR_NONE;
}

/* --- Export to BSE --- */
BSE_EXPORTS_BEGIN (BSE_PLUGIN_NAME);
BSE_EXPORT_PROCEDURES = {
  { &type_id_use_new_project, "BseServer+use-new-project", NULL, 0, use_new_project_setup, use_new_project_exec, NULL, "/Method/BseServer/General/Use New Project", { 0, }, },
  { &type_id_get_midi_notifier, "BseServer+get-midi-notifier", NULL, 0, get_midi_notifier_setup, get_midi_notifier_exec, NULL, "/Method/BseServer/General/Get Midi Notifier", { 0, }, },
  { &type_id_can_load, "BseServer+can-load", NULL, 0, can_load_setup, can_load_exec, NULL, "/Method/BseServer/General/Can Load", { 0, }, },
  { &type_id_describe_note, "BseServer+describe-note", NULL, 0, describe_note_setup, describe_note_exec, NULL, "/Method/BseServer/General/Describe Note", { 0, }, },
  { &type_id_note_from_freq, "BseServer+note-from-freq", NULL, 0, note_from_freq_setup, note_from_freq_exec, NULL, "/Method/BseServer/General/Note From Freq", { 0, }, },
  { &type_id_note_from_string, "BseServer+note-from-string", NULL, 0, note_from_string_setup, note_from_string_exec, NULL, "/Method/BseServer/General/Note From String", { 0, }, },
  { &type_id_construct_note, "BseServer+construct-note", NULL, 0, construct_note_setup, construct_note_exec, NULL, "/Method/BseServer/General/Construct Note", { 0, }, },
  { &type_id_n_scripts, "BseServer+n-scripts", NULL, 0, n_scripts_setup, n_scripts_exec, NULL, "/Method/BseServer/General/N Scripts", { 0, }, },
  { &type_id_preferences_locked, "BseServer+preferences-locked", NULL, 0, preferences_locked_setup, preferences_locked_exec, NULL, "/Method/BseServer/General/Preferences Locked", { 0, }, },
  { &type_id_register_scripts, "BseServer+register-scripts", NULL, 0, register_scripts_setup, register_scripts_exec, NULL, "/Method/BseServer/General/Register Scripts", { 0, }, },
  { &type_id_register_plugins, "BseServer+register-plugins", NULL, 0, register_plugins_setup, register_plugins_exec, NULL, "/Method/BseServer/General/Register Plugins", { 0, }, },
  { &type_id_save_preferences, "BseServer+save-preferences", NULL, 0, save_preferences_setup, save_preferences_exec, NULL, "/Method/BseServer/General/Save Preferences", { 0, }, },
  { NULL, },
};
BSE_EXPORTS_END;

/**
 ** Generated data ends here
 **/
