
/**
 ** Generated data (by mkcproc.pl)
 **/
#line 1 "bsedatapocket.proc"

#include        <bse/bseplugin.h>
#include        <bse/bseprocedure.h>
#include        <bse/bsedatapocket.h>


#line 25 "bsedatapocket.proc"


/* --- create-entry --- */
static GType type_id_create_entry = 0;
static void
create_entry_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 27 "bsedatapocket.proc"
 {
#line 30 "bsedatapocket.proc"
  *(in_pspecs++) = bse_param_spec_object ("data_pocket", "Data Pocket", NULL,
				 BSE_TYPE_DATA_POCKET, SFI_PARAM_DEFAULT);
  *(out_pspecs++) = sfi_pspec_int ("entry_id", "Entry ID", "The unique pocket entry ID",
			 1, 1, G_MAXINT, 1, SFI_PARAM_DEFAULT);
#line 28 "bsedatapocket.proc"
  proc->help = ("Create a new entry in a data pocket. "
	   "Entries have a unique ID which is required to set values in a data pocket.");
#line 23 "bsedatapocket.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 24 "bsedatapocket.proc"
  proc->copyright = "Copyright (C) 2002 Tim Janik";
#line 34 "bsedatapocket.proc"
}  }
static BseErrorType
#line 34 "bsedatapocket.proc"
create_entry_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 37 "bsedatapocket.proc"
{
#line 38 "bsedatapocket.proc"
  
  BseDataPocket *pocket = bse_value_get_object (in_values++);
  guint id;
  
#line 42 "bsedatapocket.proc"
  
  if (!BSE_IS_DATA_POCKET (pocket))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 46 "bsedatapocket.proc"
  
  id = _bse_data_pocket_create_entry (pocket);
  
#line 49 "bsedatapocket.proc"
  
  sfi_value_set_int (out_values++, id);
  
  return BSE_ERROR_NONE;
}

/* --- delete-entry --- */
static GType type_id_delete_entry = 0;
static void
delete_entry_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 55 "bsedatapocket.proc"
 {
#line 57 "bsedatapocket.proc"
  *(in_pspecs++) = bse_param_spec_object ("data_pocket", "Data Pocket", NULL,
				 BSE_TYPE_DATA_POCKET, SFI_PARAM_DEFAULT);
  *(in_pspecs++) = sfi_pspec_int ("entry_id", "Entry ID", "The unique pocket entry ID",
			 1, 1, G_MAXINT, 1, SFI_PARAM_DEFAULT);
  *(out_pspecs++)   = bse_param_spec_genum ("error", "Error", "BSE error code",
				BSE_TYPE_ERROR_TYPE, BSE_ERROR_NONE,
				SFI_PARAM_DEFAULT);
#line 56 "bsedatapocket.proc"
  proc->help = "Delete an existing entry from a data pocket";
#line 23 "bsedatapocket.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 24 "bsedatapocket.proc"
  proc->copyright = "Copyright (C) 2002 Tim Janik";
#line 64 "bsedatapocket.proc"
}  }
static BseErrorType
#line 64 "bsedatapocket.proc"
delete_entry_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 67 "bsedatapocket.proc"
{
#line 68 "bsedatapocket.proc"
  
  BseDataPocket *pocket = bse_value_get_object (in_values++);
  guint id              = sfi_value_get_int (in_values++);
  gboolean fail = TRUE;
  
#line 73 "bsedatapocket.proc"
  
  if (!BSE_IS_DATA_POCKET (pocket))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 77 "bsedatapocket.proc"
  
  if (id)
    fail = _bse_data_pocket_delete_entry (pocket, id);
  
#line 81 "bsedatapocket.proc"
  
  g_value_set_enum (out_values++, fail ? BSE_ERROR_NO_ENTRY : BSE_ERROR_NONE);
  
  return BSE_ERROR_NONE;
}

/* --- get-n-entries --- */
static GType type_id_get_n_entries = 0;
static void
get_n_entries_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 87 "bsedatapocket.proc"
 {
#line 89 "bsedatapocket.proc"
  *(in_pspecs++) = bse_param_spec_object ("data_pocket", "Data Pocket", "The data pocket storing values",
				 BSE_TYPE_DATA_POCKET, SFI_PARAM_DEFAULT);
  *(out_pspecs++) = sfi_pspec_int ("n_entries", "N Entries", "The number of entries in use",
			 1, 0, G_MAXINT, 1, SFI_PARAM_DEFAULT);
#line 88 "bsedatapocket.proc"
  proc->help = "Retrieve the number of entries created in a data pocket.";
#line 23 "bsedatapocket.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 24 "bsedatapocket.proc"
  proc->copyright = "Copyright (C) 2002 Tim Janik";
#line 93 "bsedatapocket.proc"
}  }
static BseErrorType
#line 93 "bsedatapocket.proc"
get_n_entries_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 96 "bsedatapocket.proc"
{
#line 97 "bsedatapocket.proc"
  
  BseDataPocket *pocket = bse_value_get_object (in_values++);
  
#line 100 "bsedatapocket.proc"
  
  if (!BSE_IS_DATA_POCKET (pocket))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 104 "bsedatapocket.proc"
  
  sfi_value_set_int (out_values++, pocket->n_entries);
  
  return BSE_ERROR_NONE;
}

/* --- get-nth-entry-id --- */
static GType type_id_get_nth_entry_id = 0;
static void
get_nth_entry_id_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 110 "bsedatapocket.proc"
 {
#line 112 "bsedatapocket.proc"
  *(in_pspecs++) = bse_param_spec_object ("data_pocket", "Data Pocket", "The data pocket storing values",
				 BSE_TYPE_DATA_POCKET, SFI_PARAM_DEFAULT);
  *(in_pspecs++) = sfi_pspec_int ("entry_index", "Entry Index", "index into number of entries present",
			 0, 0, G_MAXINT, 1, SFI_PARAM_DEFAULT);
  *(out_pspecs++) = sfi_pspec_int ("entry_id", "Entry ID", "The unique pocket entry ID (or 0 if there's no such entry)",
			 0, 0, G_MAXINT, 1, SFI_PARAM_DEFAULT);
#line 111 "bsedatapocket.proc"
  proc->help = "Retrieve the ID of an entry in the data pocket by sequential index.";
#line 23 "bsedatapocket.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 24 "bsedatapocket.proc"
  proc->copyright = "Copyright (C) 2002 Tim Janik";
#line 118 "bsedatapocket.proc"
}  }
static BseErrorType
#line 118 "bsedatapocket.proc"
get_nth_entry_id_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 121 "bsedatapocket.proc"
{
#line 122 "bsedatapocket.proc"
  
  BseDataPocket *pocket = bse_value_get_object (in_values++);
  guint index           = sfi_value_get_int (in_values++);
  
#line 126 "bsedatapocket.proc"
  
  if (!BSE_IS_DATA_POCKET (pocket))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 130 "bsedatapocket.proc"
  
  sfi_value_set_int (out_values++, index < pocket->n_entries ? pocket->entries[index].id : 0);
  
  return BSE_ERROR_NONE;
}

/* --- set-float --- */
static GType type_id_set_float = 0;
static void
set_float_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 136 "bsedatapocket.proc"
 {
#line 140 "bsedatapocket.proc"
  *(in_pspecs++) = bse_param_spec_object ("data_pocket", "Data Pocket", "The data pocket storing values",
				 BSE_TYPE_DATA_POCKET, SFI_PARAM_DEFAULT);
  *(in_pspecs++) = sfi_pspec_int ("entry_id", "Entry ID", "The unique pocket entry ID",
			 1, 1, G_MAXINT, 1, SFI_PARAM_DEFAULT);
  *(in_pspecs++) = sfi_pspec_string ("name", "Name", "Name for the value",
			    NULL, SFI_PARAM_DEFAULT);
  *(in_pspecs++) = sfi_pspec_real ("number", "Number", "The value to store in the data pocket entry",
			  0, -G_MAXDOUBLE, G_MAXDOUBLE, 1, SFI_PARAM_DEFAULT);
  *(out_pspecs++)   = bse_param_spec_genum ("error", "Error", "BSE error code",
				BSE_TYPE_ERROR_TYPE, BSE_ERROR_NONE,
				SFI_PARAM_DEFAULT);
#line 137 "bsedatapocket.proc"
  proc->help = ("Set a named floating point value in a data pocket entry. "
	   "Names are required to distinguish different values from each other "
	   "when accessing values in a data pocket.");
#line 23 "bsedatapocket.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 24 "bsedatapocket.proc"
  proc->copyright = "Copyright (C) 2002 Tim Janik";
#line 151 "bsedatapocket.proc"
}  }
static BseErrorType
#line 151 "bsedatapocket.proc"
set_float_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 154 "bsedatapocket.proc"
{
#line 155 "bsedatapocket.proc"
  
  BseDataPocket *pocket = bse_value_get_object (in_values++);
  guint id              = sfi_value_get_int (in_values++);
  gchar *name           = sfi_value_get_string (in_values++);
  gfloat v_float        = sfi_value_get_real (in_values++);
  BseDataPocketValue value;
  gboolean success = FALSE;
  
#line 163 "bsedatapocket.proc"
  
  if (!BSE_IS_DATA_POCKET (pocket))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 167 "bsedatapocket.proc"
  
  value.v_float = v_float;
  if (id)
    success = _bse_data_pocket_entry_set (pocket, id, g_quark_from_string (name), BSE_DATA_POCKET_FLOAT, value);
  
#line 172 "bsedatapocket.proc"
  
  g_value_set_enum (out_values++, success ? BSE_ERROR_NONE : BSE_ERROR_NO_ENTRY);
  
  return BSE_ERROR_NONE;
}

/* --- set-int --- */
static GType type_id_set_int = 0;
static void
set_int_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 178 "bsedatapocket.proc"
 {
#line 182 "bsedatapocket.proc"
  *(in_pspecs++) = bse_param_spec_object ("data_pocket", "Data Pocket", "The data pocket storing values",
				 BSE_TYPE_DATA_POCKET, SFI_PARAM_DEFAULT);
  *(in_pspecs++) = sfi_pspec_int ("entry_id", "Entry ID", "The unique pocket entry ID",
			 1, 1, G_MAXINT, 1, SFI_PARAM_DEFAULT);
  *(in_pspecs++) = sfi_pspec_string ("name", "Name", "Name for the value",
			    0, SFI_PARAM_DEFAULT);
  *(in_pspecs++) = sfi_pspec_int ("number", "Number", "The value to store in the data pocket entry",
			 0, G_MININT, G_MAXINT, 1, SFI_PARAM_DEFAULT);
  *(out_pspecs++)   = bse_param_spec_genum ("error", "Error", "BSE error code",
				BSE_TYPE_ERROR_TYPE, BSE_ERROR_NONE,
				SFI_PARAM_DEFAULT);
#line 179 "bsedatapocket.proc"
  proc->help = ("Set a named integer value in a data pocket entry. "
	   "Names are required to distinguish different values from each other "
	   "when accessing values in a data pocket.");
#line 23 "bsedatapocket.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 24 "bsedatapocket.proc"
  proc->copyright = "Copyright (C) 2002 Tim Janik";
#line 193 "bsedatapocket.proc"
}  }
static BseErrorType
#line 193 "bsedatapocket.proc"
set_int_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 196 "bsedatapocket.proc"
{
#line 197 "bsedatapocket.proc"
  
  BseDataPocket *pocket = bse_value_get_object (in_values++);
  guint id              = sfi_value_get_int (in_values++);
  gchar *name           = sfi_value_get_string (in_values++);
  guint v_uint          = sfi_value_get_int (in_values++);
  BseDataPocketValue value;
  gboolean success = FALSE;
  
#line 205 "bsedatapocket.proc"
  
  if (!BSE_IS_DATA_POCKET (pocket))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 209 "bsedatapocket.proc"
  
  value.v_int = v_uint;
  if (id)
    success = _bse_data_pocket_entry_set (pocket, id, g_quark_from_string (name), BSE_DATA_POCKET_INT, value);
  
#line 214 "bsedatapocket.proc"
  
  g_value_set_enum (out_values++, success ? BSE_ERROR_NONE : BSE_ERROR_NO_ENTRY);
  
  return BSE_ERROR_NONE;
}

/* --- set-object --- */
static GType type_id_set_object = 0;
static void
set_object_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 220 "bsedatapocket.proc"
 {
#line 224 "bsedatapocket.proc"
  *(in_pspecs++) = bse_param_spec_object ("data_pocket", "Data Pocket", "The data pocket storing values",
				 BSE_TYPE_DATA_POCKET, SFI_PARAM_DEFAULT);
  *(in_pspecs++) = sfi_pspec_int ("entry_id", "Entry ID", "The unique pocket entry ID",
			 1, 1, G_MAXINT, 1, SFI_PARAM_DEFAULT);
  *(in_pspecs++) = sfi_pspec_string ("name", "Name", "Name for the value",
			    0, SFI_PARAM_DEFAULT);
  *(in_pspecs++) = bse_param_spec_object ("item", "Item", "The value to store in the data pocket entry",
				 BSE_TYPE_ITEM, SFI_PARAM_DEFAULT);
  *(out_pspecs++)   = bse_param_spec_genum ("error", "Error", "BSE error code",
				BSE_TYPE_ERROR_TYPE, BSE_ERROR_NONE,
				SFI_PARAM_DEFAULT);
#line 221 "bsedatapocket.proc"
  proc->help = ("Set a named object reference in a data pocket entry. "
	   "Object references stored in a data pocket must exist within the "
	   "same project that the data pocket belongs to");
#line 23 "bsedatapocket.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 24 "bsedatapocket.proc"
  proc->copyright = "Copyright (C) 2002 Tim Janik";
#line 235 "bsedatapocket.proc"
}  }
static BseErrorType
#line 235 "bsedatapocket.proc"
set_object_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 238 "bsedatapocket.proc"
{
#line 239 "bsedatapocket.proc"
  
  BseDataPocket *pocket = bse_value_get_object (in_values++);
  guint id              = sfi_value_get_int (in_values++);
  gchar *name           = sfi_value_get_string (in_values++);
  BseItem *v_object     = bse_value_get_object (in_values++);
  BseDataPocketValue value;
  gboolean success = FALSE;
  
#line 247 "bsedatapocket.proc"
  
  if (!BSE_IS_DATA_POCKET (pocket) ||
      (v_object && !bse_item_common_ancestor ((BseItem*) pocket, v_object)))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 252 "bsedatapocket.proc"
  
  value.v_object = v_object;
  if (id)
    success = _bse_data_pocket_entry_set (pocket, id, g_quark_from_string (name), BSE_DATA_POCKET_OBJECT, value);
  
#line 257 "bsedatapocket.proc"
  
  g_value_set_enum (out_values++, success ? BSE_ERROR_NONE : BSE_ERROR_NO_ENTRY);
  
  return BSE_ERROR_NONE;
}

/* --- set-string --- */
static GType type_id_set_string = 0;
static void
set_string_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 263 "bsedatapocket.proc"
 {
#line 265 "bsedatapocket.proc"
  *(in_pspecs++) = bse_param_spec_object ("data_pocket", "Data Pocket", "The data pocket storing values",
				 BSE_TYPE_DATA_POCKET, SFI_PARAM_DEFAULT);
  *(in_pspecs++) = sfi_pspec_int ("entry_id", "Entry ID", "The unique pocket entry ID",
			 1, 1, G_MAXINT, 1, SFI_PARAM_DEFAULT);
  *(in_pspecs++) = sfi_pspec_string ("name", "Name", "Name for the value",
			    0, SFI_PARAM_DEFAULT);
  *(in_pspecs++) = sfi_pspec_string ("string", "String", "The value to store in the data pocket entry",
			    0, SFI_PARAM_DEFAULT);
  *(out_pspecs++)   = bse_param_spec_genum ("error", "Error", "BSE error code",
				BSE_TYPE_ERROR_TYPE, BSE_ERROR_NONE,
				SFI_PARAM_DEFAULT);
#line 264 "bsedatapocket.proc"
  proc->help = ("Set a named string in a data pocket entry.");
#line 23 "bsedatapocket.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 24 "bsedatapocket.proc"
  proc->copyright = "Copyright (C) 2002 Tim Janik";
#line 276 "bsedatapocket.proc"
}  }
static BseErrorType
#line 276 "bsedatapocket.proc"
set_string_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 279 "bsedatapocket.proc"
{
#line 280 "bsedatapocket.proc"
  
  BseDataPocket *pocket = bse_value_get_object (in_values++);
  guint id              = sfi_value_get_int (in_values++);
  gchar *name           = sfi_value_get_string (in_values++);
  gchar *v_string       = sfi_value_get_string (in_values++);
  BseDataPocketValue value;
  gboolean success = FALSE;
  
#line 288 "bsedatapocket.proc"
  
  if (!BSE_IS_DATA_POCKET (pocket))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 292 "bsedatapocket.proc"
  
  value.v_string = v_string;
  if (id)
    success = _bse_data_pocket_entry_set (pocket, id, g_quark_from_string (name), BSE_DATA_POCKET_STRING, value);
  
#line 297 "bsedatapocket.proc"
  
  g_value_set_enum (out_values++, success ? BSE_ERROR_NONE : BSE_ERROR_NO_ENTRY);
  
  return BSE_ERROR_NONE;
}

/* --- get-float --- */
static GType type_id_get_float = 0;
static void
get_float_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 303 "bsedatapocket.proc"
 {
#line 305 "bsedatapocket.proc"
  *(in_pspecs++) = bse_param_spec_object ("data_pocket", "Data Pocket", "The data pocket storing values",
				 BSE_TYPE_DATA_POCKET, SFI_PARAM_DEFAULT);
  *(in_pspecs++) = sfi_pspec_int ("entry_id", "Entry ID", "The unique pocket entry ID",
			 1, 1, G_MAXINT, 1, SFI_PARAM_DEFAULT);
  *(in_pspecs++) = sfi_pspec_string ("name", "Name", "Name for the value",
			    0, SFI_PARAM_DEFAULT);
  *(out_pspecs++) = sfi_pspec_real ("number", "Number", "The value stored in the data pocket entry",
			  0, -G_MAXDOUBLE, G_MAXDOUBLE, 1, SFI_PARAM_DEFAULT);
#line 304 "bsedatapocket.proc"
  proc->help = "Retrieve a previously set floating point value from a data pocket entry.";
#line 23 "bsedatapocket.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 24 "bsedatapocket.proc"
  proc->copyright = "Copyright (C) 2002 Tim Janik";
#line 313 "bsedatapocket.proc"
}  }
static BseErrorType
#line 313 "bsedatapocket.proc"
get_float_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 316 "bsedatapocket.proc"
{
#line 317 "bsedatapocket.proc"
  
  BseDataPocket *pocket = bse_value_get_object (in_values++);
  guint id              = sfi_value_get_int (in_values++);
  gchar *name           = sfi_value_get_string (in_values++);
  BseDataPocketValue value = { 0, };
  gchar type;
  
#line 324 "bsedatapocket.proc"
  
  if (!BSE_IS_DATA_POCKET (pocket))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 328 "bsedatapocket.proc"
  
  type = _bse_data_pocket_entry_get (pocket, id, g_quark_try_string (name), &value);
  
#line 331 "bsedatapocket.proc"
  
  sfi_value_set_real (out_values++, type == BSE_DATA_POCKET_FLOAT ? value.v_float : 0);
  
  return BSE_ERROR_NONE;
}

/* --- get-int --- */
static GType type_id_get_int = 0;
static void
get_int_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 337 "bsedatapocket.proc"
 {
#line 339 "bsedatapocket.proc"
  *(in_pspecs++) = bse_param_spec_object ("data_pocket", "Data Pocket", "The data pocket storing values",
				 BSE_TYPE_DATA_POCKET, SFI_PARAM_DEFAULT);
  *(in_pspecs++) = sfi_pspec_int ("entry_id", "Entry ID", "The unique pocket entry ID",
			 1, 1, G_MAXINT, 1, SFI_PARAM_DEFAULT);
  *(in_pspecs++) = sfi_pspec_string ("name", "Name", "Name for the value",
			    0, SFI_PARAM_DEFAULT);
  *(out_pspecs++) = sfi_pspec_int ("number", "Number", "The value stored in the data pocket entry",
			 0, G_MININT, G_MAXINT, 1, SFI_PARAM_DEFAULT);
#line 338 "bsedatapocket.proc"
  proc->help = "Retrieve a previously set integer value from a data pocket entry.";
#line 23 "bsedatapocket.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 24 "bsedatapocket.proc"
  proc->copyright = "Copyright (C) 2002 Tim Janik";
#line 347 "bsedatapocket.proc"
}  }
static BseErrorType
#line 347 "bsedatapocket.proc"
get_int_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 350 "bsedatapocket.proc"
{
#line 351 "bsedatapocket.proc"
  
  BseDataPocket *pocket = bse_value_get_object (in_values++);
  guint id              = sfi_value_get_int (in_values++);
  gchar *name           = sfi_value_get_string (in_values++);
  BseDataPocketValue value = { 0, };
  gchar type;
  
#line 358 "bsedatapocket.proc"
  
  if (!BSE_IS_DATA_POCKET (pocket))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 362 "bsedatapocket.proc"
  
  type = _bse_data_pocket_entry_get (pocket, id, g_quark_try_string (name), &value);
  
#line 365 "bsedatapocket.proc"
  
  sfi_value_set_int (out_values++, type == BSE_DATA_POCKET_INT ? value.v_int : 0);
  
  return BSE_ERROR_NONE;
}

/* --- get-object --- */
static GType type_id_get_object = 0;
static void
get_object_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 371 "bsedatapocket.proc"
 {
#line 373 "bsedatapocket.proc"
  *(in_pspecs++) = bse_param_spec_object ("data_pocket", "Data Pocket", "The data pocket storing values",
				 BSE_TYPE_DATA_POCKET, SFI_PARAM_DEFAULT);
  *(in_pspecs++) = sfi_pspec_int ("entry_id", "Entry ID", "The unique pocket entry ID",
			 1, 1, G_MAXINT, 1, SFI_PARAM_DEFAULT);
  *(in_pspecs++) = sfi_pspec_string ("name", "Name", "Name for the value",
			    0, SFI_PARAM_DEFAULT);
  *(out_pspecs++)   = bse_param_spec_object ("item", "Item", "The value stored in the data pocket entry",
				 BSE_TYPE_ITEM, SFI_PARAM_DEFAULT);
#line 372 "bsedatapocket.proc"
  proc->help = "Retrieve a previously set object reference from a data pocket entry.";
#line 23 "bsedatapocket.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 24 "bsedatapocket.proc"
  proc->copyright = "Copyright (C) 2002 Tim Janik";
#line 381 "bsedatapocket.proc"
}  }
static BseErrorType
#line 381 "bsedatapocket.proc"
get_object_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 384 "bsedatapocket.proc"
{
#line 385 "bsedatapocket.proc"
  
  BseDataPocket *pocket = bse_value_get_object (in_values++);
  guint id              = sfi_value_get_int (in_values++);
  gchar *name           = sfi_value_get_string (in_values++);
  BseDataPocketValue value = { 0, };
  gchar type;
  
#line 392 "bsedatapocket.proc"
  
  if (!BSE_IS_DATA_POCKET (pocket))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 396 "bsedatapocket.proc"
  
  type = _bse_data_pocket_entry_get (pocket, id, g_quark_try_string (name), &value);
  
#line 399 "bsedatapocket.proc"
  
  bse_value_set_object (out_values++, type == BSE_DATA_POCKET_OBJECT ? value.v_object : 0);
  
  return BSE_ERROR_NONE;
}

/* --- get-string --- */
static GType type_id_get_string = 0;
static void
get_string_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 405 "bsedatapocket.proc"
 {
#line 407 "bsedatapocket.proc"
  *(in_pspecs++) = bse_param_spec_object ("data_pocket", "Data Pocket", "The data pocket storing values",
				 BSE_TYPE_DATA_POCKET, SFI_PARAM_DEFAULT);
  *(in_pspecs++) = sfi_pspec_int ("entry_id", "Entry ID", "The unique pocket entry ID",
			 1, 1, G_MAXINT, 1, SFI_PARAM_DEFAULT);
  *(in_pspecs++) = sfi_pspec_string ("name", "Name", "Name for the value",
			    0, SFI_PARAM_DEFAULT);
  *(out_pspecs++)   = sfi_pspec_string ("string", "String", "The value stored in the data pocket entry",
			    0, SFI_PARAM_DEFAULT);
#line 406 "bsedatapocket.proc"
  proc->help = "Retrieve a previously set string from a data pocket entry.";
#line 23 "bsedatapocket.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 24 "bsedatapocket.proc"
  proc->copyright = "Copyright (C) 2002 Tim Janik";
#line 415 "bsedatapocket.proc"
}  }
static BseErrorType
#line 415 "bsedatapocket.proc"
get_string_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 418 "bsedatapocket.proc"
{
#line 419 "bsedatapocket.proc"
  
  BseDataPocket *pocket = bse_value_get_object (in_values++);
  guint id              = sfi_value_get_int (in_values++);
  gchar *name           = sfi_value_get_string (in_values++);
  BseDataPocketValue value = { 0, };
  gchar type;
  
#line 426 "bsedatapocket.proc"
  
  if (!BSE_IS_DATA_POCKET (pocket))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 430 "bsedatapocket.proc"
  
  type = _bse_data_pocket_entry_get (pocket, id, g_quark_try_string (name), &value);
  
#line 433 "bsedatapocket.proc"
  
  sfi_value_set_string (out_values++, type == BSE_DATA_POCKET_STRING ? value.v_string : 0);
  
  return BSE_ERROR_NONE;
}

/* --- Export to BSE --- */
BSE_EXPORTS_BEGIN (BSE_PLUGIN_NAME);
BSE_EXPORT_PROCEDURES = {
  { &type_id_create_entry, "BseDataPocket+create-entry", NULL, 0, create_entry_setup, create_entry_exec, NULL, "/Method/BseDataPocket/General/Create Entry", { 0, }, },
  { &type_id_delete_entry, "BseDataPocket+delete-entry", NULL, 0, delete_entry_setup, delete_entry_exec, NULL, "/Method/BseDataPocket/General/Delete Entry", { 0, }, },
  { &type_id_get_n_entries, "BseDataPocket+get-n-entries", NULL, 0, get_n_entries_setup, get_n_entries_exec, NULL, "/Method/BseDataPocket/General/Get N Entries", { 0, }, },
  { &type_id_get_nth_entry_id, "BseDataPocket+get-nth-entry-id", NULL, 0, get_nth_entry_id_setup, get_nth_entry_id_exec, NULL, "/Method/BseDataPocket/General/Get Nth Entry Id", { 0, }, },
  { &type_id_set_float, "BseDataPocket+set-float", NULL, 0, set_float_setup, set_float_exec, NULL, "/Method/BseDataPocket/General/Set Float", { 0, }, },
  { &type_id_set_int, "BseDataPocket+set-int", NULL, 0, set_int_setup, set_int_exec, NULL, "/Method/BseDataPocket/General/Set Int", { 0, }, },
  { &type_id_set_object, "BseDataPocket+set-object", NULL, 0, set_object_setup, set_object_exec, NULL, "/Method/BseDataPocket/General/Set Object", { 0, }, },
  { &type_id_set_string, "BseDataPocket+set-string", NULL, 0, set_string_setup, set_string_exec, NULL, "/Method/BseDataPocket/General/Set String", { 0, }, },
  { &type_id_get_float, "BseDataPocket+get-float", NULL, 0, get_float_setup, get_float_exec, NULL, "/Method/BseDataPocket/General/Get Float", { 0, }, },
  { &type_id_get_int, "BseDataPocket+get-int", NULL, 0, get_int_setup, get_int_exec, NULL, "/Method/BseDataPocket/General/Get Int", { 0, }, },
  { &type_id_get_object, "BseDataPocket+get-object", NULL, 0, get_object_setup, get_object_exec, NULL, "/Method/BseDataPocket/General/Get Object", { 0, }, },
  { &type_id_get_string, "BseDataPocket+get-string", NULL, 0, get_string_setup, get_string_exec, NULL, "/Method/BseDataPocket/General/Get String", { 0, }, },
  { NULL, },
};
BSE_EXPORTS_END;

/**
 ** Generated data ends here
 **/
