
/**
 ** Generated data (by mkcproc.pl)
 **/
#line 1 "bseitem.proc"

#include        <bse/bseplugin.h>
#include        <bse/bseprocedure.h>
#include        <bse/bseitem.h>
#include        <bse/bsecontainer.h>
#include        <bse/bswprivate.h>


#line 29 "bseitem.proc"


/* --- get-type --- */
static GType type_id_get_type = 0;
static void
get_type_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 31 "bseitem.proc"
 {
#line 33 "bseitem.proc"
  *(in_pspecs++) = g_param_spec_object ("item", "Item", NULL,
			       BSE_TYPE_ITEM, BSE_PARAM_DEFAULT);
  *(out_pspecs++) = g_param_spec_ulong ("type_id", "Type ID", NULL,
			      0, G_MAXULONG, 0,
			      BSE_PARAM_DEFAULT);
#line 32 "bseitem.proc"
  proc->help = "Retrive an item's type ID.";
#line 26 "bseitem.proc"
  proc->author = "Tim Janik <timj@gtk.org>";
#line 27 "bseitem.proc"
  proc->copyright = "Tim Janik";
#line 28 "bseitem.proc"
  proc->date = "2001";
#line 38 "bseitem.proc"
}  }
static BseErrorType
#line 38 "bseitem.proc"
get_type_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 41 "bseitem.proc"
{
#line 42 "bseitem.proc"
  
  BseItem *item = (BseItem*) g_value_get_object (in_values++);
  
#line 45 "bseitem.proc"
  
  if (!BSE_IS_ITEM (item))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 49 "bseitem.proc"
  
  g_value_set_ulong (out_values++, G_OBJECT_TYPE (item));
  
  return BSE_ERROR_NONE;
}

/* --- get-type-name --- */
static GType type_id_get_type_name = 0;
static void
get_type_name_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 55 "bseitem.proc"
 {
#line 57 "bseitem.proc"
  *(in_pspecs++) = g_param_spec_object ("item", "Item", NULL,
			       BSE_TYPE_ITEM, BSE_PARAM_DEFAULT);
  *(out_pspecs++) = g_param_spec_string ("type_name", "Type Name", NULL,
			       NULL,
			       BSE_PARAM_DEFAULT);
#line 56 "bseitem.proc"
  proc->help = "Retrieve an item's type name.";
#line 26 "bseitem.proc"
  proc->author = "Tim Janik <timj@gtk.org>";
#line 27 "bseitem.proc"
  proc->copyright = "Tim Janik";
#line 28 "bseitem.proc"
  proc->date = "2001";
#line 62 "bseitem.proc"
}  }
static BseErrorType
#line 62 "bseitem.proc"
get_type_name_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 65 "bseitem.proc"
{
#line 66 "bseitem.proc"
  
  BseItem *item = (BseItem*) g_value_get_object (in_values++);
  
#line 69 "bseitem.proc"
  
  if (!BSE_IS_ITEM (item))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 73 "bseitem.proc"
  
  g_value_set_string (out_values++, g_type_name (G_OBJECT_TYPE (item)));
  
  return BSE_ERROR_NONE;
}

/* --- get-type-blurb --- */
static GType type_id_get_type_blurb = 0;
static void
get_type_blurb_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 79 "bseitem.proc"
 {
#line 81 "bseitem.proc"
  *(in_pspecs++) = g_param_spec_object ("item", "Item", NULL,
			       BSE_TYPE_ITEM, BSE_PARAM_DEFAULT);
  *(out_pspecs++) = g_param_spec_string ("type_blurb", "Type Blurb", NULL,
			       NULL,
			       BSE_PARAM_DEFAULT);
#line 80 "bseitem.proc"
  proc->help = "Retrieve an item's type description.";
#line 26 "bseitem.proc"
  proc->author = "Tim Janik <timj@gtk.org>";
#line 27 "bseitem.proc"
  proc->copyright = "Tim Janik";
#line 28 "bseitem.proc"
  proc->date = "2001";
#line 86 "bseitem.proc"
}  }
static BseErrorType
#line 86 "bseitem.proc"
get_type_blurb_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 89 "bseitem.proc"
{
#line 90 "bseitem.proc"
  
  BseItem *item = (BseItem*) g_value_get_object (in_values++);
  
#line 93 "bseitem.proc"
  
  if (!BSE_IS_ITEM (item))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 97 "bseitem.proc"
  
  g_value_set_string (out_values++, bse_type_blurb (G_OBJECT_TYPE (item)));
  
  return BSE_ERROR_NONE;
}

/* --- get-parent --- */
static GType type_id_get_parent = 0;
static void
get_parent_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 103 "bseitem.proc"
 {
#line 105 "bseitem.proc"
  *(in_pspecs++) = g_param_spec_object ("item", "Item", NULL,
			       BSE_TYPE_ITEM, BSE_PARAM_DEFAULT);
  *(out_pspecs++) = g_param_spec_object ("parent", "Parent", NULL,
			       BSE_TYPE_ITEM, BSE_PARAM_DEFAULT);
#line 104 "bseitem.proc"
  proc->help = "Retrive an item's parent.";
#line 26 "bseitem.proc"
  proc->author = "Tim Janik <timj@gtk.org>";
#line 27 "bseitem.proc"
  proc->copyright = "Tim Janik";
#line 28 "bseitem.proc"
  proc->date = "2001";
#line 109 "bseitem.proc"
}  }
static BseErrorType
#line 109 "bseitem.proc"
get_parent_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 112 "bseitem.proc"
{
#line 113 "bseitem.proc"
  
  BseItem *item = (BseItem*) g_value_get_object (in_values++);
  
#line 116 "bseitem.proc"
  
  if (!BSE_IS_ITEM (item))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 120 "bseitem.proc"
  
  g_value_set_object (out_values++, item->parent);
  
  return BSE_ERROR_NONE;
}

/* --- get-project --- */
static GType type_id_get_project = 0;
static void
get_project_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 126 "bseitem.proc"
 {
#line 128 "bseitem.proc"
  *(in_pspecs++) = g_param_spec_object ("item", "Item", NULL,
			       BSE_TYPE_ITEM, BSE_PARAM_DEFAULT);
  *(out_pspecs++) = g_param_spec_object ("project", "Project", NULL,
			       BSE_TYPE_ITEM, BSE_PARAM_DEFAULT);
#line 127 "bseitem.proc"
  proc->help = "Retrive an item's project.";
#line 26 "bseitem.proc"
  proc->author = "Tim Janik <timj@gtk.org>";
#line 27 "bseitem.proc"
  proc->copyright = "Tim Janik";
#line 28 "bseitem.proc"
  proc->date = "2001";
#line 132 "bseitem.proc"
}  }
static BseErrorType
#line 132 "bseitem.proc"
get_project_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 135 "bseitem.proc"
{
#line 136 "bseitem.proc"
  
  BseItem *item = (BseItem*) g_value_get_object (in_values++);
  
#line 139 "bseitem.proc"
  
  if (!BSE_IS_ITEM (item))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 143 "bseitem.proc"
  
  g_value_set_object (out_values++, bse_item_get_project (item));
  
  return BSE_ERROR_NONE;
}

/* --- get-uname-path --- */
static GType type_id_get_uname_path = 0;
static void
get_uname_path_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 149 "bseitem.proc"
 {
#line 151 "bseitem.proc"
  *(in_pspecs++) = g_param_spec_object ("item", NULL, NULL,
			       BSE_TYPE_ITEM, BSE_PARAM_DEFAULT);
  *(out_pspecs++) = g_param_spec_string ("uloc_path", NULL, NULL,
			       NULL, BSE_PARAM_DEFAULT);
#line 150 "bseitem.proc"
  proc->help = "Retrieve the project relative uname path for this item.";
#line 26 "bseitem.proc"
  proc->author = "Tim Janik <timj@gtk.org>";
#line 27 "bseitem.proc"
  proc->copyright = "Tim Janik";
#line 28 "bseitem.proc"
  proc->date = "2001";
#line 155 "bseitem.proc"
}  }
static BseErrorType
#line 155 "bseitem.proc"
get_uname_path_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 158 "bseitem.proc"
{
#line 159 "bseitem.proc"
  
  BseItem *item = g_value_get_object (in_values++);
  BseProject *project;

#line 163 "bseitem.proc"
  
  if (!BSE_IS_ITEM (item))
    return BSE_ERROR_PROC_PARAM_INVAL;

  project = bse_item_get_project (item);

#line 169 "bseitem.proc"
  
  g_value_set_string_take_ownership (out_values++,
				     project ? bse_container_make_upath (BSE_CONTAINER (project), item) : NULL);
  
  return BSE_ERROR_NONE;
}

/* --- use --- */
static GType type_id_use = 0;
static void
use_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 176 "bseitem.proc"
 {
#line 178 "bseitem.proc"
  *(in_pspecs++) = g_param_spec_object ("item", "Item", NULL,
			       BSE_TYPE_ITEM, BSE_PARAM_DEFAULT);
  *(out_pspecs++) = g_param_spec_object ("used_item", "Item", NULL,
			       BSE_TYPE_ITEM, BSE_PARAM_DEFAULT);
#line 177 "bseitem.proc"
  proc->help = "Increment use count to keep an item alive.";
#line 26 "bseitem.proc"
  proc->author = "Tim Janik <timj@gtk.org>";
#line 27 "bseitem.proc"
  proc->copyright = "Tim Janik";
#line 28 "bseitem.proc"
  proc->date = "2001";
#line 182 "bseitem.proc"
}  }
static BseErrorType
#line 182 "bseitem.proc"
use_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 185 "bseitem.proc"
{
#line 186 "bseitem.proc"
  
  BseItem *item = (BseItem*) g_value_get_object (in_values++);
  
#line 189 "bseitem.proc"
  
  if (!BSE_IS_ITEM (item))
    return BSE_ERROR_PROC_PARAM_INVAL;

#line 193 "bseitem.proc"
  
  bse_item_use (item);

#line 196 "bseitem.proc"
  
  g_value_set_object (out_values++, item);
				     
  return BSE_ERROR_NONE;
}

/* --- unuse --- */
static GType type_id_unuse = 0;
static void
unuse_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 202 "bseitem.proc"
 {
#line 204 "bseitem.proc"
  *(in_pspecs++) = g_param_spec_object ("item", "Item", NULL,
			       BSE_TYPE_ITEM, BSE_PARAM_DEFAULT);
#line 203 "bseitem.proc"
  proc->help = "Decrement use count for when an item is not needed anymore.";
#line 26 "bseitem.proc"
  proc->author = "Tim Janik <timj@gtk.org>";
#line 27 "bseitem.proc"
  proc->copyright = "Tim Janik";
#line 28 "bseitem.proc"
  proc->date = "2001";
#line 206 "bseitem.proc"
}  }
static BseErrorType
#line 206 "bseitem.proc"
unuse_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 209 "bseitem.proc"
{
#line 210 "bseitem.proc"
  
  BseItem *item = (BseItem*) g_value_get_object (in_values++);
  
#line 213 "bseitem.proc"
  
  if (!BSE_IS_ITEM (item))
    return BSE_ERROR_PROC_PARAM_INVAL;

#line 217 "bseitem.proc"
  
  if (item->use_count < 1)
    return BSE_ERROR_NOT_OWNER;

  item->use_count--;
  if (!item->use_count)
    bse_object_unref (item);

#line 225 "bseitem.proc"
  
  
  return BSE_ERROR_NONE;
}

/* --- get-name --- */
static GType type_id_get_name = 0;
static void
get_name_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 230 "bseitem.proc"
 {
#line 232 "bseitem.proc"
  *(in_pspecs++) = g_param_spec_object ("item", "Item", NULL,
			       BSE_TYPE_ITEM, BSE_PARAM_DEFAULT);
  *(out_pspecs++) = g_param_spec_string ("name", "Name", NULL,
			       NULL, BSE_PARAM_DEFAULT);
#line 231 "bseitem.proc"
  proc->help = "Retrive an item's name.";
#line 26 "bseitem.proc"
  proc->author = "Tim Janik <timj@gtk.org>";
#line 27 "bseitem.proc"
  proc->copyright = "Tim Janik";
#line 28 "bseitem.proc"
  proc->date = "2001";
#line 236 "bseitem.proc"
}  }
static BseErrorType
#line 236 "bseitem.proc"
get_name_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 239 "bseitem.proc"
{
#line 240 "bseitem.proc"
  
  BseItem *item = (BseItem*) g_value_get_object (in_values++);

#line 243 "bseitem.proc"
  
  if (!BSE_IS_ITEM (item))
    return BSE_ERROR_PROC_PARAM_INVAL;

#line 247 "bseitem.proc"
  
  g_value_set_string (out_values++, BSE_OBJECT_UNAME (item));
  
  return BSE_ERROR_NONE;
}

/* --- get-name-or-type --- */
static GType type_id_get_name_or_type = 0;
static void
get_name_or_type_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 253 "bseitem.proc"
 {
#line 255 "bseitem.proc"
  *(in_pspecs++) = g_param_spec_object ("item", "Item", NULL,
			       BSE_TYPE_ITEM, BSE_PARAM_DEFAULT);
  *(out_pspecs++) = g_param_spec_string ("name", "Name", NULL,
			       NULL, BSE_PARAM_DEFAULT);
#line 254 "bseitem.proc"
  proc->help = "Retrive an item's name or type if it has no name.";
#line 26 "bseitem.proc"
  proc->author = "Tim Janik <timj@gtk.org>";
#line 27 "bseitem.proc"
  proc->copyright = "Tim Janik";
#line 28 "bseitem.proc"
  proc->date = "2001";
#line 259 "bseitem.proc"
}  }
static BseErrorType
#line 259 "bseitem.proc"
get_name_or_type_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 262 "bseitem.proc"
{
#line 263 "bseitem.proc"
  
  BseItem *item = (BseItem*) g_value_get_object (in_values++);
  gchar *name = NULL;

#line 267 "bseitem.proc"
  
  if (!BSE_IS_ITEM (item))
    return BSE_ERROR_PROC_PARAM_INVAL;

#line 271 "bseitem.proc"
  
  name = BSE_OBJECT_UNAME (item);
  if (name)
    g_value_set_string (out_values++, name);
  else
    g_value_set_string (out_values++, BSE_OBJECT_TYPE_NAME (item));
  
  return BSE_ERROR_NONE;
}

/* --- common-ancestor --- */
static GType type_id_common_ancestor = 0;
static void
common_ancestor_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 281 "bseitem.proc"
 {
#line 283 "bseitem.proc"
  *(in_pspecs++) = g_param_spec_object ("item", "Item", "First item",
			       BSE_TYPE_ITEM, BSE_PARAM_DEFAULT);
  *(in_pspecs++) = g_param_spec_object ("item2", "Item2", "Second item",
			       BSE_TYPE_ITEM, BSE_PARAM_DEFAULT);
  *(out_pspecs++) = g_param_spec_object ("ancestor", "ancestor", "Common ancestor of both items",
			       BSE_TYPE_ITEM, BSE_PARAM_DEFAULT);
#line 282 "bseitem.proc"
  proc->help = "Retrive the common ancestor of two items if there's any.";
#line 26 "bseitem.proc"
  proc->author = "Tim Janik <timj@gtk.org>";
#line 27 "bseitem.proc"
  proc->copyright = "Tim Janik";
#line 28 "bseitem.proc"
  proc->date = "2001";
#line 289 "bseitem.proc"
}  }
static BseErrorType
#line 289 "bseitem.proc"
common_ancestor_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 292 "bseitem.proc"
{
#line 293 "bseitem.proc"
  
  BseItem *item  = g_value_get_object (in_values++);
  BseItem *item2 = g_value_get_object (in_values++);
  
#line 297 "bseitem.proc"
  
  if (!BSE_IS_ITEM (item) || !BSE_IS_ITEM (item2))
    return BSE_ERROR_PROC_PARAM_INVAL;

#line 301 "bseitem.proc"
  
  g_value_set_object (out_values++, bse_item_common_ancestor (item, item2));
  
  return BSE_ERROR_NONE;
}

/* --- get-seqid --- */
static GType type_id_get_seqid = 0;
static void
get_seqid_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 307 "bseitem.proc"
 {
#line 311 "bseitem.proc"
  *(in_pspecs++) = g_param_spec_object ("item", "Item", NULL,
			       BSE_TYPE_ITEM, BSE_PARAM_DEFAULT);
  *(out_pspecs++) = g_param_spec_uint ("seqid", "Sequential ID", NULL,
			     0, G_MAXINT, 0, BSE_PARAM_DEFAULT);
#line 308 "bseitem.proc"
  proc->help = ("Retrive an item's sequential ID. The sequential ID depends "
	   "on the item's type an it's position inbetween siblings "
	   "of the same type within it's immediate container.");
#line 26 "bseitem.proc"
  proc->author = "Tim Janik <timj@gtk.org>";
#line 27 "bseitem.proc"
  proc->copyright = "Tim Janik";
#line 28 "bseitem.proc"
  proc->date = "2001";
#line 315 "bseitem.proc"
}  }
static BseErrorType
#line 315 "bseitem.proc"
get_seqid_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 318 "bseitem.proc"
{
#line 319 "bseitem.proc"
  
  BseItem *item = (BseItem*) g_value_get_object (in_values++);
  
#line 322 "bseitem.proc"
  
  if (!BSE_IS_ITEM (item))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 326 "bseitem.proc"
  
  g_value_set_uint (out_values++, bse_item_get_seqid (item));
  
  return BSE_ERROR_NONE;
}

/* --- check-is-a --- */
static GType type_id_check_is_a = 0;
static void
check_is_a_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 332 "bseitem.proc"
 {
#line 334 "bseitem.proc"
  *(in_pspecs++)    = g_param_spec_object ("item", "Item", "The Item",
			       BSE_TYPE_ITEM, BSE_PARAM_DEFAULT);
  *(in_pspecs++)    = g_param_spec_string ("type_name", "Type Name", NULL,
			       NULL, BSE_PARAM_DEFAULT);
  *(out_pspecs++)   = g_param_spec_boolean ("is_a", NULL, NULL,
				FALSE, BSE_PARAM_DEFAULT);
#line 26 "bseitem.proc"
  proc->author = "Tim Janik <timj@gtk.org>";
#line 27 "bseitem.proc"
  proc->copyright = "Tim Janik";
#line 28 "bseitem.proc"
  proc->date = "2001";
#line 340 "bseitem.proc"
}  }
static BseErrorType
#line 340 "bseitem.proc"
check_is_a_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 343 "bseitem.proc"
{
#line 344 "bseitem.proc"
  
  BseItem *item    = g_value_get_object (in_values++);
  gchar *type_name = g_value_get_string (in_values++);
  GType type;
  gboolean is_a;

#line 350 "bseitem.proc"
  
  if (!type_name)
    type_name = "";

#line 354 "bseitem.proc"
  
  type = g_type_from_name (type_name);
  is_a = item && g_type_is_a (G_OBJECT_TYPE (item), type);

#line 358 "bseitem.proc"
  
  g_value_set_boolean (out_values++, is_a);

  return BSE_ERROR_NONE;
}

/* --- list-proxies --- */
static GType type_id_list_proxies = 0;
static void
list_proxies_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 364 "bseitem.proc"
 {
#line 366 "bseitem.proc"
  *(in_pspecs++) = g_param_spec_object ("item", NULL, NULL,
			       BSE_TYPE_ITEM, BSE_PARAM_DEFAULT);
  *(in_pspecs++) = g_param_spec_string ("property", NULL, "Proxy property name",
			       NULL, BSE_PARAM_DEFAULT);
  *(out_pspecs++) = g_param_spec_boxed ("proxy_list", NULL, NULL,
			      BSW_TYPE_ITER_PROXY,
			      BSE_PARAM_DEFAULT);
#line 365 "bseitem.proc"
  proc->help = "List possible values for a proxy property of an item.";
#line 26 "bseitem.proc"
  proc->author = "Tim Janik <timj@gtk.org>";
#line 27 "bseitem.proc"
  proc->copyright = "Tim Janik";
#line 28 "bseitem.proc"
  proc->date = "2001";
#line 373 "bseitem.proc"
}  }
static BseErrorType
#line 373 "bseitem.proc"
list_proxies_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 376 "bseitem.proc"
{
#line 377 "bseitem.proc"
  
  BseItem *self     = g_value_get_object (in_values++);
  gchar   *property = g_value_get_string (in_values++);
  BswIterProxy *iter;

#line 382 "bseitem.proc"
  
  if (!BSE_IS_ITEM (self) || !property)
    return BSE_ERROR_PROC_PARAM_INVAL;

#line 386 "bseitem.proc"
  
  iter = bse_item_list_proxies (self, property);
  if (!iter)
    iter = bsw_iter_create (BSW_TYPE_ITER_PROXY, 0);
  g_value_set_boxed_take_ownership (out_values++, iter);

  return BSE_ERROR_NONE;
}

/* --- Export to BSE --- */
BSE_EXPORTS_BEGIN (BSE_PLUGIN_NAME);
BSE_EXPORT_PROCEDURES = {
  { &type_id_get_type, "BseItem+get-type", NULL, 0, get_type_setup, get_type_exec, NULL, "/Method/BseItem/General/Get Type", { 0, }, },
  { &type_id_get_type_name, "BseItem+get-type-name", NULL, 0, get_type_name_setup, get_type_name_exec, NULL, "/Method/BseItem/General/Get Type Name", { 0, }, },
  { &type_id_get_type_blurb, "BseItem+get-type-blurb", NULL, 0, get_type_blurb_setup, get_type_blurb_exec, NULL, "/Method/BseItem/General/Get Type Blurb", { 0, }, },
  { &type_id_get_parent, "BseItem+get-parent", NULL, 0, get_parent_setup, get_parent_exec, NULL, "/Method/BseItem/General/Get Parent", { 0, }, },
  { &type_id_get_project, "BseItem+get-project", NULL, 0, get_project_setup, get_project_exec, NULL, "/Method/BseItem/General/Get Project", { 0, }, },
  { &type_id_get_uname_path, "BseItem+get-uname-path", NULL, 0, get_uname_path_setup, get_uname_path_exec, NULL, "/Method/BseItem/General/Get Uname Path", { 0, }, },
  { &type_id_use, "BseItem+use", NULL, 0, use_setup, use_exec, NULL, "/Method/BseItem/General/Use", { 0, }, },
  { &type_id_unuse, "BseItem+unuse", NULL, 0, unuse_setup, unuse_exec, NULL, "/Method/BseItem/General/Unuse", { 0, }, },
  { &type_id_get_name, "BseItem+get-name", NULL, 0, get_name_setup, get_name_exec, NULL, "/Method/BseItem/General/Get Name", { 0, }, },
  { &type_id_get_name_or_type, "BseItem+get-name-or-type", NULL, 0, get_name_or_type_setup, get_name_or_type_exec, NULL, "/Method/BseItem/General/Get Name Or Type", { 0, }, },
  { &type_id_common_ancestor, "BseItem+common-ancestor", NULL, 0, common_ancestor_setup, common_ancestor_exec, NULL, "/Method/BseItem/General/Common Ancestor", { 0, }, },
  { &type_id_get_seqid, "BseItem+get-seqid", NULL, 0, get_seqid_setup, get_seqid_exec, NULL, "/Method/BseItem/General/Get Seqid", { 0, }, },
  { &type_id_check_is_a, "BseItem+check-is-a", "Check whether an item has a certain type.", 0, check_is_a_setup, check_is_a_exec, NULL, "/Method/BseItem/General/Check Is A", { 0, }, },
  { &type_id_list_proxies, "BseItem+list-proxies", NULL, 0, list_proxies_setup, list_proxies_exec, NULL, "/Method/BseItem/General/List Proxies", { 0, }, },
  { NULL, },
};
BSE_EXPORTS_END;

/**
 ** Generated data ends here
 **/
