
/**
 ** Generated data (by mkcproc.pl)
 **/
#line 1 "bsescriptcontrol.proc"

#include <bse/bseplugin.h>
#include <bse/bseprocedure.h>
#include <bse/bsescriptcontrol.h>
#include <bse/bsecomwire.h>
#include <bse/bseserver.h>
#include <string.h>


#line 29 "bsescriptcontrol.proc"


/* --- trigger-action --- */
static GType type_id_trigger_action = 0;
static void
trigger_action_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 31 "bsescriptcontrol.proc"
 {
#line 33 "bsescriptcontrol.proc"
  *(in_pspecs++) = g_param_spec_object ("script_control", "Script Control", NULL,
 			       BSE_TYPE_SCRIPT_CONTROL, BSE_PARAM_DEFAULT);
  *(in_pspecs++) = g_param_spec_string ("action", "Action", NULL,
 			       NULL, BSE_PARAM_DEFAULT);
}
#line 32 "bsescriptcontrol.proc"
  proc->help = "Trigger an installed user action of this script control.";
#line 26 "bsescriptcontrol.proc"
  proc->author = "Tim Janik <timj@gtk.org>";
#line 27 "bsescriptcontrol.proc"
  proc->copyright = "Tim Janik";
#line 28 "bsescriptcontrol.proc"
  proc->date = "2002";
#line 38 "bsescriptcontrol.proc"
 }
static BseErrorType
#line 38 "bsescriptcontrol.proc"
trigger_action_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 41 "bsescriptcontrol.proc"
{
#line 42 "bsescriptcontrol.proc"
  
  BseScriptControl *self   = g_value_get_object (in_values++);
  const gchar      *action = g_value_get_string (in_values++);
  
#line 46 "bsescriptcontrol.proc"
  
  if (!BSE_IS_SCRIPT_CONTROL (self) || !action)
    return BSE_ERROR_PROC_PARAM_INVAL;

#line 50 "bsescriptcontrol.proc"
  
  bse_script_control_trigger_action (self, action);
  
  return BSE_ERROR_NONE;
}

/* --- n-actions --- */
static GType type_id_n_actions = 0;
static void
n_actions_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 56 "bsescriptcontrol.proc"
 {
#line 58 "bsescriptcontrol.proc"
  *(in_pspecs++) = g_param_spec_object ("script_control", "Script Control", NULL,
 			       BSE_TYPE_SCRIPT_CONTROL, BSE_PARAM_DEFAULT);
  *(out_pspecs++)    = g_param_spec_uint ("n_actions", "N Actions", NULL,
			      0, G_MAXINT, 0, BSE_PARAM_DEFAULT);
}
#line 57 "bsescriptcontrol.proc"
  proc->help = "Retrive number of user actions of this script control.";
#line 26 "bsescriptcontrol.proc"
  proc->author = "Tim Janik <timj@gtk.org>";
#line 27 "bsescriptcontrol.proc"
  proc->copyright = "Tim Janik";
#line 28 "bsescriptcontrol.proc"
  proc->date = "2002";
#line 63 "bsescriptcontrol.proc"
 }
static BseErrorType
#line 63 "bsescriptcontrol.proc"
n_actions_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 66 "bsescriptcontrol.proc"
{
#line 67 "bsescriptcontrol.proc"
  
  BseScriptControl *self   = g_value_get_object (in_values++);
  
#line 70 "bsescriptcontrol.proc"
  
  if (!BSE_IS_SCRIPT_CONTROL (self))
    return BSE_ERROR_PROC_PARAM_INVAL;

#line 74 "bsescriptcontrol.proc"
  
  g_value_set_uint (out_values++, g_slist_length (self->actions));
  
  return BSE_ERROR_NONE;
}

/* --- get-action --- */
static GType type_id_get_action = 0;
static void
get_action_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 80 "bsescriptcontrol.proc"
 {
#line 82 "bsescriptcontrol.proc"
  *(in_pspecs++) = g_param_spec_object ("script_control", "Script Control", NULL,
 			       BSE_TYPE_SCRIPT_CONTROL, BSE_PARAM_DEFAULT);
  *(in_pspecs++) = g_param_spec_uint ("nth_action", "Nth Action", NULL,
			     0, G_MAXINT, 0, BSE_PARAM_DEFAULT);
  *(out_pspecs++) = g_param_spec_string ("action", "Action", NULL,
 			       NULL, BSE_PARAM_DEFAULT);
}
#line 81 "bsescriptcontrol.proc"
  proc->help = "Retrive an action of this script control.";
#line 26 "bsescriptcontrol.proc"
  proc->author = "Tim Janik <timj@gtk.org>";
#line 27 "bsescriptcontrol.proc"
  proc->copyright = "Tim Janik";
#line 28 "bsescriptcontrol.proc"
  proc->date = "2002";
#line 89 "bsescriptcontrol.proc"
 }
static BseErrorType
#line 89 "bsescriptcontrol.proc"
get_action_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 92 "bsescriptcontrol.proc"
{
#line 93 "bsescriptcontrol.proc"
  
  BseScriptControl *self = g_value_get_object (in_values++);
  guint             nth  = g_value_get_uint (in_values++);
  BseScriptControlAction *a;

#line 98 "bsescriptcontrol.proc"
  
  if (!BSE_IS_SCRIPT_CONTROL (self))
    return BSE_ERROR_PROC_PARAM_INVAL;

  a = g_slist_nth_data (self->actions, nth);

#line 104 "bsescriptcontrol.proc"
  
  g_value_set_string (out_values++, a ? g_quark_to_string (a->action) : NULL);
  
  return BSE_ERROR_NONE;
}

/* --- get-action-name --- */
static GType type_id_get_action_name = 0;
static void
get_action_name_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 110 "bsescriptcontrol.proc"
 {
#line 112 "bsescriptcontrol.proc"
  *(in_pspecs++) = g_param_spec_object ("script_control", "Script Control", NULL,
 			       BSE_TYPE_SCRIPT_CONTROL, BSE_PARAM_DEFAULT);
  *(in_pspecs++) = g_param_spec_uint ("nth_action", "Nth Action", NULL,
			     0, G_MAXINT, 0, BSE_PARAM_DEFAULT);
  *(out_pspecs++) = g_param_spec_string ("action-name", "Action Name", NULL,
 			       NULL, BSE_PARAM_DEFAULT);
}
#line 111 "bsescriptcontrol.proc"
  proc->help = "Retrive the name of an action of this script control.";
#line 26 "bsescriptcontrol.proc"
  proc->author = "Tim Janik <timj@gtk.org>";
#line 27 "bsescriptcontrol.proc"
  proc->copyright = "Tim Janik";
#line 28 "bsescriptcontrol.proc"
  proc->date = "2002";
#line 119 "bsescriptcontrol.proc"
 }
static BseErrorType
#line 119 "bsescriptcontrol.proc"
get_action_name_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 122 "bsescriptcontrol.proc"
{
#line 123 "bsescriptcontrol.proc"
  
  BseScriptControl *self = g_value_get_object (in_values++);
  guint             nth  = g_value_get_uint (in_values++);
  BseScriptControlAction *a;

#line 128 "bsescriptcontrol.proc"
  
  if (!BSE_IS_SCRIPT_CONTROL (self))
    return BSE_ERROR_PROC_PARAM_INVAL;

  a = g_slist_nth_data (self->actions, nth);

#line 134 "bsescriptcontrol.proc"
  
  g_value_set_string (out_values++, a ? a->name : NULL);
  
  return BSE_ERROR_NONE;
}

/* --- get-action-blurb --- */
static GType type_id_get_action_blurb = 0;
static void
get_action_blurb_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 140 "bsescriptcontrol.proc"
 {
#line 142 "bsescriptcontrol.proc"
  *(in_pspecs++) = g_param_spec_object ("script_control", "Script Control", NULL,
 			       BSE_TYPE_SCRIPT_CONTROL, BSE_PARAM_DEFAULT);
  *(in_pspecs++) = g_param_spec_uint ("nth_action", "Nth Action", NULL,
			     0, G_MAXINT, 0, BSE_PARAM_DEFAULT);
  *(out_pspecs++) = g_param_spec_string ("action-blurb", "Action Blurb", NULL,
 			       NULL, BSE_PARAM_DEFAULT);
}
#line 141 "bsescriptcontrol.proc"
  proc->help = "Retrive the help string of an action of this script control.";
#line 26 "bsescriptcontrol.proc"
  proc->author = "Tim Janik <timj@gtk.org>";
#line 27 "bsescriptcontrol.proc"
  proc->copyright = "Tim Janik";
#line 28 "bsescriptcontrol.proc"
  proc->date = "2002";
#line 149 "bsescriptcontrol.proc"
 }
static BseErrorType
#line 149 "bsescriptcontrol.proc"
get_action_blurb_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 152 "bsescriptcontrol.proc"
{
#line 153 "bsescriptcontrol.proc"
  
  BseScriptControl *self = g_value_get_object (in_values++);
  guint             nth  = g_value_get_uint (in_values++);
  BseScriptControlAction *a;

#line 158 "bsescriptcontrol.proc"
  
  if (!BSE_IS_SCRIPT_CONTROL (self))
    return BSE_ERROR_PROC_PARAM_INVAL;

  a = g_slist_nth_data (self->actions, nth);

#line 164 "bsescriptcontrol.proc"
  
  g_value_set_string (out_values++, a ? a->blurb : NULL);
  
  return BSE_ERROR_NONE;
}

/* --- kill --- */
static GType type_id_kill = 0;
static void
kill_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 170 "bsescriptcontrol.proc"
 {
#line 172 "bsescriptcontrol.proc"
  *(in_pspecs++) = g_param_spec_object ("script_control", "Script Control", NULL,
 			       BSE_TYPE_SCRIPT_CONTROL, BSE_PARAM_DEFAULT);
}
#line 171 "bsescriptcontrol.proc"
  proc->help = "Kill a currently running script";
#line 26 "bsescriptcontrol.proc"
  proc->author = "Tim Janik <timj@gtk.org>";
#line 27 "bsescriptcontrol.proc"
  proc->copyright = "Tim Janik";
#line 28 "bsescriptcontrol.proc"
  proc->date = "2002";
#line 175 "bsescriptcontrol.proc"
 }
static BseErrorType
#line 175 "bsescriptcontrol.proc"
kill_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 178 "bsescriptcontrol.proc"
{
#line 179 "bsescriptcontrol.proc"
  
  BseScriptControl *self = g_value_get_object (in_values++);

#line 182 "bsescriptcontrol.proc"
  
  if (!BSE_IS_SCRIPT_CONTROL (self))
    return BSE_ERROR_PROC_PARAM_INVAL;

#line 186 "bsescriptcontrol.proc"
  
  bse_script_control_preset_error (self, BSE_ERROR_NONE);
  if (self->wire)
    bse_script_control_queue_kill (self);
#line 190 "bsescriptcontrol.proc"
  
  bse_procedure_skip_next_exec_status ();
  
  return BSE_ERROR_NONE;
}

/* --- bse-script-add-action --- */
static GType type_id_bse_script_add_action = 0;
static void
bse_script_add_action_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 196 "bsescriptcontrol.proc"
 {
#line 198 "bsescriptcontrol.proc"
  *(in_pspecs++) = g_param_spec_string ("action", "Action", NULL,
 			       NULL, BSE_PARAM_DEFAULT);
  *(in_pspecs++) = g_param_spec_string ("name", "Name", NULL,
 			       NULL, BSE_PARAM_DEFAULT);
  *(in_pspecs++) = g_param_spec_string ("blurb", "Blurb", NULL,
 			       NULL, BSE_PARAM_DEFAULT);
}
#line 197 "bsescriptcontrol.proc"
  proc->help = "Install a user action for script control.";
#line 26 "bsescriptcontrol.proc"
  proc->author = "Tim Janik <timj@gtk.org>";
#line 27 "bsescriptcontrol.proc"
  proc->copyright = "Tim Janik";
#line 28 "bsescriptcontrol.proc"
  proc->date = "2002";
#line 205 "bsescriptcontrol.proc"
 }
static BseErrorType
#line 205 "bsescriptcontrol.proc"
bse_script_add_action_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 208 "bsescriptcontrol.proc"
{
#line 209 "bsescriptcontrol.proc"
  
  const gchar      *action = g_value_get_string (in_values++);
  const gchar      *name   = g_value_get_string (in_values++);
  const gchar      *blurb  = g_value_get_string (in_values++);
  BseScriptControl *self = bse_script_control_peek_current ();
  
#line 215 "bsescriptcontrol.proc"
  
  if (!action || !name)
    return BSE_ERROR_PROC_PARAM_INVAL;

#line 219 "bsescriptcontrol.proc"
  
  if (!BSE_IS_SCRIPT_CONTROL (self) || !self->wire)
    return BSE_ERROR_PROC_EXECUTION;

#line 223 "bsescriptcontrol.proc"
  
  bse_script_control_add_action (self, action, name, blurb);
  
  return BSE_ERROR_NONE;
}

/* --- bse-script-remove-action --- */
static GType type_id_bse_script_remove_action = 0;
static void
bse_script_remove_action_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 229 "bsescriptcontrol.proc"
 {
#line 231 "bsescriptcontrol.proc"
  *(in_pspecs++) = g_param_spec_object ("script_control", "Script Control", NULL,
 			       BSE_TYPE_SCRIPT_CONTROL, BSE_PARAM_DEFAULT);
  *(in_pspecs++) = g_param_spec_string ("action", "Action", NULL,
 			       NULL, BSE_PARAM_DEFAULT);
}
#line 230 "bsescriptcontrol.proc"
  proc->help = "Remove a previously installed user action from script control.";
#line 26 "bsescriptcontrol.proc"
  proc->author = "Tim Janik <timj@gtk.org>";
#line 27 "bsescriptcontrol.proc"
  proc->copyright = "Tim Janik";
#line 28 "bsescriptcontrol.proc"
  proc->date = "2002";
#line 236 "bsescriptcontrol.proc"
 }
static BseErrorType
#line 236 "bsescriptcontrol.proc"
bse_script_remove_action_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 239 "bsescriptcontrol.proc"
{
#line 240 "bsescriptcontrol.proc"
  
  const gchar      *action = g_value_get_string (in_values++);
  BseScriptControl *self = bse_script_control_peek_current ();
  
#line 244 "bsescriptcontrol.proc"
  
  if (!action)
    return BSE_ERROR_PROC_PARAM_INVAL;

#line 248 "bsescriptcontrol.proc"
  
  if (!BSE_IS_SCRIPT_CONTROL (self) || !self->wire)
    return BSE_ERROR_PROC_EXECUTION;

#line 252 "bsescriptcontrol.proc"
  
  bse_script_control_remove_action (self, action);
  
  return BSE_ERROR_NONE;
}

/* --- bse-script-control --- */
static GType type_id_bse_script_control = 0;
static void
bse_script_control_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 258 "bsescriptcontrol.proc"
 {
#line 260 "bsescriptcontrol.proc"
  *(out_pspecs++)   = g_param_spec_object ("script_control", "Script Control", NULL,
			       BSE_TYPE_SCRIPT_CONTROL, BSE_PARAM_DEFAULT);
}
#line 259 "bsescriptcontrol.proc"
  proc->help = "Retrive the current script control object.";
#line 26 "bsescriptcontrol.proc"
  proc->author = "Tim Janik <timj@gtk.org>";
#line 27 "bsescriptcontrol.proc"
  proc->copyright = "Tim Janik";
#line 28 "bsescriptcontrol.proc"
  proc->date = "2002";
#line 263 "bsescriptcontrol.proc"
 }
static BseErrorType
#line 263 "bsescriptcontrol.proc"
bse_script_control_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 266 "bsescriptcontrol.proc"
{
  BseScriptControl *self = bse_script_control_peek_current ();
  
#line 269 "bsescriptcontrol.proc"
  
  g_value_set_object (out_values++, self);
  
  return BSE_ERROR_NONE;
}

/* --- bse-script-set-msg --- */
static GType type_id_bse_script_set_msg = 0;
static void
bse_script_set_msg_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 275 "bsescriptcontrol.proc"
 {
#line 277 "bsescriptcontrol.proc"
  *(in_pspecs++)    = g_param_spec_enum ("msg_type", "Message Type", NULL,
			     BSE_TYPE_USER_MSG_TYPE, BSE_ERROR_NONE,
			     BSE_PARAM_DEFAULT);
  *(in_pspecs++)    = g_param_spec_string ("message", "Message", NULL,
			       NULL, BSE_PARAM_DEFAULT);
#line 276 "bsescriptcontrol.proc"
  proc->help = "Alter script status message.";
#line 26 "bsescriptcontrol.proc"
  proc->author = "Tim Janik <timj@gtk.org>";
#line 27 "bsescriptcontrol.proc"
  proc->copyright = "Tim Janik";
#line 28 "bsescriptcontrol.proc"
  proc->date = "2002";
#line 282 "bsescriptcontrol.proc"
}  }
static BseErrorType
#line 282 "bsescriptcontrol.proc"
bse_script_set_msg_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 285 "bsescriptcontrol.proc"
{
#line 286 "bsescriptcontrol.proc"
  
  BseUserMsgType mtype   = g_value_get_enum (in_values++);
  const gchar   *message = g_value_get_string (in_values++);
  BseScriptControl *self = bse_script_control_peek_current ();

#line 291 "bsescriptcontrol.proc"
  
  if (!BSE_IS_SCRIPT_CONTROL (self) || !self->wire)
    return BSE_ERROR_PROC_EXECUTION;
  if (!message)
    {
      message = bse_script_control_get_ident (self);
      mtype = BSE_USER_MSG_INFO;
    }

#line 300 "bsescriptcontrol.proc"
  
  g_object_set (self,
		"user_msg_type", mtype,
		"user_msg", message,
		NULL);

  return BSE_ERROR_NONE;
}

/* --- bse-script-progress --- */
static GType type_id_bse_script_progress = 0;
static void
bse_script_progress_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 309 "bsescriptcontrol.proc"
 {
#line 311 "bsescriptcontrol.proc"
  *(in_pspecs++)    = bse_param_spec_float ("progress", "Progress", NULL,
				-1, 1.0, -1, 0.1,
				BSE_PARAM_DEFAULT);
#line 310 "bsescriptcontrol.proc"
  proc->help = "Indicate progress (from 0.0 to 1.0 or -1 for unknown amount).";
#line 26 "bsescriptcontrol.proc"
  proc->author = "Tim Janik <timj@gtk.org>";
#line 27 "bsescriptcontrol.proc"
  proc->copyright = "Tim Janik";
#line 28 "bsescriptcontrol.proc"
  proc->date = "2002";
#line 314 "bsescriptcontrol.proc"
}  }
static BseErrorType
#line 314 "bsescriptcontrol.proc"
bse_script_progress_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 317 "bsescriptcontrol.proc"
{
#line 318 "bsescriptcontrol.proc"
  
  gfloat progress = g_value_get_float (in_values++);
  BseScriptControl *self = bse_script_control_peek_current ();

#line 322 "bsescriptcontrol.proc"
  
  if (!BSE_IS_SCRIPT_CONTROL (self) || !self->wire)
    return BSE_ERROR_PROC_EXECUTION;

#line 326 "bsescriptcontrol.proc"
  
  bse_server_exec_status (bse_server_get (), BSE_EXEC_STATUS_PROGRESS,
			  bse_script_control_get_ident (self),
			  progress > 0 ? progress : -1,
			  BSE_ERROR_NONE);
#line 331 "bsescriptcontrol.proc"
  
  bse_procedure_skip_next_exec_status ();
#line 333 "bsescriptcontrol.proc"
  
  bse_script_control_block_exec_status (self, TRUE);

  return BSE_ERROR_NONE;
}

/* --- bse-script-exit --- */
static GType type_id_bse_script_exit = 0;
static void
bse_script_exit_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 341 "bsescriptcontrol.proc"
 {
#line 343 "bsescriptcontrol.proc"
  *(in_pspecs++)    = g_param_spec_enum ("msg_type", "Message Type", NULL,
			     BSE_TYPE_USER_MSG_TYPE, BSE_ERROR_NONE,
			     BSE_PARAM_DEFAULT);
  *(in_pspecs++)    = g_param_spec_string ("message", "Message", NULL,
			       NULL, BSE_PARAM_DEFAULT);
#line 342 "bsescriptcontrol.proc"
  proc->help = "Exit a script, leaving a message.";
#line 26 "bsescriptcontrol.proc"
  proc->author = "Tim Janik <timj@gtk.org>";
#line 27 "bsescriptcontrol.proc"
  proc->copyright = "Tim Janik";
#line 28 "bsescriptcontrol.proc"
  proc->date = "2002";
#line 348 "bsescriptcontrol.proc"
}  }
static BseErrorType
#line 348 "bsescriptcontrol.proc"
bse_script_exit_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 351 "bsescriptcontrol.proc"
{
#line 352 "bsescriptcontrol.proc"
  
  BseUserMsgType mtype   = g_value_get_enum (in_values++);
  const gchar   *message = g_value_get_string (in_values++);
  BseScriptControl *self = bse_script_control_peek_current ();
  BseErrorType error;

#line 358 "bsescriptcontrol.proc"
  
  if (!message)
    return BSE_ERROR_PROC_PARAM_INVAL;

#line 362 "bsescriptcontrol.proc"
  
  if (!BSE_IS_SCRIPT_CONTROL (self) || !self->wire)
    return BSE_ERROR_PROC_EXECUTION;

#line 366 "bsescriptcontrol.proc"
  
  bse_server_user_message (bse_server_get (), mtype, message);
  switch (mtype)
    {
    case BSE_USER_MSG_INFO:
      error = BSE_ERROR_USER_INFO;
      break;
    case BSE_USER_MSG_QUESTION:
      error = BSE_ERROR_USER_QUESTION;
      break;
    case BSE_USER_MSG_WARNING:
      error = BSE_ERROR_USER_WARNING;
      break;
    case BSE_USER_MSG_ERROR:
      error = BSE_ERROR_USER_ERROR;
      break;
    default:
      error = BSE_ERROR_NONE;
      break;
    }
  bse_script_control_preset_error (self, error);
  bse_script_control_queue_kill (self);
#line 388 "bsescriptcontrol.proc"
  
  bse_procedure_skip_next_exec_status ();

  return BSE_ERROR_NONE;
}

/* --- Export to BSE --- */
BSE_EXPORTS_BEGIN (BSE_PLUGIN_NAME);
BSE_EXPORT_PROCEDURES = {
  { &type_id_trigger_action, "BseScriptControl+trigger-action", NULL, 0, trigger_action_setup, trigger_action_exec, NULL, "/Method/BseScriptControl/General/Trigger Action", { 0, }, },
  { &type_id_n_actions, "BseScriptControl+n-actions", NULL, 0, n_actions_setup, n_actions_exec, NULL, "/Method/BseScriptControl/General/N Actions", { 0, }, },
  { &type_id_get_action, "BseScriptControl+get-action", NULL, 0, get_action_setup, get_action_exec, NULL, "/Method/BseScriptControl/General/Get Action", { 0, }, },
  { &type_id_get_action_name, "BseScriptControl+get-action-name", NULL, 0, get_action_name_setup, get_action_name_exec, NULL, "/Method/BseScriptControl/General/Get Action Name", { 0, }, },
  { &type_id_get_action_blurb, "BseScriptControl+get-action-blurb", NULL, 0, get_action_blurb_setup, get_action_blurb_exec, NULL, "/Method/BseScriptControl/General/Get Action Blurb", { 0, }, },
  { &type_id_kill, "BseScriptControl+kill", NULL, 0, kill_setup, kill_exec, NULL, "/Method/BseScriptControl/General/Kill", { 0, }, },
  { &type_id_bse_script_add_action, "bse-script-add-action", NULL, 0, bse_script_add_action_setup, bse_script_add_action_exec, NULL, "/Proc/Script Utils/Add Action", { 0, }, },
  { &type_id_bse_script_remove_action, "bse-script-remove-action", NULL, 0, bse_script_remove_action_setup, bse_script_remove_action_exec, NULL, "/Proc/Script Utils/Remove Action", { 0, }, },
  { &type_id_bse_script_control, "bse-script-control", NULL, 0, bse_script_control_setup, bse_script_control_exec, NULL, "/Proc/Script Utils/Current Control", { 0, }, },
  { &type_id_bse_script_set_msg, "bse-script-set-msg", NULL, 0, bse_script_set_msg_setup, bse_script_set_msg_exec, NULL, "/Proc/Script Utils/Set Message", { 0, }, },
  { &type_id_bse_script_progress, "bse-script-progress", NULL, 0, bse_script_progress_setup, bse_script_progress_exec, NULL, "/Proc/Script Utils/Progress", { 0, }, },
  { &type_id_bse_script_exit, "bse-script-exit", NULL, 0, bse_script_exit_setup, bse_script_exit_exec, NULL, "/Proc/Script Utils/Exit Message", { 0, }, },
  { NULL, },
};
BSE_EXPORTS_END;

/**
 ** Generated data ends here
 **/
