# Slovenian (sl) locale

## `format` and `parse`

| Title                           | Token string | Date                     | `format` result                            | `parse` result           |
| ------------------------------- | ------------ | ------------------------ | ------------------------------------------ | ------------------------ |
| Calendar year                   | yo           | 1987-02-11T12:13:14.015Z | 1987.                                      | 1987-01-01T00:00:00.000Z |
|                                 |              | 0005-01-01T12:13:14.015Z | 5.                                         | 0005-01-01T00:00:00.000Z |
| Local week-numbering year       | Yo           | 1987-02-11T12:13:14.015Z | 1987.                                      | 1986-12-29T00:00:00.000Z |
|                                 |              | 0005-01-01T12:13:14.015Z | 5.                                         | 0004-12-27T00:00:00.000Z |
| Quarter (formatting)            | Qo           | 2019-01-01T12:13:14.015Z | 1.                                         | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2.                                         | 2019-04-01T00:00:00.000Z |
|                                 | QQQ          | 2019-01-01T12:13:14.015Z | 1. čet.                                    | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2. čet.                                    | 2019-04-01T00:00:00.000Z |
|                                 | QQQQ         | 2019-01-01T12:13:14.015Z | 1. četrtletje                              | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2. četrtletje                              | 2019-04-01T00:00:00.000Z |
|                                 | QQQQQ        | 2019-01-01T12:13:14.015Z | 1                                          | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2                                          | 2019-04-01T00:00:00.000Z |
| Quarter (stand-alone)           | qo           | 2019-01-01T12:13:14.015Z | 1.                                         | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2.                                         | 2019-04-01T00:00:00.000Z |
|                                 | qqq          | 2019-01-01T12:13:14.015Z | 1. čet.                                    | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2. čet.                                    | 2019-04-01T00:00:00.000Z |
|                                 | qqqq         | 2019-01-01T12:13:14.015Z | 1. četrtletje                              | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2. četrtletje                              | 2019-04-01T00:00:00.000Z |
| Month (formatting)              | Mo           | 2019-02-11T12:13:14.015Z | 2.                                         | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | 7.                                         | 2019-07-01T00:00:00.000Z |
|                                 | MMM          | 2019-02-11T12:13:14.015Z | feb.                                       | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | jul.                                       | 2019-07-01T00:00:00.000Z |
|                                 | MMMM         | 2019-02-11T12:13:14.015Z | februar                                    | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | julij                                      | 2019-07-01T00:00:00.000Z |
|                                 | MMMMM        | 2019-02-11T12:13:14.015Z | f                                          | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | j                                          | 2019-01-01T00:00:00.000Z |
| Month (stand-alone)             | Lo           | 2019-02-11T12:13:14.015Z | 2.                                         | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | 7.                                         | 2019-07-01T00:00:00.000Z |
|                                 | LLL          | 2019-02-11T12:13:14.015Z | feb.                                       | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | jul.                                       | 2019-07-01T00:00:00.000Z |
|                                 | LLLL         | 2019-02-11T12:13:14.015Z | februar                                    | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | julij                                      | 2019-07-01T00:00:00.000Z |
|                                 | LLLLL        | 2019-02-11T12:13:14.015Z | f                                          | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | j                                          | 2019-01-01T00:00:00.000Z |
| Local week of year              | wo           | 2019-01-01T12:13:14.015Z | 1.                                         | 2018-12-31T00:00:00.000Z |
|                                 |              | 2019-12-01T12:13:14.015Z | 48.                                        | 2019-11-25T00:00:00.000Z |
| ISO week of year                | Io           | 2019-01-01T12:13:14.015Z | 1.                                         | 2018-12-31T00:00:00.000Z |
|                                 |              | 2019-12-01T12:13:14.015Z | 48.                                        | 2019-11-25T00:00:00.000Z |
| Day of month                    | do           | 2019-02-11T12:13:14.015Z | 11.                                        | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-28T12:13:14.015Z | 28.                                        | 2019-02-28T00:00:00.000Z |
| Day of year                     | Do           | 2019-02-11T12:13:14.015Z | 42.                                        | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-12-31T12:13:14.015Z | 365.                                       | 2019-12-31T00:00:00.000Z |
| Day of week (formatting)        | E            | 2019-02-11T12:13:14.015Z | pon.                                       | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | pet.                                       | 2019-02-15T00:00:00.000Z |
|                                 | EE           | 2019-02-11T12:13:14.015Z | pon.                                       | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | pet.                                       | 2019-02-15T00:00:00.000Z |
|                                 | EEE          | 2019-02-11T12:13:14.015Z | pon.                                       | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | pet.                                       | 2019-02-15T00:00:00.000Z |
|                                 | EEEE         | 2019-02-11T12:13:14.015Z | ponedeljek                                 | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | petek                                      | 2019-02-15T00:00:00.000Z |
|                                 | EEEEE        | 2019-02-11T12:13:14.015Z | p                                          | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | p                                          | 2019-02-11T00:00:00.000Z |
|                                 | EEEEEE       | 2019-02-11T12:13:14.015Z | pon.                                       | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | pet.                                       | 2019-02-15T00:00:00.000Z |
| ISO day of week (formatting)    | io           | 2019-02-11T12:13:14.015Z | 1.                                         | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 5.                                         | 2019-02-15T00:00:00.000Z |
|                                 | iii          | 2019-02-11T12:13:14.015Z | pon.                                       | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | pet.                                       | 2019-02-15T00:00:00.000Z |
|                                 | iiii         | 2019-02-11T12:13:14.015Z | ponedeljek                                 | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | petek                                      | 2019-02-15T00:00:00.000Z |
|                                 | iiiii        | 2019-02-11T12:13:14.015Z | p                                          | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | p                                          | 2019-02-11T00:00:00.000Z |
|                                 | iiiiii       | 2019-02-11T12:13:14.015Z | pon.                                       | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | pet.                                       | 2019-02-15T00:00:00.000Z |
| Local day of week (formatting)  | eo           | 2019-02-11T12:13:14.015Z | 1.                                         | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 5.                                         | 2019-02-15T00:00:00.000Z |
|                                 | eee          | 2019-02-11T12:13:14.015Z | pon.                                       | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | pet.                                       | 2019-02-15T00:00:00.000Z |
|                                 | eeee         | 2019-02-11T12:13:14.015Z | ponedeljek                                 | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | petek                                      | 2019-02-15T00:00:00.000Z |
|                                 | eeeee        | 2019-02-11T12:13:14.015Z | p                                          | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | p                                          | 2019-02-11T00:00:00.000Z |
|                                 | eeeeee       | 2019-02-11T12:13:14.015Z | pon.                                       | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | pet.                                       | 2019-02-15T00:00:00.000Z |
| Local day of week (stand-alone) | co           | 2019-02-11T12:13:14.015Z | 1.                                         | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 5.                                         | 2019-02-15T00:00:00.000Z |
|                                 | ccc          | 2019-02-11T12:13:14.015Z | pon.                                       | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | pet.                                       | 2019-02-15T00:00:00.000Z |
|                                 | cccc         | 2019-02-11T12:13:14.015Z | ponedeljek                                 | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | petek                                      | 2019-02-15T00:00:00.000Z |
|                                 | ccccc        | 2019-02-11T12:13:14.015Z | p                                          | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | p                                          | 2019-02-11T00:00:00.000Z |
|                                 | cccccc       | 2019-02-11T12:13:14.015Z | pon.                                       | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | pet.                                       | 2019-02-15T00:00:00.000Z |
| AM, PM                          | a            | 2019-02-11T11:13:14.015Z | dop.                                       | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | pop.                                       | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | pop.                                       | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | dop.                                       | 2019-02-11T00:00:00.000Z |
|                                 | aa           | 2019-02-11T11:13:14.015Z | dop.                                       | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | pop.                                       | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | pop.                                       | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | dop.                                       | 2019-02-11T00:00:00.000Z |
|                                 | aaa          | 2019-02-11T11:13:14.015Z | dop.                                       | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | pop.                                       | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | pop.                                       | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | dop.                                       | 2019-02-11T00:00:00.000Z |
|                                 | aaaa         | 2019-02-11T11:13:14.015Z | dop.                                       | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | pop.                                       | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | pop.                                       | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | dop.                                       | 2019-02-11T00:00:00.000Z |
|                                 | aaaaa        | 2019-02-11T11:13:14.015Z | d                                          | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | p                                          | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | p                                          | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | d                                          | 2019-02-11T00:00:00.000Z |
| AM, PM, noon, midnight          | b            | 2019-02-11T11:13:14.015Z | dop.                                       | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | pop.                                       | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | pop.                                       | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | dop.                                       | 2019-02-11T00:00:00.000Z |
|                                 | bb           | 2019-02-11T11:13:14.015Z | dop.                                       | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | pop.                                       | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | pop.                                       | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | dop.                                       | 2019-02-11T00:00:00.000Z |
|                                 | bbb          | 2019-02-11T11:13:14.015Z | dop.                                       | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | pop.                                       | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | pop.                                       | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | dop.                                       | 2019-02-11T00:00:00.000Z |
|                                 | bbbb         | 2019-02-11T11:13:14.015Z | dop.                                       | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | pop.                                       | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | pop.                                       | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | dop.                                       | 2019-02-11T00:00:00.000Z |
|                                 | bbbbb        | 2019-02-11T11:13:14.015Z | d                                          | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | p                                          | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | p                                          | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | d                                          | 2019-02-11T00:00:00.000Z |
| Flexible day period             | B            | 2019-02-11T11:13:14.015Z | zjut.                                      | 2019-02-11T04:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | pop.                                       | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | zveč.                                      | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | ponoči                                     | 2019-02-11T00:00:00.000Z |
|                                 | BB           | 2019-02-11T11:13:14.015Z | zjut.                                      | 2019-02-11T04:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | pop.                                       | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | zveč.                                      | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | ponoči                                     | 2019-02-11T00:00:00.000Z |
|                                 | BBB          | 2019-02-11T11:13:14.015Z | zjut.                                      | 2019-02-11T04:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | pop.                                       | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | zveč.                                      | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | ponoči                                     | 2019-02-11T00:00:00.000Z |
|                                 | BBBB         | 2019-02-11T11:13:14.015Z | zjutraj                                    | 2019-02-11T04:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | popoldan                                   | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | zvečer                                     | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | ponoči                                     | 2019-02-11T00:00:00.000Z |
|                                 | BBBBB        | 2019-02-11T11:13:14.015Z | zj                                         | 2019-02-11T04:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | p                                          | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | zv                                         | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | po                                         | 2019-02-11T12:00:00.000Z |
| Hour [1-12]                     | ho           | 2019-02-11T11:13:14.015Z | 11.                                        | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 11.                                        | 2019-02-11T23:00:00.000Z |
| Hour [0-23]                     | Ho           | 2019-02-11T11:13:14.015Z | 11.                                        | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 23.                                        | 2019-02-11T23:00:00.000Z |
| Hour [0-11]                     | Ko           | 2019-02-11T11:13:14.015Z | 11.                                        | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 11.                                        | 2019-02-11T23:00:00.000Z |
| Hour [1-24]                     | ko           | 2019-02-11T11:13:14.015Z | 11.                                        | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 23.                                        | 2019-02-11T23:00:00.000Z |
| Minute                          | mo           | 2019-01-01T12:01:14.015Z | 1.                                         | 2019-01-01T12:01:00.000Z |
|                                 |              | 2019-04-01T12:55:14.015Z | 55.                                        | 2019-04-01T12:55:00.000Z |
| Second                          | so           | 2019-01-01T12:13:01.015Z | 1.                                         | 2019-01-01T12:13:01.000Z |
|                                 |              | 2019-04-01T12:13:55.015Z | 55.                                        | 2019-04-01T12:13:55.000Z |
| Long localized date             | P            | 1987-02-11T12:13:14.015Z | 11. 02. 87                                 | 1987-02-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29. 05. 53                                 | 1453-05-29T00:00:00.000Z |
|                                 | PP           | 1987-02-11T12:13:14.015Z | 11. feb. 1987                              | 1987-02-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29. maj 1453                               | 1453-05-29T00:00:00.000Z |
|                                 | PPP          | 1987-02-11T12:13:14.015Z | 11. februar 1987                           | 1987-02-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29. maj 1453                               | 1453-05-29T00:00:00.000Z |
|                                 | PPPP         | 1987-02-11T12:13:14.015Z | sreda, 11. februar 1987                    | 1987-02-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | nedelja, 29. maj 1453                      | 1453-05-29T00:00:00.000Z |
| Long localized time             | p            | 1987-02-11T12:13:14.015Z | 12:13                                      | 1987-02-11T12:13:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 23:59                                      | 1453-05-29T23:59:00.000Z |
|                                 | pp           | 1987-02-11T12:13:14.015Z | 12:13:14                                   | 1987-02-11T12:13:14.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 23:59:59                                   | 1453-05-29T23:59:59.000Z |
|                                 | ppp          | 1987-02-11T12:13:14.015Z | 12:13:14 GMT+0                             | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | 23:59:59 GMT+0                             | Errored                  |
|                                 | pppp         | 1987-02-11T12:13:14.015Z | 12:13:14 GMT+00:00                         | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | 23:59:59 GMT+00:00                         | Errored                  |
| Combination of date and time    | Pp           | 1987-02-11T12:13:14.015Z | 11. 02. 87 12:13                           | 1987-02-11T12:13:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29. 05. 53 23:59                           | 1453-05-29T23:59:00.000Z |
|                                 | PPpp         | 1987-02-11T12:13:14.015Z | 11. feb. 1987 12:13:14                     | 1987-02-11T12:13:14.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29. maj 1453 23:59:59                      | 1453-05-29T23:59:59.000Z |
|                                 | PPPppp       | 1987-02-11T12:13:14.015Z | 11. februar 1987 12:13:14 GMT+0            | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | 29. maj 1453 23:59:59 GMT+0                | Errored                  |
|                                 | PPPPpppp     | 1987-02-11T12:13:14.015Z | sreda, 11. februar 1987 12:13:14 GMT+00:00 | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | nedelja, 29. maj 1453 23:59:59 GMT+00:00   | Errored                  |

## `formatDistance`

If now is January 1st, 2000, 00:00.

| Date                     | Result            | `includeSeconds: true` | `addSuffix: true`        |
| ------------------------ | ----------------- | ---------------------- | ------------------------ |
| 2006-01-01T00:00:00.000Z | približno 6 let   | približno 6 let        | čez približno 6 let      |
| 2005-01-01T00:00:00.000Z | približno 5 let   | približno 5 let        | čez približno 5 let      |
| 2004-01-01T00:00:00.000Z | približno 4 leta  | približno 4 leta       | čez približno 4 leta     |
| 2003-01-01T00:00:00.000Z | približno 3 leta  | približno 3 leta       | čez približno 3 leta     |
| 2002-01-01T00:00:00.000Z | približno 2 leti  | približno 2 leti       | čez približno 2 leti     |
| 2001-06-01T00:00:00.000Z | več kot 1 leto    | več kot 1 leto         | čez več kot 1 leto       |
| 2001-02-01T00:00:00.000Z | približno 1 leto  | približno 1 leto       | čez približno 1 leto     |
| 2001-01-01T00:00:00.000Z | približno 1 leto  | približno 1 leto       | čez približno 1 leto     |
| 2000-06-01T00:00:00.000Z | 5 mesecev         | 5 mesecev              | čez 5 mesecev            |
| 2000-03-01T00:00:00.000Z | 2 meseca          | 2 meseca               | čez 2 meseca             |
| 2000-02-01T00:00:00.000Z | približno 1 mesec | približno 1 mesec      | čez približno 1 mesec    |
| 2000-01-15T00:00:00.000Z | 14 dni            | 14 dni                 | čez 14 dni               |
| 2000-01-02T00:00:00.000Z | 1 dan             | 1 dan                  | čez 1 dan                |
| 2000-01-01T06:00:00.000Z | približno 6 ur    | približno 6 ur         | čez približno 6 ur       |
| 2000-01-01T01:00:00.000Z | približno 1 ura   | približno 1 ura        | čez približno 1 uro      |
| 2000-01-01T00:45:00.000Z | približno 1 ura   | približno 1 ura        | čez približno 1 uro      |
| 2000-01-01T00:30:00.000Z | 30 minut          | 30 minut               | čez 30 minut             |
| 2000-01-01T00:15:00.000Z | 15 minut          | 15 minut               | čez 15 minut             |
| 2000-01-01T00:01:00.000Z | 1 minuta          | 1 minuta               | čez 1 minuto             |
| 2000-01-01T00:00:25.000Z | manj kot 1 minuta | pol minute             | čez manj kot 1 minuto    |
| 2000-01-01T00:00:15.000Z | manj kot 1 minuta | manj kot 20 sekund     | čez manj kot 1 minuto    |
| 2000-01-01T00:00:05.000Z | manj kot 1 minuta | manj kot 10 sekund     | čez manj kot 1 minuto    |
| 2000-01-01T00:00:00.000Z | manj kot 1 minuta | manj kot 5 sekund      | pred manj kot 1 minuto   |
| 1999-12-31T23:59:55.000Z | manj kot 1 minuta | manj kot 10 sekund     | pred manj kot 1 minuto   |
| 1999-12-31T23:59:45.000Z | manj kot 1 minuta | manj kot 20 sekund     | pred manj kot 1 minuto   |
| 1999-12-31T23:59:35.000Z | manj kot 1 minuta | pol minute             | pred manj kot 1 minuto   |
| 1999-12-31T23:59:00.000Z | 1 minuta          | 1 minuta               | pred 1 minuto            |
| 1999-12-31T23:45:00.000Z | 15 minut          | 15 minut               | pred 15 minutami         |
| 1999-12-31T23:30:00.000Z | 30 minut          | 30 minut               | pred 30 minutami         |
| 1999-12-31T23:15:00.000Z | približno 1 ura   | približno 1 ura        | pred približno 1 uro     |
| 1999-12-31T23:00:00.000Z | približno 1 ura   | približno 1 ura        | pred približno 1 uro     |
| 1999-12-31T18:00:00.000Z | približno 6 ur    | približno 6 ur         | pred približno 6 urami   |
| 1999-12-30T00:00:00.000Z | 2 dni             | 2 dni                  | pred 2 dnevoma           |
| 1999-12-15T00:00:00.000Z | 17 dni            | 17 dni                 | pred 17 dnevi            |
| 1999-12-01T00:00:00.000Z | približno 1 mesec | približno 1 mesec      | pred približno 1 mesecem |
| 1999-11-01T00:00:00.000Z | 2 meseca          | 2 meseca               | pred 2 mesecema          |
| 1999-06-01T00:00:00.000Z | 7 mesecev         | 7 mesecev              | pred 7 meseci            |
| 1999-01-01T00:00:00.000Z | približno 1 leto  | približno 1 leto       | pred približno 1 letom   |
| 1998-12-01T00:00:00.000Z | približno 1 leto  | približno 1 leto       | pred približno 1 letom   |
| 1998-06-01T00:00:00.000Z | več kot 1 leto    | več kot 1 leto         | pred več kot 1 letom     |
| 1998-01-01T00:00:00.000Z | približno 2 leti  | približno 2 leti       | pred približno 2 letoma  |
| 1997-01-01T00:00:00.000Z | približno 3 leta  | približno 3 leta       | pred približno 3 leti    |
| 1996-01-01T00:00:00.000Z | približno 4 leta  | približno 4 leta       | pred približno 4 leti    |
| 1995-01-01T00:00:00.000Z | približno 5 let   | približno 5 let        | pred približno 5 leti    |
| 1994-01-01T00:00:00.000Z | približno 6 let   | približno 6 let        | pred približno 6 leti    |

## `formatDistanceStrict`

If now is January 1st, 2000, 00:00.

| Date                     | Result    | `addSuffix: true` | With forced unit (i.e. `hour`) |
| ------------------------ | --------- | ----------------- | ------------------------------ |
| 2006-01-01T00:00:00.000Z | 6 let     | čez 6 let         | 52608 ur                       |
| 2005-01-01T00:00:00.000Z | 5 let     | čez 5 let         | 43848 ur                       |
| 2004-01-01T00:00:00.000Z | 4 leta    | čez 4 leta        | 35064 ur                       |
| 2003-01-01T00:00:00.000Z | 3 leta    | čez 3 leta        | 26304 ure                      |
| 2002-01-01T00:00:00.000Z | 2 leti    | čez 2 leti        | 17544 ur                       |
| 2001-06-01T00:00:00.000Z | 1 leto    | čez 1 leto        | 12408 ur                       |
| 2001-02-01T00:00:00.000Z | 1 leto    | čez 1 leto        | 9528 ur                        |
| 2001-01-01T00:00:00.000Z | 1 leto    | čez 1 leto        | 8784 ur                        |
| 2000-06-01T00:00:00.000Z | 5 mesecev | čez 5 mesecev     | 3648 ur                        |
| 2000-03-01T00:00:00.000Z | 2 meseca  | čez 2 meseca      | 1440 ur                        |
| 2000-02-01T00:00:00.000Z | 1 mesec   | čez 1 mesec       | 744 ur                         |
| 2000-01-15T00:00:00.000Z | 14 dni    | čez 14 dni        | 336 ur                         |
| 2000-01-02T00:00:00.000Z | 1 dan     | čez 1 dan         | 24 ur                          |
| 2000-01-01T06:00:00.000Z | 6 ur      | čez 6 ur          | 6 ur                           |
| 2000-01-01T01:00:00.000Z | 1 ura     | čez 1 uro         | 1 ura                          |
| 2000-01-01T00:45:00.000Z | 45 minut  | čez 45 minut      | 1 ura                          |
| 2000-01-01T00:30:00.000Z | 30 minut  | čez 30 minut      | 1 ura                          |
| 2000-01-01T00:15:00.000Z | 15 minut  | čez 15 minut      | 0 ur                           |
| 2000-01-01T00:01:00.000Z | 1 minuta  | čez 1 minuto      | 0 ur                           |
| 2000-01-01T00:00:25.000Z | 25 sekund | čez 25 sekund     | 0 ur                           |
| 2000-01-01T00:00:15.000Z | 15 sekund | čez 15 sekund     | 0 ur                           |
| 2000-01-01T00:00:05.000Z | 5 sekund  | čez 5 sekund      | 0 ur                           |
| 2000-01-01T00:00:00.000Z | 0 sekund  | pred 0 sekundami  | 0 ur                           |
| 1999-12-31T23:59:55.000Z | 5 sekund  | pred 5 sekundami  | 0 ur                           |
| 1999-12-31T23:59:45.000Z | 15 sekund | pred 15 sekundami | 0 ur                           |
| 1999-12-31T23:59:35.000Z | 25 sekund | pred 25 sekundami | 0 ur                           |
| 1999-12-31T23:59:00.000Z | 1 minuta  | pred 1 minuto     | 0 ur                           |
| 1999-12-31T23:45:00.000Z | 15 minut  | pred 15 minutami  | 0 ur                           |
| 1999-12-31T23:30:00.000Z | 30 minut  | pred 30 minutami  | 1 ura                          |
| 1999-12-31T23:15:00.000Z | 45 minut  | pred 45 minutami  | 1 ura                          |
| 1999-12-31T23:00:00.000Z | 1 ura     | pred 1 uro        | 1 ura                          |
| 1999-12-31T18:00:00.000Z | 6 ur      | pred 6 urami      | 6 ur                           |
| 1999-12-30T00:00:00.000Z | 2 dni     | pred 2 dnevoma    | 48 ur                          |
| 1999-12-15T00:00:00.000Z | 17 dni    | pred 17 dnevi     | 408 ur                         |
| 1999-12-01T00:00:00.000Z | 1 mesec   | pred 1 mesecem    | 744 ur                         |
| 1999-11-01T00:00:00.000Z | 2 meseca  | pred 2 mesecema   | 1464 ur                        |
| 1999-06-01T00:00:00.000Z | 7 mesecev | pred 7 meseci     | 5136 ur                        |
| 1999-01-01T00:00:00.000Z | 1 leto    | pred 1 letom      | 8760 ur                        |
| 1998-12-01T00:00:00.000Z | 1 leto    | pred 1 letom      | 9504 ure                       |
| 1998-06-01T00:00:00.000Z | 2 leti    | pred 2 letoma     | 13896 ur                       |
| 1998-01-01T00:00:00.000Z | 2 leti    | pred 2 letoma     | 17520 ur                       |
| 1997-01-01T00:00:00.000Z | 3 leta    | pred 3 leti       | 26280 ur                       |
| 1996-01-01T00:00:00.000Z | 4 leta    | pred 4 leti       | 35064 ur                       |
| 1995-01-01T00:00:00.000Z | 5 let     | pred 5 leti       | 43824 ur                       |
| 1994-01-01T00:00:00.000Z | 6 let     | pred 6 leti       | 52584 ur                       |

## `formatRelative`

If now is January 1st, 2000, 00:00.

| Date                     | Result                       |
| ------------------------ | ---------------------------- |
| 2000-01-10T00:00:00.000Z | 10. 01. 00                   |
| 2000-01-05T00:00:00.000Z | naslednjo sredo ob 00:00     |
| 2000-01-02T00:00:00.000Z | jutri ob 00:00               |
| 2000-01-01T00:00:00.000Z | danes ob 00:00               |
| 1999-12-31T00:00:00.000Z | včeraj ob 00:00              |
| 1999-12-27T00:00:00.000Z | prejšnji ponedeljek ob 00:00 |
| 1999-12-21T00:00:00.000Z | 21. 12. 99                   |
