/* Feel free to use this example code in any way
   you see fit (Public Domain) */

#include <sys/types.h>
#ifndef _WIN32
#include <sys/select.h>
#include <sys/socket.h>
#else
#include <winsock2.h>
#endif
#include <microhttpd.h>
#include <time.h>
#include <string.h>
#include <stdlib.h>
#include <stdio.h>

#define PORT 8888


static enum MHD_Result
answer_to_connection (void *cls, struct MHD_Connection *connection,
                      const char *url, const char *method,
                      const char *version, const char *upload_data,
                      size_t *upload_data_size, void **con_cls)
{
  char *user;
  char *pass;
  int fail;
  int ret;
  struct MHD_Response *response;
  (void) cls;               /* Unused. Silent compiler warning. */
  (void) url;               /* Unused. Silent compiler warning. */
  (void) version;           /* Unused. Silent compiler warning. */
  (void) upload_data;       /* Unused. Silent compiler warning. */
  (void) upload_data_size;  /* Unused. Silent compiler warning. */

  if (0 != strcmp (method, "GET"))
    return MHD_NO;
  if (NULL == *con_cls)
  {
    *con_cls = connection;
    return MHD_YES;
  }
  pass = NULL;
  user = MHD_basic_auth_get_username_password (connection,
                                               &pass);
  fail = ( (NULL == user) ||
           (0 != strcmp (user, "root")) ||
           (0 != strcmp (pass, "pa$$w0rd") ) );
  if (NULL != user)
    MHD_free (user);
  if (NULL != pass)
    MHD_free (pass);
  if (fail)
  {
    const char *page = "<html><body>Go away.</body></html>";
    response =
      MHD_create_response_from_buffer (strlen (page), (void *) page,
                                       MHD_RESPMEM_PERSISTENT);
    ret = MHD_queue_basic_auth_fail_response (connection,
                                              "my realm",
                                              response);
  }
  else
  {
    const char *page = "<html><body>A secret.</body></html>";
    response =
      MHD_create_response_from_buffer (strlen (page), (void *) page,
                                       MHD_RESPMEM_PERSISTENT);
    ret = MHD_queue_response (connection, MHD_HTTP_OK, response);
  }
  MHD_destroy_response (response);
  return ret;
}


int
main (void)
{
  struct MHD_Daemon *daemon;

  daemon = MHD_start_daemon (MHD_USE_INTERNAL_POLLING_THREAD, PORT, NULL, NULL,
                             &answer_to_connection, NULL, MHD_OPTION_END);
  if (NULL == daemon)
    return 1;

  (void) getchar ();

  MHD_stop_daemon (daemon);
  return 0;
}
