/*
 * Decompiled with CFR 0.152.
 */
package gnu.jel;

import gnu.jel.ClassFile;
import gnu.jel.CompilationException;
import gnu.jel.CompiledExpression;
import gnu.jel.ImageLoader;
import gnu.jel.Library;
import gnu.jel.LocalMethod;
import gnu.jel.OP;
import gnu.jel.OPload;
import gnu.jel.Parser;
import gnu.jel.debug.Debug;
import java.lang.reflect.Method;

public class Evaluator {
    protected static ClassFile cf_orig;
    protected static int retID_patchback;
    protected static int retIDC_patchback;
    protected static LocalMethod[] eval_methods;

    public static CompiledExpression compile(String expression, Library lib, Class resultType) throws CompilationException {
        byte[] image = Evaluator.compileBits(expression, lib, resultType);
        try {
            return (CompiledExpression)ImageLoader.load(image).newInstance();
        }
        catch (Exception exc) {
            Debug.reportThrowable(exc);
            return null;
        }
    }

    public static byte[] compileBits(String expression, Library lib, Class resultType) throws CompilationException {
        OP code = Evaluator.parse(expression, lib, resultType);
        try {
            code = new OPload(code, code.eval());
        }
        catch (Exception exc) {
            // empty catch block
        }
        return Evaluator.getImage(code);
    }

    public static CompiledExpression compile(String expression, Library lib) throws CompilationException {
        return Evaluator.compile(expression, lib, null);
    }

    public static byte[] compileBits(String expression, Library lib) throws CompilationException {
        return Evaluator.compileBits(expression, lib, null);
    }

    static OP parse(String expression, Library lib, Class resultType) throws CompilationException {
        return new Parser(expression, lib).parse(resultType);
    }

    static byte[] getImage(OP code) {
        int retID = code.resID;
        ClassFile cf = cf_orig.clone();
        int otsize = cf.tsize;
        cf.tsize = retID_patchback;
        cf.write((byte)retID);
        cf.tsize = otsize;
        String retName = retID < 8 ? OP.specialTypes[20 + retID].getName() : (retID == 9 ? "java.lang.Void" : code.resType.getName());
        otsize = cf.tsize;
        cf.tsize = retIDC_patchback;
        cf.writeShort(cf.getIndex(retName, 8));
        cf.tsize = otsize;
        cf.newMethod(eval_methods[retID], null);
        code.compile(cf);
        return cf.getImage();
    }

    static {
        retID_patchback = 0;
        retIDC_patchback = 0;
        eval_methods = new LocalMethod[10];
        try {
            Class[] paramsE = new Class[]{new Object[0].getClass()};
            Class[] excptnsE = new Class[]{Class.forName("java.lang.Throwable")};
            for (int i = 0; i < 10; ++i) {
                String name = "evaluate";
                Class<?> cls = OP.specialTypes[i];
                if (i != 8) {
                    name = name + '_' + cls;
                } else {
                    cls = new Object().getClass();
                }
                Evaluator.eval_methods[i] = new LocalMethod(1, cls, name, paramsE, excptnsE);
            }
            Class<?> cmplExpr = Class.forName("gnu.jel.CompiledExpression");
            ClassFile cf = new ClassFile(1, "dump", cmplExpr, null, null);
            LocalMethod cnstr = new LocalMethod(1, Void.TYPE, "<init>", null, null);
            cf.newMethod(cnstr, null);
            cf.code(42L);
            cf.noteStk(-1, 11);
            cf.codeM(cmplExpr.getConstructor(new Class[0]));
            cf.noteStk(11, -1);
            cf.code(177L);
            LocalMethod getType = new LocalMethod(1, Integer.TYPE, "getType", null, null);
            cf.newMethod(getType, null);
            cf.code(16L);
            retID_patchback = cf.tsize;
            cf.code(8L);
            cf.noteStk(-1, 4);
            cf.code(172L);
            cf.noteStk(4, -1);
            Class<?> clazz = Class.forName("java.lang.Class");
            Class[] paramsC = new Class[]{Class.forName("java.lang.String")};
            Method forName = clazz.getMethod("forName", paramsC);
            Class[] excptnsC = new Class[]{Class.forName("java.lang.ClassNotFoundException")};
            LocalMethod getTypeC = new LocalMethod(1, clazz, "getTypeC", null, excptnsC);
            cf.newMethod(getTypeC, null);
            cf.code(19L);
            retIDC_patchback = cf.tsize;
            cf.writeShort(0);
            cf.noteStk(-1, 11);
            cf.codeM(forName);
            cf.noteStk(11, 8);
            cf.code(176L);
            cf.noteStk(8, -1);
            cf_orig = cf.clone();
        }
        catch (Exception exc) {
            Debug.reportThrowable(exc);
        }
    }
}

