#!/usr/bin/python

import sys

header = sys.stdin.readline(), sys.stdin.readline()
dic = dict()
for line in sys.stdin:
	if line[:1] != '0':
		continue

	fields = [x.strip() for x in line.split(';')]
	u = int(fields[0], 16)

	if u == 0x200C or u == 0x200D:
		continue
	if u < 0x0600:
		raise Exception ("Ooops, unexpected unicode character: ", fields)
	dic[u] = fields

v = dic.keys()
v.sort()
min_u, max_u = v[0], v[-1]
occupancy = len(v) * 100 / (max_u - min_u + 1)

# Maintain at least 40% occupancy in the table */
if occupancy < 40:
	raise Exception ("Table too sparse, please investigate: ", occupancy)

print "/* == Start of generated table == */"
print "/*"
print " * The following table is generated by running:"
print " *"
print " *   ./gen-arabic-joining-table.py < ArabicShaping.txt"
print " *"
print " * on the ArabicShaping.txt file with the header:"
print " *"
for line in header:
	print " * %s" % (line.strip())
print " */"

print "#define JOINING_TABLE_FIRST	0x%04x" % min_u
print "#define JOINING_TABLE_LAST	0x%04x" % max_u
print "static const uint8_t joining_table[JOINING_TABLE_LAST-JOINING_TABLE_FIRST+2] ="
print "{"

for i in range(min_u, max_u + 1):
	if i not in dic:
		print "  JOINING_TYPE_X, /* %04X */" % i
	else:
		entry = dic[i]
		if entry[3] in ["ALAPH", "DALATH RISH"]:
			value = "JOINING_GROUP_" + entry[3].replace(' ', '_')
		else:
			value = "JOINING_TYPE_" + entry[2]
		print "  %s, /* %s */" % (value, '; '.join(entry))
print "  JOINING_TYPE_X  /* dummy */"
print "};"
print "/* == End of generated table == */"
