.ig \"-*- nroff -*-
Copyright (C) 1999-2000, 2001 Free Software Foundation, Inc.

Permission is granted to make and distribute verbatim copies of this
manual provided the copyright notice and this permission notice are
preserved on all copies.

Permission is granted to copy and distribute modified versions of this
manual under the conditions for verbatim copying, provided that the
entire resulting derived work is distributed under the terms of a
permission notice identical to this one.

Permission is granted to copy and distribute translations of this
manual into another language, under the above conditions for modified
versions, except that this permission notice may be included in
translations approved by the Free Software Foundation instead of in
the original English.
..
.\" Like TP, but if specified indent is more than half
.\" the current line-length - indent, use the default indent.
.de Tp
.ie \\n(.$=0:((0\\$1)*2u>(\\n(.lu-\\n(.iu)) .TP
.el .TP "\\$1"
..
.TH GROHTML @MAN1EXT@ "@MDATE@" "Groff Version @VERSION@"
.SH NAME
grohtml \- html driver for groff
.SH SYNOPSIS
.nr a \n(.j
.ad l
.nr i \n(.i
.in +\w'\fBgrohtml 'u
.ti \niu
.B grohtml
.de OP
.ie \\n(.$-1 .RI "[\ \fB\\$1\fP" "\\$2" "\ ]"
.el .RB "[\ " "\\$1" "\ ]"
..
.OP \-v?lrn
.OP \-D dir
.OP \-F dir
.OP \-i resolution
.OP \-I image stem
.OP \-o image vertical offset
.RI "[\ " files\|.\|.\|. "\ ]"
.br
.ad \na
.SH DESCRIPTION
.B grohtml
translates the output of GNU
.B troff
to html.
Users should always invoke
.B grohtml
via the groff command with a
.B \-Thtml
option.
If no files are given,
.B grohtml
will read the standard input.
A filename of
.B \-
will also cause
.B grohtml
to read the standard input.
Html output is written to the standard output.
When
.B grohtml
is run by
.B groff
options can be passed to
.B grohtml
using
.BR groff 's
.B \-P
option.
.SH OPTIONS
.TP
.B \-v
Displays the version.
.TP
.B \-?
Emits a usage synopsis.
.TP
.B -l
Turns off the production of automatic section links at the top of the document.
.TP
.B -r
Turns off the automatic header and footer line (html rule).
.TP
.B -n
Generate simple heading anchors whenever a section/number heading is found.
Without the option the anchor value is the textual heading.
This can cause problems when a heading contains a `?' on some brousers
(netscape).
This flag is automatically turned on if a heading contains an image.
.TP
.BI \-F dir
Prepend directory
.IB dir /dev name
to the search path for font and device description files;
.I name
is the name of the device, usually
.BR html .
.TP
.BI \-i resolution
Select the resolution for all images.
By default this is 80 pixels per inch.
Example: -i100 indicates 100 pixels per inch.
.TP
.BI \-I stem
Determine the image stem name.
If omitted grohtml uses
.BI grohtml- XXX
.RI ( XXX
is the process ID).
.TP
.BI \-D dir
Inform
.B grohtml
to place all image files into directory
.IR dir .
.TP
.B \-v
Print the version number.
.TP
.B \-?
Display usage.
.SH USAGE
There are styles called
.BR R ,
.BR I ,
.BR B ,
and
.B BI
mounted at font positions 1 to 4.
.SH DEPENDENCIES
.B grohtml
is dependent upon the png utilities
.RB ( \&\%pnmcut ,\  \%pnmtopng )
and GhostScript
.RB ( gs ).
Images are generated whenever a table, picture, equation or line is
encountered.
.SH BUGS
.B Grohtml
has been completely redesigned and rewritten.
It is still alpha code.
.SH "SEE ALSO"
.BR afmtodit (@MAN1EXT@),
.BR groff (@MAN1EXT@),
.BR @g@troff (@MAN1EXT@),
.BR psbb (@MAN1EXT@),
.BR groff_out (@MAN5EXT@),
.BR groff_font (@MAN5EXT@),
.BR groff_char (@MAN7EXT@)
