'\" e
.\" -*- nroff -*-
.\" This man page must be preprocessed with eqn.
.ie \n(.g .ds ic \/
.el .ds ic \^
.TH GROFF_OUT @MAN5EXT@ "@MDATE@" "Groff Version @VERSION@"
.SH NAME
groff_out \- groff intermediate output format
.SH DESCRIPTION
This manual page describes the format output by GNU troff.
The output format used by GNU troff is very similar to that used
by Unix device-independent troff. Only the differences are documented
here.
.LP
The argument to the
.B s
command is in scaled points (units of
.IR points/ n ,
where
.I n
is the argument to the
.B sizescale
command  in the DESC file.)
The argument to the
.B x\ Height
command is also in scaled points.
.LP
The first three output commands are guaranteed to be:
.IP
.BI x\ T\  device
.br
.BI x\ res\  n\ h\ v
.br
.B x init
.LP
If the
.B tcommand
line is present in the DESC file, troff will use the following
two commands
.TP
.BI t xxx
.I xxx
is any sequence of characters terminated by a space or a newline;
the first character should be printed at the current position,
the the current horizontal position should be increased by
the width of the first character, and so on for each character.
The width of the character is that given in the font file,
appropriately scaled for the current point size, and rounded
so that it is a multiple of the horizontal resolution.
Special characters cannot be printed using this command.
.TP
.BI u n\ xxx
This is same as the
.B t
command except that after printing each character, the current horizontal
position is increased by the sum of the width of that character
and
.IR n .
.LP
Note that single characters can have the eighth bit set, as can the
names of fonts and special characters.
.LP
The names of characters and fonts an be of arbitrary length; drivers
should not assume that they will be only two characters long.
.LP
When a character is to be printed, that character will always be
in the current font.
Unlike device-independent troff, it is not necessary
for drivers to search special fonts to find a character.
.LP
The
.B D
drawing command has been extended.
These extensions will only be used by GNU pic if the
.B \-x
option is given.
.TP
\fBDf \fIn\fR\*(ic\en
Set the shade of gray to be used for filling solid objects to
.IR n ;
.I n
must be an integer between 0 and 1000, where 0 corresponds solid white
and 1000 to solid black, and values in between correspond to
intermediate shades of gray.
This applies only to solid circles, solid ellipses and solid
polygons.
By default, a level of 1000 will be used.
Whatever color a solid object has, it should completely obscure
everything beneath it.
A value greater than 1000 or less than 0 can also be used:
this means fill with the shade of gray that is currently being used
for lines and text.
Normally this will be black, but some drivers may provide
a way of changing this.
.TP
\fBDC \fId\fR\*(ic\en
Draw a solid circle with a diameter of
.I d
with the leftmost point at the current position.
.TP
\fBDE \fIdx dy\fR\*(ic\en
Draw a solid ellipse with a horizontal diameter of
.I dx
and a vertical diameter of
.I dy
with the leftmost point at the current position.
.EQ
delim $$
.EN
.TP
\fBDp\fR $dx sub 1$ $dy sub 1$ $dx sub 2$ $dy sub 2$ $...$ $dx sub n$ $dy sub n$\en
Draw a polygon with,
for $i = 1 ,..., n+1$, the
.IR i -th
vertex at the current position 
$+ sum from j=1 to i-1 ( dx sub j , dy sub j )$.
At the moment,
GNU pic only uses this command to generate triangles and rectangles.
.TP
\fBDP\fR $dx sub 1$ $dy sub 1$ $dx sub 2$ $dy sub 2$ $...$ $dx sub n$ $dy sub n$\en
Like
.B Dp
but draw a solid rather than outlined polygon.
.TP
\fBDt \fIn\fR\*(ic\en
Set the current line thickness to
.I n
machine units.
Traditionally Unix troff drivers use a line thickness proportional to the current
point size; drivers should continue to do this if no
.B Dt
command has been given, or if a
.B Dt
command has been given with a negative value of
.IR n .
A zero value of
.I n
selects the smallest available line thickness.
.LP
A difficulty arises in how the current position should be changed after
the execution of these commands.
This is not of great importance since the code generated by GNU pic
does not depend on this.
Given a drawing command of the form
.IP
\fB\eD\(fm\fIc\fR $x sub 1$ $y sub 1$ $x sub 2$ $y sub 2$ $...$ $x sub n$ $y sub n$\(fm
.LP
where
.I c
is not one of
.BR c ,
.BR e ,
.BR l ,
.B a
or
.BR ~ ,
Unix troff will treat each of the $x sub i$ as a horizontal quantity,
and each of the $y sub i$ as a vertical quantity and will assume that
the width of the drawn object is $sum from i=1 to n x sub i$,
and that the height is $sum from i=1 to n y sub i$.
(The assumption about the height can be seen by examining the
.B st
and
.B sb
registers after using such a
.B D
command in a \ew escape sequence.)
This rule also holds for all the original drawing commands
with the exception of
.BR De .
For the sake of compatibility GNU troff also follows this rule,
even though it produces an ugly result in the case of the
.BR Df ,
.BR Dt ,
and, to a lesser extent,
.B DE
commands.
Thus after executing a
.B D
command of the form
.IP
\fBD\fIc\fR $x sub 1$ $y sub 1$ $x sub 2$ $y sub 2$ $...$ $x sub n$ $y sub n$\en
.LP
the current position should be increased by
$( sum from i=1 to n x sub i , sum from i=1 to n y sub i )$.
.LP
There is a continuation convention which permits the argument to the
.B x\ X
command to contain newlines:
when outputting the argument to the
.B x\ X
command, GNU troff
will follow each newline in the argument with a
.B +
character
(as usual, it will terminate the entire argument with a newline);
thus if the line after the line containing the
.B x\ X
command starts with
.BR + ,
then the newline ending the line containing the
.B x\ X
command should be treated as part of the argument to the
.B x\ X
command,
the
.B +
should be ignored,
and the part of the line following the
.B +
should be treated like the part of the line following the
.B x\ X
command.
.SH "SEE ALSO"
.BR groff_font (@MAN5EXT@)
