--
-- This file is part of GNUnet
-- Copyright (C) 2014--2022 GNUnet e.V.
--
-- GNUnet is free software; you can redistribute it and/or modify it under the
-- terms of the GNU General Public License as published by the Free Software
-- Foundation; either version 3, or (at your option) any later version.
--
-- GNUnet is distributed in the hope that it will be useful, but WITHOUT ANY
-- WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
-- A PARTICULAR PURPOSE.  See the GNU General Public License for more details.
--
-- You should have received a copy of the GNU General Public License along with
-- GNUnet; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
--

-- Everything in one big transaction
BEGIN;

-- Check patch versioning is in place.
SELECT _v.register_patch('datastore-0001', NULL, NULL);

-------------------- Schema ----------------------------

CREATE SCHEMA datastore;
COMMENT ON SCHEMA datastore IS 'gnunet-datastore data';

SET search_path TO datastore;

CREATE TABLE IF NOT EXISTS gn090 (
  repl INTEGER NOT NULL DEFAULT 0,
  type INTEGER NOT NULL DEFAULT 0,
  prio INTEGER NOT NULL DEFAULT 0,
  anonLevel INTEGER NOT NULL DEFAULT 0,
  expire BIGINT NOT NULL DEFAULT 0,
  rvalue BIGINT NOT NULL DEFAULT 0,
  hash BYTEA NOT NULL DEFAULT '',
  vhash BYTEA NOT NULL DEFAULT '',
  value BYTEA NOT NULL DEFAULT '',
  oid  BIGINT GENERATED BY DEFAULT AS IDENTITY);

CREATE INDEX IF NOT EXISTS oid_hash ON gn090 (oid);
CREATE INDEX IF NOT EXISTS idx_hash ON gn090 (hash);
CREATE INDEX IF NOT EXISTS idx_prio_anon ON gn090 (prio,anonLevel);
CREATE INDEX IF NOT EXISTS idx_prio_hash_anon ON gn090 (prio,hash,anonLevel);
CREATE INDEX IF NOT EXISTS idx_repl_rvalue ON gn090 (repl,rvalue);
CREATE INDEX IF NOT EXISTS idx_expire_hash ON gn090 (expire,hash);

COMMIT;
