/* tnputc.c */

/* Copyright 1997 by Eberhard Mattes <mattes@azu.informatik.uni-stuttgart.de>
   Donated to the public domain.  No warranty.

   1997-01-04 Initial version
   1997-01-18 Fix various bugs
   1997-04-05 Reorganize library */

#include <stdlib.h>
#include <string.h>
#include <arpa/telnet.h>
#include "firewall.h"
#include "libemtn.h"
#include "tnint.h"

void tn_putslen (tnconn *t, const char *s, size_t len)
{
  if ((t->init_flags & TN_INIT_TELNET) && memchr (s, IAC, len) != NULL)
    {
      char buf[512];
      int i = 0;

      while (len != 0)
	{
	  if ((unsigned char)*s == IAC)
	    {
	      if (i > sizeof (buf) - 2)
		{
		  tn_write (t, buf, i);
		  i = 0;
		}
	      buf[i++] = IAC;
	    }
	  if (i > sizeof (buf) - 1)
	    {
	      tn_write (t, buf, i);
	      i = 0;
	    }
	  buf[i++] = *s++; --len;
	}
      if (i != 0)
	tn_write (t, buf, i);
    }
  else
    tn_write (t, s, len);
}


void tn_puts (tnconn *t, const char *s)
{
  tn_putslen (t, s, strlen (s));
}


void tn_putnl (tnconn *t)
{
  tn_write (t, "\r\n", 2);
}
