/*
 * monHand.h --
 *
 *      Declarations of Monitor's internal, non-opaque handles,
 *      which are not exported out of the package.
 *
 * Copyright(C) 1995, 1996 NEC Corporation. All rights reserved.
 * This is a genuine component of Socks5Toolkit(TM).
 *
 * $Header: /insg/project/socks/s5watch/include/monHand.h,v 1.4 1997/02/10 23:45:10 miked Exp $
 * $Log: monHand.h,v $
 * Revision 1.4  1997/02/10 23:45:10  miked
 * Added parameter `all' to (*getNextProc)() in MonXferVec_t.
 *
 * Revision 1.3  1997/02/06  18:39:57  miked
 * Merged OSTC/NT and NWSL/UNIX versions.
 *
 * Revision 1.3  1996/09/06 22:06:40  naomi
 * Removed errMsg and errNum fields from MonHand_t
 * Revision 1.2  1996/09/05 21:22:19  naomi
 * Changes to where Jonathan left off...
 * Revision 1.1  1996/09/04 21:43:04  naomi
 * Initial revision
 * Revision 1.1.1.1  1996/08/30 02:43:49  miked
 * Initial version.
 *
 * Revision 1.4  1996/07/30  21:00:58  miked
 * Yet another copyright notice.
 *
 * Revision 1.3  1996/07/11  04:32:08  miked
 * Changed MON_HAND_SOCKS flag value.
 *
 * Revision 1.2  1996/07/09  23:57:45  miked
 * Added new copyright notice.
 *
 * Revision 1.1.1.1  1996/07/08  15:09:42  miked
 * Initial version for Socks5 API.
 */

#ifndef _H_MONHAND
#define _H_MONHAND

#include "monPort.h"

/*
 *----------------------------------------------------------------------
 *    C O N S T A N T S
 *----------------------------------------------------------------------
 */

/*
 * Valid MonHandle_t `flag' values (unlikely hex patterns in memory).
 */

#define MON_HAND_SOCKS    0xbadfaced   /* Handle valid for Socks5 to Monitor */
#define MON_HAND_PIPE     0xdeedfade   /* Handle valid for pipe xfers */
#define MON_HAND_MEM      0xbabeface   /* Handle valid for mmap() xfers */
#define MON_HAND_NET      0xdeafbead   /* Handle valid for network xfers */
#define MON_HAND_MUTEX    0xfeedcafe   /* Handle valid for mutex operations  */
#define MON_HAND_PERF_DLL 0xdeafbabe   /* Handle valid perfmon transactions */
#define MON_HAND_DEAD     0xdeadbeef   /* Handle is invalid */

#define MON_HANDNAME_SIZE (255+1)

/*
 *----------------------------------------------------------------------
 *    D A T A   S T R U C T U R E S
 *----------------------------------------------------------------------
 */

/*
 * Data xfer function vector for open, close, put, get, getNext.
 */

typedef struct {
    int        (*openProc)           /* Open data transfer channel */
                   (CONST char FAR*  name,
                    int              clientType,
                    S5MonHandle FAR* handlePtr
                   );
    int        (*closeProc)          /* Close data transfer channel */
                   (S5MonHandle      handle);

    int        (*putProc)            /* Put Socks5 data into table by key */
                   (S5MonHandle      handle,
                    S5MonData FAR*   dataPtr
                   );
    int        (*getProc)            /* Get Socks5 data from table by key */
                   (S5MonHandle      handle,
                    S5MonData FAR*   dataPtr
                   );
    int        (*getNextProc)        /* Get next Socks5 data from table */
                   (S5MonHandle      handle,
                    unsigned int     all,
                    S5MonData FAR*   dataPtr
                   );
} MonXferVec_t;


/*
 * Mutex function vector for open, close, request, release, query.
 */

typedef struct {
    int        (*openProc)           /* Open mutex */
                   (CONST char FAR*  name,
                    Boolean_t        create,
                    S5MonHandle FAR* handlePtr
                   );
    int        (*closeProc)          /* Close mutex */
                   (S5MonHandle      handle);

    int        (*requestProc)        /* Request mutex */
                   (S5MonHandle      handle);

    int        (*releaseProc)        /* Release mutex */
                   (S5MonHandle      handle);

    int        (*queryProc)          /* Query lock count on mutex */
                   (S5MonHandle      handle);
} MonMutexVec_t;


typedef struct {
    Uint32     flag;                   /* Indicates type & validity of handle */
    union {                            /* Handle-specific function vector */
          MonXferVec_t     xfer;
          MonMutexVec_t    mutex;
    } vec;
    VOID FAR*  infoPtr;                /* Ptr to handle-specific information */

    char       name[MON_HANDNAME_SIZE];/* Name associated with handle */
} FAR* MonHand_t;

#endif /* _H_MONHAND */
