package RISC::Workload;

use 5.010;
use strict;
use warnings;
use SOAP::Lite;
use MIME::Base64;
use Data::Dumper;

$Data::Dumper::Indent = 1; #makes the indention more readable
$Data::Dumper::Maxdepth = 3; #no deeper than 3 refs down
$Data::Dumper::Purity = 1; #setting to 1 causes some gobbledy-gook

use vars qw($proxy);
my $proxy = "https://reportingapi.riscnetworks.com/services/AdvancedReportingTest";

use Exporter;
our @ISA = qw(Exporter);
our %EXPORT_TAGS = ( 'all' => [ qw() ] );
our @EXPORT_OK = ( @{ $EXPORT_TAGS{'all'} } );
our @EXPORT = qw( );

=head1 RISC Networks Workload Data

RISC::Workload - Allows access to workload data through a set of subroutines with JSON formatted return objects

=head1 VERSION

Version 0.01

=cut

our $VERSION = '0.01';


=head1 SYNOPSIS

This module allows access to workload data through a set of subroutines with JSON formatted return objects

    * Code snippet:
        use RISC::Workload;

        my $val = RISC::Workload::MethodName(var1, var2, var3);
        
        ...
    
    * Find example scripts in the example folder

=head1 EXPORT
    Decode
    GetWorkloadSummaryJSON
    GetGroupsByPlan
    GetWorkloadDeviceJSON
    GetWorkloadDiskJSON
    GetWorkloadFileSystemJSON
    GetWorkloadNicJSON
    GetWorkloadApplicationJSON


=head1 SUBROUTINES/METHODS

=head2 Decode

    Decode the Base64 return object
    
=cut

sub Decode {
    my ($obj) = @_;
    $obj =  MIME::Base64::decode_base64($obj);
    return $obj;
}

=head2 GetWorkloadSummaryJSON

    Get the workload summary by group ID
        * isPlan=false and does not currently accommodate isPlan=true
        * id parameter should be a group id (use GetGroupsByPlan subroutine to get a list of group IDs)
        * This method returns a Base64 String and will require decoding
        
=cut

sub GetWorkloadSummaryJSON {
    my ($authuser, $authpass, $assessmentcode, $isPlan, $id) = @_;
    print "GetWorkloadSummaryJSON: authuser=$authuser | authpass=$authpass | assessmentcode=$assessmentcode | isPlan=$isPlan | id=$id\n"; #test
    my $appRequest = SOAP::Lite
        -> proxy($proxy, timeout=>900);
    my $soapData1 = SOAP::Data->name('authuser')->value($authuser)->type('string');
    my $soapData2 = SOAP::Data->name('authpass')->value($authpass)->type('string');
    my $soapData3 = SOAP::Data->name('assessmentcode')->value($assessmentcode)->type('string');
    my $soapData4 = SOAP::Data->name('isPlan')->value('false')->type('boolean');
    my $soapData5 = SOAP::Data->name('id')->value($id)->type('int');
    
    my $result = undef;
    
    eval {
        $result = $appRequest->getWorkloadSummaryJSON($soapData1, $soapData2, $soapData3, $soapData4, $soapData5);
    };
    return $result->result();
}
=head2 GetGroupsByPlan

    Get a list of group IDs from a plan ID
    
=cut

sub GetGroupsByPlan {
    my ($authuser, $authpass, $assessmentcode, $planid) = @_;
    print "GetGroupsByPlan: authuser=$authuser | authpass=$authpass | planid=$planid\n"; #test
    my $appRequest = SOAP::Lite
        -> proxy($proxy);
    my $soapData1 = SOAP::Data->name('authuser')->value($authuser)->type('string');
    my $soapData2 = SOAP::Data->name('authpass')->value($authpass)->type('string');
    my $soapData3 = SOAP::Data->name('assessmentcode')->value($assessmentcode)->type('string');
    my $soapData4 = SOAP::Data->name('planid')->value($planid)->type('int');
    
    my $result = undef;
    
    eval {
        $result = $appRequest->getGroupsByPlan($soapData1, $soapData2, $soapData3, $soapData4);
    };
    return $result->result();
}

=head2 GetWorkloadDeviceJSON

    Get workload device by device ID
        * This method returns a Base64 String and will require decoding
        
=cut

sub GetWorkloadDeviceJSON {
    my ($authuser, $authpass, $assessmentcode, $deviceid) = @_;
    print "GetWorkloadDeviceJSON: authuser=$authuser | authpass=$authpass | deviceid=$deviceid\n"; #test
    
    my $appRequest = SOAP::Lite
        -> proxy($proxy);
    my $soapData1 = SOAP::Data->name('authuser')->value($authuser)->type('string');
    my $soapData2 = SOAP::Data->name('authpass')->value($authpass)->type('string');
    my $soapData3 = SOAP::Data->name('assessmentcode')->value($assessmentcode)->type('string');
    my $soapData4 = SOAP::Data->name('deviceid')->value($deviceid)->type('long');
    
    my $result = undef;
    
    eval {
        $result = $appRequest->getWorkloadDeviceJSON($soapData1, $soapData2, $soapData3, $soapData4);
    };
    return $result->result();
}

=head2 GetWorkloadDiskJSON

    Get workload disk by device ID
        * This method returns a Base64 String and will require decoding
        
=cut

sub GetWorkloadDiskJSON {
    my ($authuser, $authpass, $assessmentcode, $deviceid) = @_;
    print "GetWorkloadDiskJSON: authuser=$authuser | authpass=$authpass | assessmentcode=$assessmentcode | deviceid=$deviceid\n"; #test
    
    my $appRequest = SOAP::Lite
        -> proxy($proxy);
    my $soapData1 = SOAP::Data->name('authuser')->value($authuser)->type('string');
    my $soapData2 = SOAP::Data->name('authpass')->value($authpass)->type('string');
    my $soapData3 = SOAP::Data->name('assessmentcode')->value($assessmentcode)->type('string');
    my $soapData4 = SOAP::Data->name('deviceid')->value($deviceid)->type('long');
    
    my $result = undef;
    
    eval {
        $result = $appRequest->getWorkloadDiskJSON($soapData1, $soapData2, $soapData3, $soapData4);
    };
    return $result->result();
}

=head2 GetWorkloadFileSystemJSON

    Get workload file system by device ID
        * This method returns a Base64 String and will require decoding
        
=cut

sub GetWorkloadFileSystemJSON {
    my ($authuser, $authpass, $assessmentcode, $deviceid) = @_;
    print "GetWorkloadFileSystemJSON: authuser=$authuser | authpass=$authpass | deviceid=$deviceid\n"; #test
    
    my $appRequest = SOAP::Lite
        -> proxy($proxy);
    my $soapData1 = SOAP::Data->name('authuser')->value($authuser)->type('string');
    my $soapData2 = SOAP::Data->name('authpass')->value($authpass)->type('string');
    my $soapData3 = SOAP::Data->name('assessmentcode')->value($assessmentcode)->type('string');
    my $soapData4 = SOAP::Data->name('deviceid')->value($deviceid)->type('long');
    
    my $result = undef;
    
    eval {
        $result = $appRequest->getWorkloadFileSystemJSON($soapData1, $soapData2, $soapData3, $soapData4);
    };
    return $result->result();
}

=head2 GetWorkloadNicJSON

    Get workload Nic by device ID
        * This method returns a Base64 String and will require decoding
        
=cut

sub GetWorkloadNicJSON {
    my ($authuser, $authpass, $assessmentcode, $deviceid) = @_;
    print "GetWorkloadNicJSON: authuser=$authuser | authpass=$authpass | deviceid=$deviceid\n"; #test
    
    my $appRequest = SOAP::Lite
        -> proxy($proxy);
    my $soapData1 = SOAP::Data->name('authuser')->value($authuser)->type('string');
    my $soapData2 = SOAP::Data->name('authpass')->value($authpass)->type('string');
    my $soapData3 = SOAP::Data->name('assessmentcode')->value($assessmentcode)->type('string');
    my $soapData4 = SOAP::Data->name('deviceid')->value($deviceid)->type('long');
    
    my $result = undef;
    
    eval {
        $result = $appRequest->getWorkloadNicJSON($soapData1, $soapData2, $soapData3, $soapData4);
    };
    return $result->result();
}

=head2 GetWorkloadApplicationJSON

    Get workload applications by device ID
        * This method returns a Base64 String and will require decoding
        
=cut

sub GetWorkloadApplicationJSON {
    my ($authuser, $authpass, $assessmentcode, $deviceid) = @_;
    print "GetWorkloadApplicationJSON: authuser=$authuser | authpass=$authpass | assessmentcode=$assessmentcode | deviceid=$deviceid\n"; #test
    
    my $appRequest = SOAP::Lite
        -> proxy($proxy);
    my $soapData1 = SOAP::Data->name('authuser')->value($authuser)->type('string');
    my $soapData2 = SOAP::Data->name('authpass')->value($authpass)->type('string');
    my $soapData3 = SOAP::Data->name('assessmentcode')->value($assessmentcode)->type('string');
    my $soapData4 = SOAP::Data->name('deviceid')->value($deviceid)->type('long');
    my $result = undef;
    
    eval {
        $result = $appRequest->getWorkloadApplicationJSON($soapData1, $soapData2, $soapData3, $soapData4);
    };
    return $result->result();
}

=head1 AUTHOR

Katelynn Alexander, C<< <kalexander at riscnetworks.com> >>

=head1 SUPPORT

You can find documentation for this module with the perldoc command.

    perldoc RISC::Workload

=head1 LICENSE AND COPYRIGHT

Copyright 2015 Katelynn Alexander.

This program is free software; you can redistribute it and/or modify it
under the terms of the the Artistic License (2.0). You may obtain a
copy of the full license at:

L<http://www.perlfoundation.org/artistic_license_2_0>

Any use, modification, and distribution of the Standard or Modified
Versions is governed by this Artistic License. By using, modifying or
distributing the Package, you accept this license. Do not use, modify,
or distribute the Package, if you do not accept this license.

If your Modified Version has been derived from a Modified Version made
by someone other than you, you are nevertheless required to ensure that
your Modified Version complies with the requirements of this license.

This license does not grant you the right to use any trademark, service
mark, tradename, or logo of the Copyright Holder.

This license includes the non-exclusive, worldwide, free-of-charge
patent license to make, have made, use, offer to sell, sell, import and
otherwise transfer the Package with respect to any patent claims
licensable by the Copyright Holder that are necessarily infringed by the
Package. If you institute patent litigation (including a cross-claim or
counterclaim) against any party alleging that the Package constitutes
direct or contributory patent infringement, then this Artistic License
to you shall terminate on the date that such litigation is filed.

Disclaimer of Warranty: THE PACKAGE IS PROVIDED BY THE COPYRIGHT HOLDER
AND CONTRIBUTORS "AS IS' AND WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES.
THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
PURPOSE, OR NON-INFRINGEMENT ARE DISCLAIMED TO THE EXTENT PERMITTED BY
YOUR LOCAL LAW. UNLESS REQUIRED BY LAW, NO COPYRIGHT HOLDER OR
CONTRIBUTOR WILL BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, OR
CONSEQUENTIAL DAMAGES ARISING IN ANY WAY OUT OF THE USE OF THE PACKAGE,
EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


=cut

1; # End of RISC::Workload
