# Generated by default/object.tt
package Paws::SageMaker::CallbackStepMetadata;
  use Moose;
  has CallbackToken => (is => 'ro', isa => 'Str');
  has OutputParameters => (is => 'ro', isa => 'ArrayRef[Paws::SageMaker::OutputParameter]');
  has SqsQueueUrl => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::SageMaker::CallbackStepMetadata

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::SageMaker::CallbackStepMetadata object:

  $service_obj->Method(Att1 => { CallbackToken => $value, ..., SqsQueueUrl => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::SageMaker::CallbackStepMetadata object:

  $result = $service_obj->Method(...);
  $result->Att1->CallbackToken

=head1 DESCRIPTION

Metadata about a callback step.

=head1 ATTRIBUTES


=head2 CallbackToken => Str

The pipeline generated token from the Amazon SQS queue.


=head2 OutputParameters => ArrayRef[L<Paws::SageMaker::OutputParameter>]

A list of the output parameters of the callback step.


=head2 SqsQueueUrl => Str

The URL of the Amazon Simple Queue Service (Amazon SQS) queue used by
the callback step.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::SageMaker>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

