package Net::Amazon::EMR::InstanceGroupDetail;
use Moose;
with 'Net::Amazon::EMR::Role::AttrHash';
use Net::Amazon::EMR::Coercions;
use Moose::Util::TypeConstraints;

has 'BidPrice' => ( is => 'ro', 
                    isa => 'Net::Amazon::EMR::Type::ConstrainedStr',
                    coerce => 1,
                );

has 'CreationDateTime' => ( is => 'ro', 
                            isa => 'Net::Amazon::EMR::Type::DateTime',
                            coerce => 1,
                            required => 1,
                        );

has 'EndDateTime' => ( is => 'ro', 
                       isa => 'Net::Amazon::EMR::Type::DateTime',
                       coerce => 1,
    );

has 'InstanceGroupId' => ( is => 'ro', 
                           isa => 'Net::Amazon::EMR::Type::ConstrainedStr',
                           coerce => 1,
                       );

has 'InstanceRequestCount' => ( is => 'ro', 
                                isa => 'Int',
                                required => 1,
                            );

subtype 'Net::Amazon::EMR::Type::InstanceGroupDetail::Role' => as 'Str' => where { m/^(?:MASTER | CORE | TASK)$/x };
has 'InstanceRole' => ( is => 'ro', 
                        isa => 'Net::Amazon::EMR::Type::InstanceGroupDetail::Role',
                        required => 1,
                    );

has 'InstanceRunningCount' => ( is => 'ro', 
                                isa => 'Int' );

has 'InstanceType' => ( is => 'ro', 
                        isa => 'Net::Amazon::EMR::Type::NonEmptyConstrainedStr',
                        coerce => 1,
                        required => 1,
                    );

has 'LastStateChangeReason' => ( is => 'ro', 
                                 isa => 'Net::Amazon::EMR::Type::LongConstrainedStr',
                                 coerce => 1,
                             );

subtype 'Net::Amazon::EMR::Type::InstanceGroupDetail::Market' => as 'Str' => where { m/^(?:ON_DEMAND | SPOT)$/x };

has 'Market' => ( is => 'ro',
                  isa => 'Net::Amazon::EMR::Type::InstanceGroupConfig::Market',
                  required => 1,
              );

has 'Name' => ( is => 'ro', 
                isa => 'Net::Amazon::EMR::Type::ConstrainedStr',
                coerce => 1,
            );


has 'ReadyDateTime' => ( is => 'ro', 
                         isa => 'Net::Amazon::EMR::Type::DateTime',
                         coerce => 1,
    );

has 'StartDateTime' => ( is => 'ro', 
                         isa => 'Net::Amazon::EMR::Type::DateTime',
                         coerce => 1,
    );

subtype 'Net::Amazon::EMR::Type::InstanceGroupDetail::State' => as 'Str' => where { m/^(?:PROVISIONING | BOOTSTRAPPING | RUNNING | RESIZING | SUSPENDED | TERMINATING | TERMINATED | ARRESTED | SHUTTING_DOWN | ENDED)$/x };

has 'State' => ( is => 'ro', 
                 isa => 'Net::Amazon::EMR::Type::InstanceGroupDetail::State',
                 required => 1,
             );


__PACKAGE__->meta->make_immutable();

1;

__END__

=head1 NAME

Net::Amazon::EMR::InstanceGroupDetail

=head1 DESCRIPTION

Implements the InstanceGroupDetail data type described at L<http://docs.amazonwebservices.com/ElasticMapReduce/latest/APIReference/API_InstanceGroupDetail.html>.

=head1 AUTHOR

Jon Schutz 

L<http://notes.jschutz.net>

=head1 DOCUMENTATION, LICENSE AND COPYRIGHT

See L<Net::Amazon::EMR>.

=cut
