use Test::More;

BEGIN {
	use Hades;
	Hades->run({
		eval => 'Kato { 
			penthos :required 
			curae :r :default(5)
			nosoi :default(3)
			hypnos :default(this is just a test)
			geras { if ($_[0]->penthos == $_[0]->nosoi) { return $_[0]->curae; } } 
		}
		Kato::Kosmos parent Kato { 
			algea :d([{ test => [qw/a b c/] }])
		}',
		lib => 't/lib'
	});
	use lib 't/lib';
}

use Kato;
my $okay = Kato->new({
	penthos => 2,
	nosoi => 2,
});

is($okay->penthos, 2);
is($okay->nosoi, 2);
is($okay->curae, 5);
is($okay->geras, 5);

my $not_okay = eval { 
	Kato->new({
		curae => 5
	});
};

like($@, qr/^penthos accessor is required/);

use Kato::Kosmos;
my $okay = Kato::Kosmos->new({
	penthos => 2,
	nosoi => 2,
});
is($okay->penthos, 2);
is($okay->nosoi, 2);
is($okay->curae, 5);
is($okay->geras, 5);
is_deeply($okay->algea, [{ test => [qw/a b c/] }]);

$not_okay = eval {
	Kato::Kosmos->new({
		curae => 5
	});
};

like($@, qr/^penthos accessor is required/);



done_testing;
