/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.server.commandhandler;

import com.google.common.collect.ImmutableMap;
import com.google.common.net.MediaType;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import org.openqa.selenium.BuildInfo;
import org.openqa.selenium.grid.web.CommandHandler;
import org.openqa.selenium.json.Json;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;

public class Status
implements CommandHandler {
    private final Json json;

    Status(Json json) {
        this.json = Objects.requireNonNull(json);
    }

    @Override
    public void execute(HttpRequest req, HttpResponse resp) throws IOException {
        ImmutableMap.Builder<String, Object> value = ImmutableMap.builder();
        value.put("ready", true);
        value.put("message", "Server is running");
        BuildInfo buildInfo = new BuildInfo();
        value.put("build", ImmutableMap.of("revision", buildInfo.getBuildRevision(), "time", buildInfo.getBuildTime(), "version", buildInfo.getReleaseLabel()));
        value.put("os", ImmutableMap.of("arch", System.getProperty("os.arch"), "name", System.getProperty("os.name"), "version", System.getProperty("os.version")));
        value.put("java", ImmutableMap.of("version", System.getProperty("java.version")));
        ImmutableMap payloadObj = ImmutableMap.of("status", 0, "value", value.build());
        byte[] payload = this.json.toJson(payloadObj).getBytes(StandardCharsets.UTF_8);
        resp.setStatus(200);
        resp.setHeader("Content-Type", MediaType.JSON_UTF_8.toString());
        resp.setHeader("Content-Length", String.valueOf(payload.length));
        resp.setContent(payload);
    }
}

