/*	Style Definition for Hypertext				HTStyle.h
**	==============================
**
**	Styles allow the translation between a logical property of a piece of
**	text and its physical representation.
**
**	A StyleSheet is a collection of styles, defining the
**	translation necessary to represent a document.
**	It is a linked list of styles.
*/
#ifndef HTSTYLE_H
#define HTSTYLE_H

#include "HTUtils.h"
#include "HTAnchor.h"
#include "HTStream.h"
#include "HTFont.h"

#ifdef NeXT_suppressed
#import <appkit/appkit.h>
typedef NXCoord HTCoord;
#define HTParagraphStyle NXTextStyle
#define HTCoord NXCoord
typedef struct _color {
	float	grey;
	int	RGBColor;
} HTColor;
#else

typedef float HTCoord;

typedef struct _HTParagraphStyle {
    HTCoord	left_indent;		/* @@@@ junk! etc etc*/
} HTParagraphStyle;

typedef int HTColor;		/* Sorry about the US spelling! */

#endif



#define STYLE_NAME_LENGTH	80	/* @@@@@@@@@@@ */

typedef enum _SGML_tagtype {
	NONE,			/* Style holds until further notice 	*/
	ENDTAG, 		/* Style holds until end tag </xxx> 	*/
	LINE 			/* Style holds until end of line (ugh!)	*/
} SGML_tagtype;
	 
typedef struct {
    short           	kind;		/* only NX_LEFTTAB implemented*/
    HTCoord         	position;	/* x coordinate for stop */
} HTTabStop;


/*	The Style Structure
**	-------------------
*/

typedef struct _HTStyle {

/*	Style management information
*/
    struct _HTStyle	*next;		/* Link for putting into stylesheet */
    char *		name;		/* Style name */
    char *		SGMLTag;	/* Tag name to start */
    SGML_tagtype	SGMLType;	/* How to end it */


/*	Character attributes	(a la NXRun)
*/
    HTFont 	    	font;		/* Font id */
    HTCoord		fontSize;	/* The size of font, not independent */
    HTColor	    	color;	/* text gray of current run */
    int   		superscript;	/* superscript (-sub) in points */

    HTAnchor		*anchor;	/* Anchor id if any, else zero */

/*	Paragraph Attribtes	(a la NXTextStyle)
*/
    HTCoord		indent1st;	/* how far first line in paragraph is
				 * indented */
    HTCoord		leftIndent;	/* how far second line is indented */
    HTCoord		rightIndent;	/* (Missing from NeXT version */
    short       	alignment;	/* quad justification */
    HTCoord		lineHt;		/* line height */
    HTCoord     	descentLine;	/* descender bottom from baseline */
    HTTabStop   	*tabs;		/* array of tab stops, 0 terminated */

    BOOL		wordWrap;	/* Yes means wrap at space not char */
    BOOL		freeFormat;	/* Yes means \n is just white space */
    HTCoord		spaceBefore;	/* Omissions from NXTextStyle */
    HTCoord		spaceAfter;
    int			paraFlags;	/* Paragraph flags, bits as follows: */

#define PARA_KEEP	1	/* Do not break page within this paragraph */
#define	PARA_WITH_NEXT	2	/* Do not break page after this paragraph */

#define HT_JUSTIFY 0		/* For alignment */
#define HT_LEFT	1
#define HT_RIGHT 2
#define HT_CENTER 3
  
} HTStyle;


/*	Style functions:
*/
extern HTStyle * HTStyleNew NOPARAMS;
extern HTStyle * HTStyleFree(HTStyle * self);
extern HTStyle * HTStyleRead(HTStyle * self, HTStream * stream);
extern HTStyle * HTStyleWrite(HTStyle * self, HTStream * stream);
/* extern HTStyle * HTStyleApply(HTStyle * self, HText * text);
   extern HTStyle * HTStylePick(HTStyle * self, HText * text);
*/
/*		Style Sheet
**		-----------
*/
typedef struct _HTStyleSheet {
	char *		name;
	HTStyle *	styles;
} HTStyleSheet;


/*	Stylesheet functions:
*/
extern HTStyleSheet * HTStyleSheetNew();
extern HTStyleSheet * HTStyleSheetFree(HTStyleSheet * self);
extern HTStyle * HTStyleNamed(HTStyleSheet * self, const char * name);
extern HTStyle * HTStyleForParagraph(HTStyleSheet * self,
	HTParagraphStyle * paraStyle);
extern HTStyle * HTStyleMatching(HTStyleSheet *self, HTStyle * style);
/* extern HTStyle * HTStyleForRun(HTStyleSheet *self, NXRun * run); */
extern HTStyleSheet * HTStyleSheetAddStyle(HTStyleSheet * self,
	HTStyle * style);
extern HTStyleSheet * HTStyleSheetRemoveStyle(HTStyleSheet * self,
	HTStyle * style);
extern HTStyleSheet * HTStyleSheetRead(HTStyleSheet * self,
						HTStream * stream);
extern HTStyleSheet * HTStyleSheetWrite(HTStyleSheet * self,
						HTStream * stream);

#define CLEAR_POINTER ((void *)-1)	/* Pointer value means "clear me" */
#endif /* HTSTYLE_H */
