/*
 *	Copyright 1994 Matti Aarnio, all rights reserved.
 *	This module is a part of Zmailer, and subject to its
 *	distribution rules.
 */


#include <stdio.h>
#include <sys/types.h>
#include "hostenv.h"

#if	defined(__linux__) || defined(__svr4__) || defined(_SYSTYPE_BSD)
/* ================================================================ */

#include <unistd.h>
#include <sys/time.h>
#include <sys/resource.h>

int
resources_query_nofiles()
{
#ifdef	RLIMIT_NOFILE
	struct rlimit rl;
	int rc;

	rc = getrlimit(RLIMIT_NOFILE,&rl);
	if (rc == 0 && rl.rlim_cur > 10)
	    return rl.rlim_cur;
	else
	  return getdtablesize();
#else
	(int) sysconf(_SC_OPEN_MAX);
#endif
}

void
resources_maximize_nofiles()
{
#ifdef	RLIMIT_NOFILE		/* Linuxes pre 1.2 (1.3?) don't have this..*/
	struct rlimit rl;
	int rc;

	rc = getrlimit(RLIMIT_NOFILE,&rl);
	if (rc != 0) return;
	rl.rlim_cur = rl.rlim_max;
	setrlimit(RLIMIT_NOFILE,&rl);
#endif
}

void
resources_limit_nofiles(nfiles)
int nfiles;
{
#ifdef	RLIMIT_NOFILE
	struct rlimit rl;
	int rc;

	rc = getrlimit(RLIMIT_NOFILE,&rl);
	if (rc != 0) return;
	rl.rlim_cur = nfiles;
	setrlimit(RLIMIT_NOFILE,&rl);
#endif
}

int
resources_query_pipesize(fildes)
int fildes;
{
	return (int) fpathconf(fildes, _PC_PIPE_BUF);
}

#else /* Not POSIX, not __linux__, nor __svr4__ */
#if	defined(BSD) || defined(sun)
/* ================================================================ */

#include <unistd.h>
#include <sys/time.h>
#include <sys/resource.h>

int
resources_query_nofiles()
{
	struct rlimit rl;
	int rc;

	rc = getrlimit(RLIMIT_NOFILE,&rl);
	if (rc != 0) return getdtablesize();

	return rl.rlim_cur;
}

void
resources_maximize_nofiles()
{
	struct rlimit rl;
	int rc;

	rc = getrlimit(RLIMIT_NOFILE,&rl);
	if (rc != 0) return;
	rl.rlim_cur = rl.rlim_max;
	setrlimit(RLIMIT_NOFILE,&rl);
}

void
resources_limit_nofiles(nfiles)
int nfiles;
{
	struct rlimit rl;
	int rc;

	rc = getrlimit(RLIMIT_NOFILE,&rl);
	if (rc != 0) return;
	rl.rlim_cur = nfiles;
	setrlimit(RLIMIT_NOFILE,&rl);
}

int
resources_query_pipesize(fildes)
int fildes;
{
	return 4096;	/* pipe buffer size (max contents before blocking) */
}

#else	/* No POSIX stuff, no BSD, ??? */
#if	!defined(__linux__) && (defined(_POSIX_SOURCE))
/* ================================================================ */

#include <unistd.h>
int
resources_query_nofiles()
{
	(int) sysconf(_SC_OPEN_MAX);
}

void
resources_maximize_nofiles()
{
}

void
resources_limit_nofiles(nfiles)
int nfiles;
{
}

int
resources_query_pipesize(fildes)
int fildes;
{
	return (int) fpathconf(fildes, _PC_PIPE_BUF);
}

#else
/* ================================================================ */

int
resources_query_nofiles()
{
	return getdtablesize();
}

void
resources_maximize_nofiles()
{
}

void
resources_limit_nofiles(nfiles)
int nfiles;
{
}

int
resources_query_pipesize(fildes)
int fildes;
{
	return 4096;	/* pipe buffer size (max contents before blocking) */
}
#endif
#endif
#endif
