/* Copyright 1993 - Matti Aarnio, Turku University, Turku, Finland
   This will be free software, but only when it is finished.

   The way the Zmailer uses DBM entries is by using strings with
   their terminating NULL as keys, and as data..  Thus the length
   is strlen(string)+1, not strlen(string) !
*/

#include <stdio.h>
#include <ctype.h>
#include <sys/types.h>
#include <fcntl.h>
#include <ndbm.h>

extern int errno;
extern char *sys_errlist[];
extern int sys_nerr;

extern void create_dbase();

void
usage(prog,err,errno)
char *prog, *err;
int errno;
{
  fprintf(stderr,"Usage: %s database.name key\n",prog);
  fprintf(stderr,"  (ndbm appends  .pag, and .dir  into actual db file names..)\n");
  fprintf(stderr," Error now: %s",err);
  if (errno > 0 && errno < sys_nerr)
    fprintf(stderr,", errno=%d (%s)",errno,sys_errlist[errno]);
  fprintf(stderr,"\n");
  exit (1);
}

int
main(argc,argv)
int argc;
char *argv[];
{
  char *dbasename = NULL;
  FILE *infile = NULL;
  DBM *dbmfile;
  datum key;
  datum result;

  if (argc != 3) usage(argv[0],"wrong number of arguments",0);
  dbasename = argv[1];
  dbmfile = dbm_open(dbasename, O_RDONLY, 0644);
  if (dbmfile == NULL)
    usage(argv[0],"Can't open dbase file",errno);

  key.dptr = argv[2];
  key.dsize = strlen(argv[2]) +1;

  result = dbm_fetch(dbmfile,key);
  if (result.dptr == NULL) {
    fprintf(stderr,"Key %s not found\n",argv[2]);
    return 2;
  }
  printf("siz:%d, dat: %s\n",result.dsize,result.dptr);

  dbm_close(dbmfile);

  return 0;
}
