/*  This file should be edited with 4-column tabs! */
/*  Author: Mark Moraes <moraes@csri.toronto.edu> */

/*LINTLIBRARY*/

#include "defs.h"
#include "globals.h"
#include "trace.h"

RCSID("$Header: /j/moraes/shmem/malloc/malloc/RCS/_malloc.c,v 1.7 89/10/31 02:01:16 moraes Exp $");

univptr_t
__malloc(nbytes, fname, linenum)
size_t nbytes;
const char *fname;
int linenum;
{
	univptr_t cp;
	
	PRTRACE(sprintf(_malloc_statsbuf, "%s:%d:", fname, linenum));
	cp = malloc(nbytes);
	RECORD_FILE_AND_LINE(cp, fname, linenum);
	return(cp);
}
