/* -*- C -*-
 *
 * Program:	ximap
 * File         imapfncs.c -- Functions required to be present by the 
 *                            IMAP c-Client. See C-Client documentation 
 *                            for full descriptions of these functions.
 *
 * Author:	Kevin Brock
 *	        Symbolic Systems Resources Group
 *		Stanford University
 *              MSOB x241
 *		Stanford, CA 94305
 *		Internet: brock@CAMIS.Stanford.Edu
 *
 * Date:	07 September 1992
 *
 * Copyright 1992 by The Leland Stanford Junior University.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notices appear in all copies and that both the
 * above copyright notices and this permission notice appear in supporting
 * documentation, and that the name of The Leland Stanford Junior University 
 * not be used in advertising or publicity pertaining to distribution of the 
 * software without specific, written prior permission.  This software is made 
 * available "as is", and
 * THE LELAND STANFORD JUNIOR UNIVERSITY DISCLAIMS ALL WARRANTIES, EXPRESS OR 
 * IMPLIED, WITH REGARD TO THIS SOFTWARE, INCLUDING WITHOUT LIMITATION ALL IMPLIED 
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, AND IN NO EVENT 
 * SHALL THE LELAND STANFORD JUNIOR UNIVERSITY BE LIABLE FOR ANY SPECIAL, INDIRECT 
 * OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, 
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, TORT (INCLUDING NEGLIGENCE) 
 * OR STRICT LIABILITY, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE 
 * OF THIS SOFTWARE.
 *
 */
#include <netdb.h>
#include <signal.h>
#include <ctype.h>

#include <stdio.h>
#include <memory.h>
#include <string.h>

#include <Client/osdep.h>
#include <Client/mail.h>
#include <Client/misc.h>
 
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>

#include <X11/Shell.h>

#include <Xb/Browser.h>

#include "structures.h"

#include "message.h"
#include "globals.h"
#include "buttons.h"
#include "resources.h"
#include "util.h"
#include "browserutil.h"
#include "textutil.h"
#include "mailbox.h"
#include "ximap.h"

extern char* ctime();

extern Widget telemetry;
extern int    updateMailbox;

/* Message matches a search
 * Accepts: IMAP2 stream
 *	    message number
 */
void mm_searched (stream, msgno)
     MAILSTREAM *stream;
     int msgno;
{
    MailBox* ms = getStatus(stream);
    
    ms->found[ms->num_found] = msgno;
    ms->num_found++;
}


/* Message exists (i.e. there are that many messages in the mailbox)
 * Accepts: IMAP2 stream
 *	    message number
 */
void mm_exists (stream, number)
     MAILSTREAM *stream;
     int number;
{
    char temp[TMPLEN];
    char name[TMPLEN];
    int delta;
    unsigned int status;

    MailBox* ms = getStatus( stream );

     /*
      * clear CHECKMAILBOX bit from status because,
      * this function is called when a check occurs which sets the bit */
     status = ms->status ^ (CHECKMAILBOX+TIMEDCHECK); 
     /*
      * If any NO check critical activity is happening, then we ignore
      * the unsolicited exists */
     if (!ISINACTIVE(status))
       return;
 
 
    memset( name, 0, TMPLEN);
    strcpy( name, ms->mailboxName );
    
    delta = number - ms->nmsgs;

    if (delta < 0)
    {
      strcpy(name,ms->mailboxName);
      sprintf (temp,"%s: File shrunk from %d to %d!!",
	       name, ms->nmsgs, number);
      mm_log(temp, NIL);
      ms->nmsgs = number;		
    }
    else 
    {
	if(ms->status & CHECKMAILBOX)
	    ms->nmsgs = number;	

	ms->changedSize = 1;
	updateMailbox   = 1;
    }
}


/* Message expunged
 * Accepts: IMAP2 stream
 *	    message number
 */

void mm_expunged (stream, number)
     MAILSTREAM *stream;
     int number;
{
    MessageNode* *mtemp = NULL;
    MessageNode*  old = NULL;
    MailBox* ms = getStatus( stream );
    
    if( ms->messages)
    {
	removeFromBrowserEntries( ms, number-1 );
	mtemp = ms->messages + number - 1;
	old = *mtemp;
	*mtemp = NULL;
	if (old->elt)
	{
	    ms->actual_size--;
	    old->elt = NULL;
	}
	
	ms->virtual_size--;
	free_node(old);
	while (mtemp < ms->last_message)
	{
	    *mtemp = *(mtemp + 1);
	    if (*mtemp)
	    {
		--(*mtemp)->msgno;
		(*mtemp)->changed = 1;
	    }
	    mtemp++;
	}
	ms->last_message = mtemp - 1;
	*mtemp = NULL;
	ms->num_expunged++;
	ms->nmsgs--;
	if (ms->zoom)
	  ms->nzoomed--;		/* Bill Yeager - 30-Nov-92 */
    }
}

/* Notification event
 * Accepts: IMAP2 stream
 *	    string to log
 *	    error flag
 */
void mm_mailbox( str )
     char *str;
{


}

void mm_bboard( str )
     char *str;
{


}


/* Notification event
 * Accepts: IMAP2 stream
 *	    string to log
 *	    error flag
 */
void mm_notify (stream, string, errflg)
     MAILSTREAM *stream;
     char *string;
     short errflg;
{
  char temp[TMPLEN];

  strcpy(temp, "NOTIFY:");
  strcat(temp, string);
  mm_log(temp,errflg);	/* just do usrlog action */
}

/* Log an event for the user to see
 * Accepts: string to log
 *	    error flag
 */
void mm_log (string, errflg)
     char *string;
     short errflg;
{
    long clk;

    char *long_now;

    char temp[TMPLEN];

    /* Hack to remove Check Timeout messages:
     *    This message is returned from the bowels of the c-client*/
    if (strcmp(string, CHECKMSG) == 0)
      return;				/* Pas du tout!! */

    clk = time(0);
    long_now = ctime(&clk);

    strncpy(temp, long_now + 11, 8);
    temp[8] = ' ';
    temp[9] = '\0';

    switch (errflg) 
    {  
      case NIL:			/* no error */
	sprintf (temp+9,"%s\n",string);
	XbTextAppend(telemetry, temp);
	break;
      case WARN:			/* warning */
	sprintf (temp+9,"?%s\n",string);
	XbTextAppend(telemetry, temp);
	break;
      case ERROR:			/* error */
      default:
	sprintf (temp+9,"!!%s\n",string);
	XbTextAppend(telemetry, temp);
	break;
    }
}


/* Log an event to debugging telemetry
 * Accepts: string to log
 */
void mm_dlog (string)
     char *string;
{
    char temp[TMPLEN];
    
    sprintf (temp,">> %s\n",string);
    XbTextAppend(telemetry, temp);
}


/* Get user name and password for this host
 * Accepts: host name
 *	    where to return user name
 *	    where to return password
 *	    trial count -- starts with trial 0
 */
void mm_login (host, username, password, trial)
     char *host;
     char *username;
     char *password;
     short trial;
{
    int getpwdt();

    static Boolean short_circuit;
 
    /* if first trial... */
    if (trial == 0)
	short_circuit = FALSE;

    if (short_circuit == FALSE)
    {
	if (!getpwdt(host, trial, username, password ))
	{
	    /* this is only set if user exited 
	       the login widget with "cancel" rather 
	       than "done"
	    */
	    short_circuit = TRUE;
	}
    }
}

void mm_critical( stream )
     MAILSTREAM *stream;
{
    /* Called when we're in a state which must not be interrupted... */

}

void mm_fatal( stream )
     MAILSTREAM *stream;
{
    /* AArgghhh!! */

}


void mm_nocritical( stream )
     MAILSTREAM *stream;
{
    /* Called when we're out of a critical ? */

}

long mm_diskerror( stream, errcode, serious )
     MAILSTREAM *stream;
     int         errcode;
     int         serious;
{
    return(0);
}

