/* -*- C -*-
 *
 * Program:	ximap
 * File:        globals.h -- definitions used by a number of different files
 *                           in ximap.
 *
 * Author:	Kevin Brock
 *	        Symbolic Systems Resources Group
 *		Stanford University
 *              MSOB x241
 *		Stanford, CA 94305
 *		Internet: brock@CAMIS.Stanford.Edu
 *
 * Date:	07 September 1992
 *
 * Copyright 1992 by The Leland Stanford Junior University.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notices appear in all copies and that both the
 * above copyright notices and this permission notice appear in supporting
 * documentation, and that the name of The Leland Stanford Junior University 
 * not be used in advertising or publicity pertaining to distribution of the 
 * software without specific, written prior permission.  This software is made 
 * available "as is", and
 * THE LELAND STANFORD JUNIOR UNIVERSITY DISCLAIMS ALL WARRANTIES, EXPRESS OR 
 * IMPLIED, WITH REGARD TO THIS SOFTWARE, INCLUDING WITHOUT LIMITATION ALL IMPLIED 
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, AND IN NO EVENT 
 * SHALL THE LELAND STANFORD JUNIOR UNIVERSITY BE LIABLE FOR ANY SPECIAL, INDIRECT 
 * OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, 
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, TORT (INCLUDING NEGLIGENCE) 
 * OR STRICT LIABILITY, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE 
 * OF THIS SOFTWARE.
 *
 */
#ifndef __ximap_globals_h
#define __ximap_globals_h

#define TOP            1
#define BOTTOM         2

#define BAD_MESSAGE    -1
#define BAD_POSITION   -1

#define FIRST_MESSAGE   0

#define theKeyBufferMaxLen 256

#ifndef NIL
#define NIL 0
#endif

#define TMPLEN 8192

#define MNUMBER "    "
#define FLAGS "    "
#define DATE "      "
#define FROM    "                         "
#define SUBJECT "                                 "
#define MNLENGTH sizeof (MNUMBER)
#define FLAGSLEN sizeof (FLAGS)
#define DATELEN sizeof (DATE)
#define FROMLEN sizeof (FROM)
#define SUBJECTLEN sizeof (SUBJECT)
#define RSUBJECTLEN (2 * SUBJECTLEN) /* allow longer line in read window */

#define FWDHDR         "\n\n--------- Begin Forwarded Message ------------\n\n"
#define FWDMULTIPLEFRM   "\n----------Forwarded Message #%d---------------\n\n"
#define GENERICDIVIDER   "\n----------------------------------------------\n"

#define MAXLINELENGTH 80
#define MINWRAPCOLS   32  /* min value for insert_wrap_columns  */
#define LINEBREAKING 1

#define ARGLISTSIZE 16

#define CHECKMSG "Check completed" /* We filter this c-client message out */

#define DELETED_FLAG         "\\Deleted"
#define SEEN_FLAG            "\\Seen"
#define RECENT_FLAG          "\\Recent"
#define FLAGGED_FLAG         "\\Flagged"
#define ANSWERED_FLAG        "\\Answered"

/***********************************************************

  Miscellaneaou string stuff 


***********************************************************/

#define LFCHAR     '\012'
#define CRCHAR     '\015'
#define SPACECHAR  ' '
#define TAB        '\t'

#define SKIPSPACE(txt) {while(*(txt)==SPACECHAR     \
			      ||*(txt)==TAB)        \
				  ++txt;}

#define NOTDELIMITER(txt) ((*txt)            \
			   && (*txt) != ','  \
			   && (*txt) != '>')

#define ENDOFSTRING '\0'

#define mstrlen(s)      ((s)?(strlen(s)):0)


/***********************************************************

  Global status flags

  an int or a short would be large enough to contain 
  the current set of values, but they'll probably expand.

***********************************************************/

#define DEAD           ((unsigned long) 0)

#define DEBUGGING      ((unsigned long) 1)
#define LOGGINGIN      ((unsigned long) (1 << 1))
#define EXPUNGING      ((unsigned long) (1 << 2))
#define SEARCHING      ((unsigned long) (1 << 3))

#define REPLYSENDER    ((unsigned long) (1 << 4))
#define REPLYALL       ((unsigned long) (1 << 5))
#define FORWARDMSG     ((unsigned long) (1 << 6))
#define REMAILMSG      ((unsigned long) (1 << 7))

#define TIMEDCHECK     ((unsigned long) (1 << 8))
#define BACKGROUND     ((unsigned long) (1 << 9))
#define DEADNODE       ((unsigned long) (1 << 10))
#define CHECKMAILBOX   ((unsigned long) (1 << 11))

#define SEARCHBROWSE   ((unsigned long) (1 << 12))
#define SEARCHSELECT   ((unsigned long) (1 << 13))
#define SEARCHFILTER   ((unsigned long) (1 << 14))
#define SEARCHALL      ((unsigned long) (1 << 15))

#define UNSOLICITEDCHECK    ((unsigned long) (1 << 16))

#define TEXTREADONLY   ((unsigned long) (1 << 17))

#define ANSWERING     (REPLYSENDER | REPLYALL)

#define INRESPONSE    (REPLYSENDER | REPLYALL | FORWARDMSG | REMAILMSG)

#define NOTFORWARDING (REPLYSENDER | REPLYALL | REMAILMSG)
#define NOTREMAILING  (REPLYSENDER | REPLYALL | FORWARDMSG)
#define NOTANSWERING  (FORWARDMSG  | REMAILMSG)

#define ISINACTIVE(s) (!((s)&(SEARCHING | CHECKMAILBOX | BACKGROUND | TIMEDCHECK | EXPUNGING)))

#define DONTBACKGROUND (CHECKMAILBOX | TIMEDCHECK | EXPUNGING)

#endif /* __ximap_globals_h */










