/* -*- C -*-
 *
 * Program:	ximap
 * File:        browserutil.h: Declarations of structures & functions in browserutil.c
 *
 * Author:	Kevin Brock
 *	        Symbolic Systems Resources Group
 *		Stanford University
 *              MSOB x241
 *		Stanford, CA 94305
 *		Internet: brock@CAMIS.Stanford.Edu
 *
 * Date:	07 September 1992
 *
 * Copyright 1992 by The Leland Stanford Junior University.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notices appear in all copies and that both the
 * above copyright notices and this permission notice appear in supporting
 * documentation, and that the name of The Leland Stanford Junior University 
 * not be used in advertising or publicity pertaining to distribution of the 
 * software without specific, written prior permission.  This software is made 
 * available "as is", and
 * THE LELAND STANFORD JUNIOR UNIVERSITY DISCLAIMS ALL WARRANTIES, EXPRESS OR 
 * IMPLIED, WITH REGARD TO THIS SOFTWARE, INCLUDING WITHOUT LIMITATION ALL IMPLIED 
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, AND IN NO EVENT 
 * SHALL THE LELAND STANFORD JUNIOR UNIVERSITY BE LIABLE FOR ANY SPECIAL, INDIRECT 
 * OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, 
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, TORT (INCLUDING NEGLIGENCE) 
 * OR STRICT LIABILITY, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE 
 * OF THIS SOFTWARE.
 *
 */
#ifndef __ximap_browserutil_h
#define __ximap_browserutil_h

typedef enum 
{ 
    XMS_HLTREMOVE, 
    XMS_HLTRETAIN, 
    XMS_HLTREPLACE, 
    XMS_HLTADD 
} XmsHighlightMode;

extern Boolean BackgroundFetch();
extern void updateBrowser();
extern void changeHeaders();
extern void fetch_unfetched();
extern void updateHeaders();
extern void redoList();
extern void fetchMapping();
extern void removeItemFromBrowser();
extern void removeFromBrowserEntries();
extern void changeItemsWithHighlight();
extern void setActiveBrowser();
extern BrowserEntry* getActiveBrowser();
extern void removeFromBrowserEntries();
extern void browserQuit();
extern int* copyMapping();
extern Widget widgetToBrowser();
extern void ximap_freeBrowserEntry();
extern BrowserEntry* ximap_newBrowserEntry();
extern BrowserEntry* searchWinToBrowser();

extern NodeList* listMapToNodeList();
extern XbListSelectionPtr nodeListToListMap();
extern XbListSelectionPtr ximap_newlistmap();

#endif /* __ximap_browserutil_h */
