/***********************************************************
*
*
*  Author(s):       Kevin J. Brock
*                   Symbolic Systems Resources Group
*		    Knowledge Systems Laboratory
*		    Departments of Computer Science and Medicine
*		    Stanford University
*		    Stanford, CA 94305
*                   brock@sumex-aim.stanford.edu
*
*  Copyright () 1991 by the Leland Stanford Junior University
*  
*  "This program may be distributed without restriction for non-commercial
*  use. Any sale or use of this program or adaptations thereof for commercial
*  purposes is prohibited except under license from the Stanford Office of
*  Technology Licensing."
*
***********************************************************/
#ifndef _SmeCasc_h
#define _SmeCasc_h

#include <X11/Xmu/Converters.h>

#include <X11/Xaw/Sme.h>
#include <X11/Xaw/SmeBSB.h>

/****************************************************************
 *
 * SmeBSB object
 *
 ****************************************************************/

/* BSB Menu Entry Resources:

 Name		     Class		RepType		Default Value
 ----		     -----		-------		-------------
 callback            Callback           Callback        NULL
 destroyCallback     Callback		Pointer		NULL
 font                Font               XFontStruct *   XtDefaultFont
 foreground          Foreground         Pixel           XtDefaultForeground
 height		     Height		Dimension	0
 label               Label              String          Name of entry
 leftBitmap          LeftBitmap         Pixmap          None
 leftMargin          HorizontalMargins  Dimension       4
 rightBitmap         RightBitmap        Pixmap          None
 rightMargin         HorizontalMargins  Dimension       4
 sensitive	     Sensitive		Boolean		True
 vertSpace           VertSpace          int             25
 width		     Width		Dimension	0
 x		     Position		Position	0n
 y		     Position		Position	0

*/

/* Casc Menu Entry Resources
   
 menuName            menuName           String          "cascade_menu"
 menu                Menu               Widget          NULL

*/

#define XtNmenu     "menu"
#define XtCMenu     "Menu"

#define XtNmenuName "menuName"
#define XtCMenuName "MenuName"


typedef struct _SmeCascClassRec    *SmeCascObjectClass;
typedef struct _SmeCascRec         *SmeCascObject;

extern WidgetClass smeCascObjectClass;

#endif /* _SmeCasc_h */
