
/*
 * Copyright 1989 Massachusetts Institute of Technology
 * Copyright 1991 Leland Stanford Junior University
 *
 * Permission to use, copy, modify, distribute, and sell this software and its
 * documentation for any purpose is hereby granted without fee, provided that
 * the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of M.I.T. not be used in advertising or
 * publicity pertaining to distribution of the software without specific,
 * written prior permission.  M.I.T. makes no representations about the
 * suitability of this software for any purpose.  It is provided "as is"
 * without express or implied warranty.
 *
 * M.I.T. DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL M.I.T.
 * BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION
 * OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN 
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 */

/*
 * List.c - List widget
 *
 * This is the List widget, it is useful to display a list, without the
 * overhead of having a widget for each item in the list.  It allows 
 * the user to select an item in a list and notifies the application through
 * a callback function.
 *
 *	Original Created: 	8/13/88
 *	       By:		Chris D. Peterson
 *                              MIT X Consortium
 *
 *      Rewritten  by:  Kevin Brock
 *                      Symbolic Systems Resources Group
 *		        Knowledge Systems Laboratory
 *		        Departments of Computer Science and Medicine
 *		        Stanford University
 *		        Stanford, CA 94305
 *
 *        THIS WIDGET IS *NOT* COMPATIBLE WITH THE CURRENT Xaw List Widget.
 *        PROGRAMS DESIGNED TO USE THE ORIGINAL WIDGET MUST BE MODIFIED IN
 *        A NUMBER OF WAYS BEFORE THEY CAN USE THIS WIDGET.
 *
 */

#ifndef _XbList_h
#define _XbList_h

/***********************************************************************
 *
 * List Widget
 *
 ***********************************************************************/

#include <X11/Xaw/Simple.h>


/* Resources:

 Name		     Class		RepType		Default Value
 ----		     -----		-------		-------------
 background	     Background		Pixel		XtDefaultBackground
 border		     BorderColor	Pixel		XtDefaultForeground
 borderWidth	     BorderWidth	Dimension	1
 callback            Callback           XtCallbackList  NULL       **6
 columnSpacing       Spacing            Dimension       6
 cursor		     Cursor		Cursor		left_ptr
 defaultColumns      Columns            int             2          **5
 destroyCallback     Callback		Pointer		NULL 
 font		     Font		XFontStruct*	XtDefaultFont
 forceColumns        Columns            Boolean         False      **5
 foreground	     Foreground		Pixel		XtDefaultForeground
 height		     Height		Dimension	0          **1
 insensitiveBorder   Insensitive	Pixmap		Gray
 internalHeight	     Height		Dimension	2
 internalWidth	     Width		Dimension	4
 list                List               String *        NULL       **2
 longest             Longest            int             0          **3  **4
 mappedWhenManaged   MappedWhenManaged	Boolean		True
 numberStrings       NumberStrings      int             0          **4
 pasteBuffer         Boolean            Boolean         False
 rowSpacing          Spacing            Dimension       4
 sensitive	     Sensitive		Boolean		True
 verticalList        Boolean            Boolean         False
 width		     Width		Dimension	0          **1
 x		     Position		Position	0
 y		     Position		Position	0

 **1 - If the Width or Height of the list widget is zero (0) then the value
       is set to the minimum size necessay to fit the entire list.

       If both Width and Height are zero then they are adjusted to fit the
       entire list that is created width the number of default columns 
       specified in the defaultColumns resource.

 **2 - This is an array of strings the specify elements of the list.
       This resource must be specified. 
       (What good is a list widget without a list??  :-)

 **3 - Longest is the length of the widest string in pixels.

 **4 - If either of these values are zero (0) then the list widget calculates
       the correct value. 

       (This allows you to make startup faster if you already have 
        this information calculated)

       NOTE: If the numberStrings value is zero the list must 
             be NULL terminated.

 **5 - By setting the List.Columns resource you can force the application to
       have a given number of columns.	     
        
 **6 - This returns the name and index of the item(s) selected in an 
       XbListReturnStruct that is pointed to by the client_data
       in the CallbackProc.

*/

/*
 * Value returned when there are no highlighted objects. 
 */

#define XB_LIST_NONE -1	

#define XB_NONE 0
#define XB_POSITIVE 1
#define XB_NEGATIVE -1

#define XtCRowHeight "RowHeight"
#define XtCList "List"
#define XtCSpacing "Spacing"
#define XtCColumns "Columns"
#define XtCLongest "Longest"
#define XtCNumberStrings "NumberStrings"
#define XtCNumSelected "NumSelected"
#define XtCSelectedElements "SelectedElements"
#define XtCDoubleClick "DoubleClick"
#define XtCClickDelay "ClickDelay"
#define XtCNormalFont "NormalFont"
#define XtCEmphaticFont "EmphaticFont"

#define XtNrowHeight "rowHeight"
#define XtNcursor "cursor"
#define XtNcolumnSpacing "columnSpacing"
#define XtNdefaultColumns "defaultColumns"
#define XtNforceColumns "forceColumns"
#define XtNlist "list"
#define XtNlongest "longest"
#define XtNnumberStrings "numberStrings"
#define XtNpasteBuffer "pasteBuffer"
#define XtNrowSpacing "rowSpacing"
#define XtNverticalList "verticalList"
#define XtNnumSelected "numSelected"
#define XtNselectedElements "selectedElements"
#define XtNdoubleClick "doubleClick"
#define XtNclickDelay "clickDelay"
#define XtNnormalFont "normalFont"
#define XtNemphaticFont "emphaticFont"
 
/* Class record constants */

extern WidgetClass XblistWidgetClass;

typedef struct _XbListClassRec *XbListWidgetClass;
typedef struct _XbListRec      *XbListWidget;

/* The list return structure. */

typedef struct _XbListEntry
{
    int    index;
    char  *entry;
    short  bold;
    short  invert;
} XbListEntry, *XbListEntryPtr;

typedef struct _XbListSelection
{
    XbListEntryPtr    entries;
    int               size;
} XbListSelection, *XbListSelectionPtr;

#ifdef XAW_BC
/*************************************************************
 * For Compatibility only.                                   */

#define XtListReturnStruct   XbListSelection

#define XT_LIST_NONE         XB_LIST_NONE 

#define XtListChange         XbListChange
#define XtListUnhighlight    XbListUnhighlight
#define XtListHighlight      XbListHighlight
#define XtListShowCurrent    XbListShowCurrent

/*************************************************************/
#endif /* XAW_BC */

/******************************************************************
 *
 * Exported Functions
 *
 *****************************************************************/

/*	Function Name: XbListChange.
 *	Description: Changes the list being used and shown.
 *	Arguments: w - the list widget.
 *                 list - the new list.
 *                 nitems - the number of items in the list.
 *                 longest - the length (in Pixels) of the longest element
 *                           in the list.
 *                 resize - if TRUE the the list widget will
 *                          try to resize itself.
 *	Returns: none.
 *      NOTE:      If nitems of longest are <= 0 then they will be caluculated.
 *                 If nitems is <= 0 then the list needs to be NULL terminated.
 */

extern void XbListChange(); /* w, list, nitems, longest, resize */

/*	Function Name: XbListUnhighlight
 *	Description: unlights the current highlighted element.
 *	Arguments: w - the widget.
 *	Returns: none.
 */

extern void XbListUnhighlight(); /* w */

/*	Function Name: XbListHighlight
 *	Description: Highlights the given item.
 *	Arguments: w - the list widget.
 *                 items - the items to hightlight ( an XbListSelection* )
 *	Returns: none.
 */

extern void XbListHighlight(); /* w, item */


/*	Function Name: XbListShowCurrent
 *	Description: returns the currently highlighted object.
 *	Arguments: w - the list widget.
 *	Returns: the info about the currently highlighted object.
 */

extern XbListSelectionPtr XbListShowCurrent(); /* w */

/* Brock 11-1-90 */
/*      Function Name: XbListGetItem
 *      Description: Retrieves a usable copy of the indicated string
 *	Arguments: w - the list widget.
 *                 no - the index of the string to be retrieved ( starting with
 *                      0 ).
 *
 *	Returns: pointer to the string.
 */

extern XbListEntryPtr XbListGetItem(); 


/* Brock 11-1-90 */
/*      Function Name: XbListReplaceString
 *      Description: replaces the indicated string, returning the one currently 
 *            in place.
 *	Arguments: w - the list widget.
 *                 string - the string to insert.
 *                 no - the index of the string to be replaced ( starting
 *                      0 ).
 *                 size - length of string
 *                 resize_it - whether widget should attempt resize if nec.
 *
 *	Returns: old string.
 */

extern char* XbListReplaceString(); 


/*
 *  Frees the memory allocated for all of the stuff in the 
 *  current selection.
 *
 */

extern void XbListFreeSelection(/* XbListSelectionPtr */);
extern void XbListCopyEntry(/* XbListEntry*,XbListEntry* */);
extern XbListSelectionPtr XbListCopySelection(/* XbListSelectionPtr */);
void XbClearSelectItem(/* Widget, int */);

#endif /* _XbList_h */
/* DON'T ADD STUFF AFTER THIS #endif */




