/***********************************************************
*
*  %W% %G%
*
*  BSBMnBt Widget ( Bitmap-String-Bitmap Menu Button )
*
*  Author(s):       Kevin J. Brock
*                   Symbolic Systems Resources Group
*		    Knowledge Systems Laboratory
*		    Departments of Computer Science and Medicine
*		    Stanford University
*		    Stanford, CA 94305
*
*  Date:            28 March, 1991
*
*  Copyright () 1991 by the Leland Stanford Junior University
*  
*  "This program may be distributed without restriction for non-commercial
*  use. Any sale or use of this program or adaptations thereof for commercial
*  purposes is prohibited except under license from the Stanford Office of
*  Technology Licensing."
*
***********************************************************/
/***********************************************************************
 *
 * BSBMnBtn Widget
 *
 ***********************************************************************/

/*
 * BSBMnBtn.c - Source code for BSBMnBtn widget.
 *
 */
#define XtStrlen(s)		((s) ? strlen(s) : 0)

#include <stdio.h>
#include <string.h>
#include <ctype.h>

#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>

#include <X11/Xaw/XawInit.h>

#include "BSBMnBtP.h"

#define streq(a,b) (strcmp( (a), (b) ) == 0)

#define MULTI_LINE_LABEL 32767

#define superclass ((MenuButtonWidgetClass)&menuButtonClassRec)

static char defaultTranslations[] = 
    "<EnterWindow>:     highlight()             \n\
     <LeaveWindow>:     reset()                 \n\
     <BtnDown>:         reset() PopupMenu()     ";

/****************************************************************
 *
 * Full class record constant
 *
 ****************************************************************/

/* Private Data */

#define offset(field) XtOffset(BSBMnBtWidget, field)
static XtResource resources[] = {
{XtNmenuName, XtCMenuName, XtRString, sizeof(String), 
     offset(menu_button.menu_name), XtRString, (caddr_t)"menu"},
{XtNrightBitmap, XtCPixmap, XtRBitmap, sizeof(Pixmap),
     offset(bsbMnBt.rtBitmap), XtRImmediate, (caddr_t)0},
{XtNleftBitmap, XtCPixmap, XtRBitmap, sizeof(Pixmap),
     offset(bsbMnBt.lfBitmap), XtRImmediate, (caddr_t)0}
};
#undef offset

static void Initialize();
static void Redisplay();
static Boolean SetValues();
static XtGeometryResult QueryGeometry();

static void GetnormalGC();
static void GetgrayGC();

#ifdef sun
extern char* index();
#endif

BSBMnBtClassRec bsbMnBtClassRec = {
{
    /* CoreClass fields initialization */
    (WidgetClass) superclass,		/* superclass		  */	
    "BSBMnBt",			        /* class_name		  */
    sizeof(BSBMnBtRec),          	/* size			  */
    NULL,               		/* class_initialize	  */
    NULL,				/* class_part_initialize  */
    FALSE,				/* class_inited		  */
    Initialize,				/* initialize		  */
    NULL,				/* initialize_hook	  */
    XtInheritRealize,  			/* realize		  */
    NULL,  			        /* actions		  */
    0,		                        /* num_actions		  */
    resources,				/* resources		  */
    XtNumber(resources),		/* resource_count	  */
    NULLQUARK,				/* xrm_class		  */
    FALSE,				/* compress_motion	  */
    TRUE,				/* compress_exposure	  */
    TRUE,				/* compress_enterleave    */
    FALSE,				/* visible_interest	  */
    NULL,				/* destroy		  */
    XtInheritResize,	        	/* resize		  */
    Redisplay,   			/* expose		  */
    SetValues,				/* set_values		  */
    NULL,				/* set_values_hook	  */
    XtInheritSetValuesAlmost,		/* set_values_almost	  */
    NULL,				/* get_values_hook	  */
    NULL,				/* accept_focus		  */
    XtVersion,				/* version		  */
    NULL,				/* callback_private	  */
    defaultTranslations,               	/* tm_table		  */
    QueryGeometry,		        /* query_geometry	  */
    XtInheritDisplayAccelerator,	/* display_accelerator	  */
    NULL				/* extension		  */
    },{  
	/* SimpleClass fields initialization */
	XtInheritChangeSensitive		/* change_sensitive	  */ 
    },{
	/* LabelClass fields initialization */
	0,                                     /* field not used    */
    },{
	/* CommandClass fields initialization */
	0,                                     /* field not used    */
    },{
	/* MenuButtonClass fields initialization */
	0,                                     /* field not used    */
    },{
	/* BSBMnBtClass fields initialization */
	0,                        /* empty */
    }
};


WidgetClass bsbMnBtWidgetClass = (WidgetClass) &bsbMnBtClassRec;

/*
 *
 * Calculate width and height of displayed text and bitmaps in pixels
 *
 *
 */
static void SetTextWidthAndHeight(bsbw)
     BSBMnBtWidget bsbw;
{
    register XFontStruct *fs = bsbw->label.font;
    char *nl;
    
    Dimension lab_ht = 0;
    Dimension lab_wd = 0;
    Dimension lab_len = 0;
    
    unsigned int rb_ht = 0;
    unsigned int rb_dp = 0;
    unsigned int rb_wd = 0;
    
    unsigned int lb_ht = 0;
    unsigned int lb_dp = 0;
    unsigned int lb_wd = 0;
    
    /* If there's a right bitmap... */
    if (bsbw->bsbMnBt.rtBitmap)
    {
	Window root;
	int x, y;
	unsigned int bw;
	if (XGetGeometry(XtDisplay(bsbw), bsbw->bsbMnBt.rtBitmap, &root, 
			 &x, &y, 
			 &rb_wd, &rb_ht, &bw, &rb_dp))
	{
	    bsbw->bsbMnBt.totWidth = bsbw->bsbMnBt.rtWidth = rb_wd;
	    bsbw->bsbMnBt.totHeight = bsbw->bsbMnBt.rtHeight = rb_ht;
	    bsbw->bsbMnBt.rtDepth = rb_dp;
	}
	bsbw->bsbMnBt.numParts++;
    }

    /* If there's a left bitmap... */
    if (bsbw->bsbMnBt.lfBitmap)
    {
	Window root;
	int x, y;
	unsigned int bw;
	if (XGetGeometry(XtDisplay(bsbw), bsbw->bsbMnBt.lfBitmap, &root, 
			 &x, &y, &lb_wd, &lb_ht, &bw, &lb_dp))
	{
	    bsbw->bsbMnBt.lfWidth = lb_wd;
	    bsbw->bsbMnBt.lfHeight = lb_ht;
	    bsbw->bsbMnBt.lfDepth = lb_dp;
	}

	if ( bsbw->bsbMnBt.lfHeight > bsbw->bsbMnBt.totHeight )
	    bsbw->bsbMnBt.totHeight = bsbw->bsbMnBt.lfHeight;

	bsbw->bsbMnBt.totWidth += bsbw->bsbMnBt.lfWidth;
	bsbw->bsbMnBt.numParts++;
    }
    
    bsbw->bsbMnBt.lbHeight = lab_ht = 
	fs->max_bounds.ascent + fs->max_bounds.descent;

    if (bsbw->label.label == NULL) 
    {
	bsbw->bsbMnBt.lbLength = lab_len = 0;
	bsbw->bsbMnBt.lbWidth = lab_wd = 0;
    }
    else if ((nl = index(bsbw->label.label, '\n')) != NULL) 
    {
	char *label;

	bsbw->label.label_len = lab_len = MULTI_LINE_LABEL;
	lab_wd = 0;

	for (label = bsbw->label.label; 
	     nl != NULL; 
	     nl = index(label, '\n')) 
	{
	    int width = XTextWidth(fs, label, (int)(nl - label));
	    if (width > lab_wd) 
		lab_wd = width;
	    label = nl + 1;
	    if (*label)
		lab_ht += fs->max_bounds.ascent + fs->max_bounds.descent;
	}

	if (*label) 
	{
	    int width = XTextWidth(fs, label, strlen(label));
	    if (width > lab_wd) 
		lab_wd = width;
	}
	
	bsbw->bsbMnBt.numParts++;
	bsbw->bsbMnBt.lbHeight = lab_ht;
	bsbw->bsbMnBt.lbWidth  = lab_wd;
    } 
    else 
    {
	bsbw->bsbMnBt.lbLength = lab_len = strlen(bsbw->label.label);
	lab_wd = XTextWidth(fs, bsbw->label.label, (int) lab_len);
	bsbw->bsbMnBt.numParts++;
	bsbw->bsbMnBt.lbHeight = lab_ht;
	bsbw->bsbMnBt.lbWidth = lab_wd;
    }

    if( lab_ht > bsbw->bsbMnBt.totHeight 
       || ( rb_ht == 0 && lb_ht == 0 )
       || ( lab_ht > rb_ht && lab_ht > lb_ht ))
	bsbw->bsbMnBt.totHeight = lab_ht;

    bsbw->bsbMnBt.totWidth += bsbw->bsbMnBt.lbWidth;

    bsbw->label.label_width = bsbw->bsbMnBt.totWidth;
    bsbw->label.label_height = bsbw->bsbMnBt.totHeight;
}

/* ARGSUSED */
static void Initialize(request, new)
 Widget request, new;
{
    BSBMnBtWidget bsbw = (BSBMnBtWidget) new;

    bsbw->bsbMnBt.lfWidth = bsbw->bsbMnBt.rtWidth = bsbw->bsbMnBt.lbWidth = 0;
    bsbw->bsbMnBt.lfHeight = bsbw->bsbMnBt.rtHeight = bsbw->bsbMnBt.lbHeight = 0;
    bsbw->bsbMnBt.lfDepth = bsbw->bsbMnBt.rtDepth = bsbw->bsbMnBt.lbLength = 0;
    bsbw->bsbMnBt.totHeight = bsbw->bsbMnBt.totWidth = 0;
    bsbw->bsbMnBt.numParts = 0;

    if (bsbw->label.label == NULL
	&& bsbw->bsbMnBt.lfBitmap == NULL
	&& bsbw->bsbMnBt.rtBitmap == NULL)
    {
        bsbw->label.label = XtNewString(bsbw->core.name);
    }
    else if (bsbw->label.label)
    {
        bsbw->label.label = XtNewString(bsbw->label.label);
    }
   
    SetTextWidthAndHeight(bsbw);

    bsbw->core.width = bsbw->bsbMnBt.totWidth + 
	(bsbw->bsbMnBt.numParts+1)*bsbw->label.internal_width;

    bsbw->core.height = bsbw->bsbMnBt.totHeight + 2*bsbw->label.internal_height;

    bsbw->label.label_x = bsbw->label.label_y = 0;

    (*XtClass(new)->core_class.resize) ((Widget)bsbw);

} /* Initialize */

/*
 * Repaint the widget window
 */

/* ARGSUSED */
static void Redisplay(w, event, region)
    Widget w;
    XEvent *event;
    Region region;
{
   BSBMnBtWidget bsbw = (BSBMnBtWidget) w;
   GC gc;

   if (region != NULL &&
       XRectInRegion(region, bsbw->label.label_x, bsbw->label.label_y,
		     bsbw->bsbMnBt.totWidth, bsbw->bsbMnBt.totHeight)
	     == RectangleOut)
       return;

   gc = XtIsSensitive(bsbw) ? bsbw->label.normal_GC : bsbw->label.gray_GC;
#ifdef notdef
   if (region != NULL) XSetRegion(XtDisplay(w), gc, region);
#endif /*notdef*/

   if (bsbw->bsbMnBt.lfBitmap)
   {
       Position y;
       y = bsbw->label.label_y + ( bsbw->core.height - bsbw->bsbMnBt.lfHeight ) / 2;

       if( bsbw->bsbMnBt.lfDepth == 1 )
       {
	   XCopyPlane( XtDisplay(w), bsbw->bsbMnBt.lfBitmap, XtWindow(w), 
		      gc, 0, 0, 
		      bsbw->bsbMnBt.lfWidth, bsbw->bsbMnBt.lfHeight,
		      bsbw->label.label_x, y, 1L);
       }
       else
       {
	   XCopyArea( XtDisplay(w), bsbw->bsbMnBt.lfBitmap, XtWindow(w), 
		      gc, 0, 0, 
		      bsbw->bsbMnBt.lfWidth, bsbw->bsbMnBt.lfHeight,
		      bsbw->label.label_x, y);
       }
   }

   if (bsbw->label.label) 
   {
       int len = bsbw->bsbMnBt.lbLength;
       char *label = bsbw->label.label;
       Position y = bsbw->label.label_y + bsbw->label.font->max_bounds.ascent;
       Position x = bsbw->label.label_x;

       if (bsbw->bsbMnBt.lfBitmap)
	   x = x + bsbw->bsbMnBt.lfWidth + bsbw->label.internal_width;

       if (len == MULTI_LINE_LABEL) 
       {
	   char *nl;
	   while ((nl = index(label, '\n')) != NULL) 
	   {
	       XDrawString(XtDisplay(w), XtWindow(w), gc, 
			   x, y, label, (int)(nl - label));
	       y += bsbw->label.font->max_bounds.ascent + bsbw->label.font->max_bounds.descent;
	       label = nl + 1;
	   }
	   len = strlen(label);
       }
       if (len)
	   XDrawString(XtDisplay(w), XtWindow(w), gc, x, y, label, len);

   } 
   
   if( bsbw->bsbMnBt.rtBitmap )
   {
       Position x = bsbw->label.label_x;
       Position y;

       y = bsbw->label.label_y + ( bsbw->core.height - bsbw->bsbMnBt.rtHeight ) / 2;

       if (bsbw->bsbMnBt.lfBitmap)
	   x = x + bsbw->bsbMnBt.lfWidth + bsbw->label.internal_width;

       if (bsbw->label.label)
	   x = x + bsbw->bsbMnBt.lbWidth + bsbw->label.internal_width;

       if( bsbw->bsbMnBt.rtDepth == 1 )
       {
	   XCopyPlane( XtDisplay(w), bsbw->bsbMnBt.rtBitmap, XtWindow(w), 
		      gc, 0, 0, 
		      bsbw->bsbMnBt.rtWidth, bsbw->bsbMnBt.rtHeight,
		      x, y, 1L);
       }
       else
       {
	   XCopyArea( XtDisplay(w), bsbw->bsbMnBt.rtBitmap, XtWindow(w), 
		      gc, 0, 0, 
		      bsbw->bsbMnBt.rtWidth, bsbw->bsbMnBt.rtHeight,
		      x, y);
       }

   }

#ifdef notdef
   if (region != NULL) XSetClipMask(XtDisplay(w), gc, (Pixmap)NULL);
#endif /* notdef */
}

static void _Reposition(lw, width, height, dx, dy)
    register LabelWidget lw;
    Dimension width, height;
    Position *dx, *dy;
{
    Position newPos;
    switch (lw->label.justify) {

	case XtJustifyLeft   :
	    newPos = lw->label.internal_width;
	    break;

	case XtJustifyRight  :
	    newPos = width -
		(lw->label.label_width + lw->label.internal_width);
	    break;

	case XtJustifyCenter :
	    newPos = (width - lw->label.label_width) / 2;
	    break;
    }
    if (newPos < (Position)lw->label.internal_width)
	newPos = lw->label.internal_width;
    *dx = newPos - lw->label.label_x;
    lw->label.label_x = newPos;
    *dy = (newPos = (height - lw->label.label_height) / 2) - lw->label.label_y;
    lw->label.label_y = newPos;
    return;
}

/*
 * Set specified arguments into widget
 */

#define LEFT_PIXMAP 0
#define RIGHT_PIXMAP 1
#define WIDTH 2
#define HEIGHT 3
#define NUM_CHECKS 4

static Boolean SetValues(current, request, new, args, num_args)
    Widget current, request, new;
    ArgList args;
    Cardinal *num_args;
{
    BSBMnBtWidget curbsbw = (BSBMnBtWidget) current;
    BSBMnBtWidget reqbsbw = (BSBMnBtWidget) request;
    BSBMnBtWidget newbsbw = (BSBMnBtWidget) new;
    int i, label_changed = 0;
    Boolean was_resized = False, redisplay = False, checks[NUM_CHECKS];

    for (i = 0; i < NUM_CHECKS; i++)
	checks[i] = FALSE;

    for(i = 0; i < *num_args; i++)
	if(!strcmp(args[i].name,"label"))
	    label_changed = 1;

    for (i = 0; i < *num_args; i++) {
	if (streq(XtNleftBitmap, args[i].name))
	    checks[LEFT_PIXMAP] = TRUE;
	if (streq(XtNrightBitmap, args[i].name))
	    checks[RIGHT_PIXMAP] = TRUE;
	if (streq(XtNwidth, args[i].name))
	    checks[WIDTH] = TRUE;
	if (streq(XtNheight, args[i].name))
	    checks[HEIGHT] = TRUE;
    }

    if (newbsbw->label.label == NULL
	&& !checks[RIGHT_PIXMAP]
	&& !checks[LEFT_PIXMAP]) 
    {
	newbsbw->label.label = newbsbw->core.name;
    }

    
    if (label_changed || strcmp(curbsbw->label.label,newbsbw->label.label)) 
    {
        if (curbsbw->label.label != curbsbw->core.name)
	    XtFree( (char *)curbsbw->label.label );

	if (newbsbw->label.label != newbsbw->core.name) 
	    newbsbw->label.label = XtNewString( newbsbw->label.label );

	was_resized = True;
    }

    if (was_resized 
	|| (curbsbw->label.font != newbsbw->label.font) 
	|| (curbsbw->label.justify != newbsbw->label.justify) 
	|| checks[LEFT_PIXMAP] || checks[RIGHT_PIXMAP]) 
    {

	SetTextWidthAndHeight(newbsbw);
	was_resized = True;
    }

    /* recalculate the window size if something has changed. */
    if (newbsbw->label.resize && was_resized) 
    {
	if ((curbsbw->core.width == reqbsbw->core.width) && !checks[WIDTH])
	    newbsbw->core.width = (newbsbw->bsbMnBt.totWidth +
				   (newbsbw->bsbMnBt.numParts+1)*newbsbw->label.internal_width);

	if ((curbsbw->core.height == reqbsbw->core.height) && !checks[HEIGHT])
	    newbsbw->core.height = (newbsbw->bsbMnBt.totHeight + 
				  2 * newbsbw->label.internal_height);
    }

    if (curbsbw->label.foreground != newbsbw->label.foreground
	|| curbsbw->label.font->fid != newbsbw->label.font->fid) {

	XtReleaseGC(new, curbsbw->label.normal_GC);
	XtReleaseGC(new, curbsbw->label.gray_GC);
	XmuReleaseStippledPixmap( XtScreen(current), curbsbw->label.stipple );
	GetnormalGC((LabelWidget)newbsbw);
	GetgrayGC((LabelWidget)newbsbw);
	redisplay = True;
    }

    if ((curbsbw->label.internal_width != newbsbw->label.internal_width)
        || (curbsbw->label.internal_height != newbsbw->label.internal_height)
	|| was_resized) 
    {
	/* Resize() will be called if geometry changes succeed */
	Position dx, dy;
	_Reposition(newbsbw, curbsbw->core.width, curbsbw->core.height, &dx, &dy);
    }

    return (was_resized 
	    || redisplay 
	    ||  XtIsSensitive(current) != XtIsSensitive(new));
}

static XtGeometryResult QueryGeometry(w, intended, preferred)
    Widget w;
    XtWidgetGeometry *intended, *preferred;
{
    register BSBMnBtWidget bsbw = (BSBMnBtWidget)w;

    preferred->request_mode = CWWidth | CWHeight;
    preferred->width = bsbw->bsbMnBt.totWidth + (bsbw->bsbMnBt.numParts+1)* bsbw->label.internal_width;
    preferred->height = bsbw->bsbMnBt.totHeight + (bsbw->bsbMnBt.numParts+1)*bsbw->label.internal_height;
    if (  ((intended->request_mode & (CWWidth | CWHeight))
	   	== (CWWidth | CWHeight)) &&
	  intended->width == preferred->width &&
	  intended->height == preferred->height)
	return XtGeometryYes;
    else if (preferred->width == w->core.width &&
	     preferred->height == w->core.height)
	return XtGeometryNo;
    else
	return XtGeometryAlmost;
}

static void GetnormalGC(lw)
    LabelWidget lw;
{
    XGCValues	values;

    values.foreground	= lw->label.foreground;
    values.background	= lw->core.background_pixel;
    values.font		= lw->label.font->fid;

    lw->label.normal_GC = XtGetGC(
	(Widget)lw,
	(unsigned) GCForeground | GCBackground | GCFont,
	&values);
}

static void GetgrayGC(lw)
    LabelWidget lw;
{
    XGCValues	values;

    values.foreground = lw->label.foreground;
    values.background = lw->core.background_pixel;
    values.font	      = lw->label.font->fid;
    values.fill_style = FillTiled;
    values.tile       = XmuCreateStippledPixmap(XtScreen((Widget)lw),
						lw->label.foreground, 
						lw->core.background_pixel,
						lw->core.depth);

    lw->label.stipple = values.tile;
    lw->label.gray_GC = XtGetGC((Widget)lw, 
				(unsigned) GCForeground | GCBackground |
					   GCFont | GCTile | GCFillStyle,
				&values);
}

