proc changePixmap-type {} { return {function {} {in: Widget} {in: String} {in: String} ## {widget} {resource} {pixmap file}}}
set wafeCmdNeeds(changePixmap) {XPM }
set wafeHelp(changePixmap) { The command 'changePixmap' sets a attribute of type 'Pixmap' (2nd
 argument) of a widget (1st argument) to the specified image (3rd
 argument). 'changePixmap' keeps track of converted pixmaps by
 maintaining its own pixmap cache.  A pixmap can be released by
 setting the attribute to another pixmap or to one of the following
 values: 'None', 'ParentRelative', or 'Unspecified'. If
 there are no references to a pixmap, all resources (allocated
 memory as well as color cells) of the pixmap are released. 
 
 'changePixmap' can handle shaped pixmaps significantly better then
 sV where Xt's cacheing mechanism can prevent shaping of windows.
 
 When the attribute name is 'iconPixmap' the icon pixmap for any
 shell widget can be set; please note, that if the window manager
 mwm (or a derivative of it) is used the icon pixmap must be set
 before the shell is realized, otherwise the window manager will
 provide it own (unaccesible) icon window.
 
 If error conditions occur 'changePixmap' raises a Tcl exception,
 which can be caught by the Tcl command 'catch'.}

proc setBusy-type {} { return {function {void} {in: Widget} {in: Boolean} ## {shell widget} {sensitive true | false}}}
set wafeHelp(setBusy) { The command 'setBusy' sets the given widget (typically a shell
 widget) and its children busy or not, depending on the boolean
 'state' argument (2nd argument). If a widget is set busy, a
 busy-cursor is set and input is inhibited for all children
 widgets. The appearance of the children widgets will not change.
 If a shell is set busy and set non-busy some time later, all the
 sensitivity states before the setBusy command are reestablished.
 
 Per default a watch is used as the busy cursor; the default busy
 cursor can be altered by the command 'setDefaultBusyCursor'. In
 order to change only the cursor (for any widget) without
 prohibiting input, use the command 'setCursor'.}

proc isBusy-type {} { return {function {Boolean} {in: Widget} ## {Widget to test}}}
set wafeHelp(isBusy) { The function 'isBusy' returns the busy state of the specified widget.}

proc setCursor-type {} { return {function {void} {in: Widget} {in: String} {in: [args opt]} ## {widget} {cursor name} {optional foreground, optional background}}}
set wafeHelp(setCursor) { The command 'setCursor' can be used to change the cursor in the
 specified widget. The name of the cursor (2nd argument) can refer
 to the name of a cursor in the cursor font (e.g. "pirate") or it
 can refer to a x bitmap file (.xbm-file). If there exists a mask
 file with the same name, and "msk" or "Mask" appended, in the same
 directory it is used as a mask for the cursor. An x bitmap file is
 searched along FILESEARCHPATH. Optionally the forground color of
 the cursor can be specified as third argument, the background color
 can be optionally specified as the fourth argument.}

