/*
 * Decompiled with CFR 0.152.
 */
package tcl.bean;

import com.sun.jpropub.vj.vjcomp.VJComponent;
import com.sun.jpropub.vj.vjcomp.VJPortDescriptor;
import java.awt.Panel;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Vector;
import tcl.bean.StudioTclPort;
import tcl.bean.TclInterp;
import tcl.lang.Command;
import tcl.lang.Interp;
import tcl.lang.ReflectObject;
import tcl.lang.TclException;
import tcl.lang.TclIndex;
import tcl.lang.TclList;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;

public class StudioTclInterp
extends VJComponent
implements Command {
    private String[] customOpts = new String[]{"getPanel", "getBeanData", "commitScript"};
    private static final String[] portOpts = new String[]{"in", "out", "twoway"};
    private static final String[] portSwitch = new String[]{"-portname", "-transfer", "-location", "-description"};
    static final long serialVersionUID = 7L;
    private TclInterp tclInterp;
    StudioTclPort[] indexLookup;
    Vector currentVec;
    Vector reuseVec;
    Vector pendingVec;
    private transient Interp customInterp;
    private transient Panel customPanel;
    private boolean customExists = false;
    private boolean customShowing = false;
    private String customData;
    private String customCallback;
    private String customScript;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$awt$Panel;

    public void VJComponentInit(String nm) {
        this.tclInterp = new TclInterp();
        try {
            this.VJComponentInit(this.tclInterp, null, null);
        }
        catch (Exception e) {
            StudioTclInterp.printError("VJComponentInit Error: " + e);
        }
    }

    public void receiveMessage(Object msg, int port) {
        Interp interp = this.tclInterp.getInterp();
        try {
            StudioTclPort tclPort;
            if (this.tclInterp == null) {
                StudioTclInterp.printError("  oh my!!!");
            }
            if (interp == null) {
                StudioTclInterp.printError("  yikes!!!");
            }
            if ((tclPort = this.indexLookup[port]) == null) {
                StudioTclInterp.printError("  bummer!!!");
            }
            String varName = tclPort.inVarName;
            TclObject obj = ReflectObject.newInstance((Interp)interp, (Class)(class$java$lang$Object != null ? class$java$lang$Object : (class$java$lang$Object = StudioTclInterp.class$("java.lang.Object"))), (Object)msg);
            interp.setVar(varName, obj, 513);
        }
        catch (TclException tclException) {
            StudioTclInterp.printError(interp.getResult());
        }
        catch (Exception exception) {
            StudioTclInterp.printError("   ouch!!!");
        }
    }

    String getScript() {
        return this.tclInterp.getScript();
    }

    void setScript(String script) {
        this.tclInterp.setScript(script);
    }

    Interp getInterp() {
        return this.tclInterp.getInterp();
    }

    Interp resetInterp() {
        InputStream dataStream = null;
        Interp interp = this.tclInterp.resetInterp();
        interp.createCommand("studio::port", (Command)this);
        interp.createCommand("studio::custom", (Command)this);
        this.reuseVec = null;
        this.pendingVec = null;
        try {
            try {
                URL url = ((Object)((Object)this)).getClass().getResource("scripts/util.tcl");
                dataStream = url.openStream();
                byte[] charArray = new byte[dataStream.available()];
                dataStream.read(charArray);
                interp.eval(new String(charArray), 1);
            }
            catch (TclException tclException) {
                StudioTclInterp.printError(interp.getResult());
            }
            catch (Exception e) {
                StudioTclInterp.printError(e);
            }
            Object var4_6 = null;
        }
        catch (Throwable throwable) {
            Object var4_7 = null;
            try {
                dataStream.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            dataStream.close();
        }
        catch (IOException iOException) {}
        return interp;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        Interp interp = null;
        try {
            interp = this.resetInterp();
            String script = this.getScript();
            if (script != null && !script.equals("")) {
                interp.eval(script);
            }
            Enumeration e = this.currentVec.elements();
            while (e.hasMoreElements()) {
                StudioTclPort count = (StudioTclPort)e.nextElement();
                count.initWithInterp(interp);
            }
        }
        catch (TclException tclException) {
            StudioTclInterp.printError(interp.getResult());
        }
        catch (Exception e) {
            StudioTclInterp.printError(e);
        }
    }

    public void cmdProc(Interp interp, TclObject[] argv) throws TclException {
        if (argv[0].toString().equals("studio::port")) {
            this.portCmdProc(interp, argv);
        } else {
            this.customCmdProc(interp, argv);
        }
    }

    void portCmdProc(Interp interp, TclObject[] argv) throws TclException {
        int pinType = -1;
        String key = "";
        TclObject portname = null;
        TclObject transfer = null;
        TclObject location = null;
        TclObject description = null;
        StudioTclPort tclPort = null;
        if (argv.length < 3) {
            throw new TclNumArgsException(interp, 1, argv, "option variable ?arg arg ...?");
        }
        int opt = TclIndex.get((Interp)interp, (TclObject)argv[1], (String[])portOpts, (String)"option", (int)0);
        TclObject variable = argv[2];
        int i = 3;
        while (i < argv.length) {
            int arg = TclIndex.get((Interp)interp, (TclObject)argv[i], (String[])portSwitch, (String)"switch", (int)0);
            if (i + 1 >= argv.length) {
                throw new TclException(interp, "value for \"" + argv[i] + "\" missing");
            }
            switch (arg) {
                case 0: {
                    portname = argv[i + 1];
                    break;
                }
                case 1: {
                    transfer = argv[i + 1];
                    break;
                }
                case 2: {
                    location = argv[i + 1];
                    break;
                }
                case 3: {
                    description = argv[i + 1];
                    break;
                }
            }
            i += 2;
        }
        switch (opt) {
            case 0: {
                pinType = VJPortDescriptor.IN_ONLY;
                tclPort = new StudioTclPort(this, pinType, location, portname, description, variable, null, transfer, null);
                break;
            }
            case 1: {
                pinType = VJPortDescriptor.OUT_ONLY;
                tclPort = new StudioTclPort(this, pinType, location, portname, description, null, variable, null, transfer);
                break;
            }
            case 2: {
                TclObject outTrans;
                TclObject inTrans;
                if (TclList.getLength((Interp)interp, (TclObject)variable) != 2) {
                    throw new TclException(interp, "variable must be a list of two elements");
                }
                if (transfer != null) {
                    if (TclList.getLength((Interp)interp, transfer) != 2) {
                        throw new TclException(interp, "transfer argument must be a list of two elements");
                    }
                    inTrans = TclList.index((Interp)interp, transfer, (int)0);
                    outTrans = TclList.index((Interp)interp, transfer, (int)1);
                } else {
                    inTrans = null;
                    outTrans = null;
                }
                pinType = VJPortDescriptor.TWO_WAY;
                tclPort = new StudioTclPort(this, pinType, location, portname, description, TclList.index((Interp)interp, (TclObject)variable, (int)0), TclList.index((Interp)interp, (TclObject)variable, (int)1), inTrans, outTrans);
                break;
            }
        }
        tclPort = this.reusePort(tclPort);
        if (this.ambiguousPort(tclPort)) {
            StudioTclInterp.printError("cannot create two ports with identical values");
            return;
        }
        if (this.pendingVec == null) {
            this.pendingVec = new Vector();
        }
        this.pendingVec.addElement(tclPort);
    }

    StudioTclPort reusePort(StudioTclPort port) {
        try {
            int index;
            if (this.currentVec != null && (index = this.currentVec.indexOf(port)) >= 0) {
                if (this.reuseVec == null) {
                    this.reuseVec = new Vector();
                }
                port = (StudioTclPort)this.currentVec.elementAt(index);
                this.reuseVec.addElement(port);
            }
        }
        catch (Exception e) {
            StudioTclInterp.printError("portExist Error: " + e);
        }
        return port;
    }

    boolean ambiguousPort(StudioTclPort port) {
        if (this.pendingVec == null) {
            return false;
        }
        return this.pendingVec.indexOf(port) >= 0;
    }

    void customCmdProc(Interp interp, TclObject[] argv) throws TclException {
        int cmdOpt = TclIndex.get((Interp)interp, (TclObject)argv[1], (String[])this.customOpts, (String)"option", (int)0);
        switch (cmdOpt) {
            case 0: {
                if (argv.length != 2) {
                    throw new TclNumArgsException(interp, 1, argv, "getPanel");
                }
                interp.setResult(ReflectObject.newInstance((Interp)interp, (Class)(class$java$awt$Panel != null ? class$java$awt$Panel : (class$java$awt$Panel = StudioTclInterp.class$("java.awt.Panel"))), (Object)this.getCustomPanel()));
                break;
            }
            case 1: {
                if (argv.length != 2) {
                    throw new TclNumArgsException(interp, 1, argv, "getBeanData");
                }
                interp.setResult(this.getCustomData());
                break;
            }
            case 2: {
                if (argv.length != 3) {
                    throw new TclNumArgsException(interp, 1, argv, "commitScript script");
                }
                this.customCallback = argv[2].toString();
                break;
            }
        }
    }

    void initCustom(String script) {
        this.customScript = script;
    }

    void evalCustom() throws TclException {
        if (this.customScript == null) {
            StudioTclInterp.printError("customInterp never initialized.");
            return;
        }
        try {
            this.customInterp = new Interp();
            this.customInterp.createCommand("studio::custom", (Command)this);
            this.customPanel = new Panel();
            this.customInterp.eval(this.customScript);
        }
        catch (TclException tclException) {
            StudioTclInterp.printError(this.customInterp.getResult());
            throw new TclException(1);
        }
    }

    void invalidateCustom() {
        this.customExists = false;
        this.customShowing = false;
        this.customCallback = null;
        this.customData = null;
        this.customInterp = null;
        this.customPanel = null;
        this.customScript = null;
    }

    boolean customExists() {
        return this.customExists;
    }

    void setCustomExists(boolean b) {
        this.customExists = b;
    }

    boolean customShowing() {
        return this.customShowing;
    }

    void setCustomShowing(boolean b) {
        this.customShowing = b;
    }

    Panel getCustomPanel() {
        if (this.customPanel == null) {
            this.customPanel = new Panel();
        }
        return this.customPanel;
    }

    String getCustomData() throws TclException {
        if (this.customData == null) {
            return "";
        }
        return this.customData;
    }

    void evalCustomCallback(Interp interp) throws TclException {
        try {
            this.customInterp.eval(this.customCallback);
            this.customData = this.customInterp.getResult().toString();
        }
        catch (TclException e) {
            int compCode = e.getCompletionCode();
            if (compCode == 2) {
                this.customData = this.customInterp.getResult().toString();
            }
            if (compCode == 3) {
                throw new TclException(interp, "invoked \"break\" outside of a loop");
            }
            if (compCode == 4) {
                throw new TclException(interp, "invoked \"continue\" outside of a loop");
            }
            throw new TclException(interp, this.customInterp.getResult().toString());
        }
    }

    static void printError(Object msg) {
        System.out.println(msg);
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }
}

