/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import tcl.lang.BackSlashResult;
import tcl.lang.FindElemResult;
import tcl.lang.FormatCmd;
import tcl.lang.Interp;
import tcl.lang.PrecTraceProc;
import tcl.lang.RegexMatcher;
import tcl.lang.StrtodResult;
import tcl.lang.StrtoulResult;
import tcl.lang.TclException;
import tcl.lang.TclObject;
import tcl.lang.TclRuntimeError;
import tcl.lang.TclString;
import tcl.lang.VarTrace;

public class Util {
    static final int TCL_DONT_USE_BRACES = 1;
    static final int USE_BRACES = 2;
    static final int BRACES_UNMATCHED = 4;
    static final String intTooBigCode = "ARITH IOVERFLOW {integer value too large to represent}";
    static final String fpTooBigCode = "ARITH OVERFLOW {floating-point value too large to represent}";
    static char[] cvtIn = new char[]{'\u0000', '\u0001', '\u0002', '\u0003', '\u0004', '\u0005', '\u0006', '\u0007', '\b', '\t', 'd', 'd', 'd', 'd', 'd', 'd', 'd', '\n', '\u000b', '\f', '\r', '\u000e', '\u000f', '\u0010', '\u0011', '\u0012', '\u0013', '\u0014', '\u0015', '\u0016', '\u0017', '\u0018', '\u0019', '\u001a', '\u001b', '\u001c', '\u001d', '\u001e', '\u001f', ' ', '!', '\"', '#', 'd', 'd', 'd', 'd', 'd', 'd', '\n', '\u000b', '\f', '\r', '\u000e', '\u000f', '\u0010', '\u0011', '\u0012', '\u0013', '\u0014', '\u0015', '\u0016', '\u0017', '\u0018', '\u0019', '\u001a', '\u001b', '\u001c', '\u001d', '\u001e', '\u001f', ' ', '!', '\"', '#'};
    static final int maxExponent = 511;
    static final double[] powersOf10 = new double[]{10.0, 100.0, 10000.0, 1.0E8, 1.0E16, 1.0E32, 1.0E64, 1.0E128, 1.0E256};
    static RegexMatcher regexMatcher = Util.checkRegexPackage();
    static boolean broken_isLetterOrDigit = Util.checkIsLetterOrDigit();
    static final int DEFAULT_PRECISION = 12;
    static int precision = 12;

    static StrtoulResult strtoul(String s, int start, int base) {
        int digit;
        long result = 0L;
        boolean anyDigits = false;
        int len = s.length();
        int i = start;
        while (i < len && Character.isWhitespace(s.charAt(i))) {
            ++i;
        }
        if (i >= len) {
            return new StrtoulResult(0L, 0, -1);
        }
        if (base == 0) {
            char c = s.charAt(i);
            if (c == '0') {
                if (i < len - 1 && (c = s.charAt(++i)) == 'x') {
                    ++i;
                    base = 16;
                }
                if (base == 0) {
                    anyDigits = true;
                    base = 8;
                }
            } else {
                base = 10;
            }
        } else if (base == 16 && i < len - 2 && s.charAt(i) == '0' && s.charAt(i + 1) == 'x') {
            i += 2;
        }
        long max = 0x100000000L / (long)base;
        boolean overflowed = false;
        while (i < len && (digit = s.charAt(i) - 48) >= 0 && digit <= 74 && (digit = cvtIn[digit]) < base) {
            if (result > max) {
                overflowed = true;
            }
            result = result * (long)base + (long)digit;
            anyDigits = true;
            ++i;
        }
        if (!anyDigits) {
            return new StrtoulResult(0L, 0, -1);
        }
        if (overflowed) {
            return new StrtoulResult(0L, i, -2);
        }
        return new StrtoulResult(result, i, 0);
    }

    static int getInt(Interp interp, String s) throws TclException {
        boolean sign;
        int len = s.length();
        int i = 0;
        while (i < len && Character.isWhitespace(s.charAt(i))) {
            ++i;
        }
        if (i >= len) {
            throw new TclException(interp, "expected integer but got \"" + s + "\"");
        }
        char c = s.charAt(i);
        if (c == '-') {
            sign = true;
            ++i;
        } else {
            if (c == '+') {
                ++i;
            }
            sign = false;
        }
        StrtoulResult res = Util.strtoul(s, i, 0);
        if (res.errno < 0) {
            if (res.errno == -2) {
                if (interp != null) {
                    interp.setErrorCode(TclString.newInstance((String)intTooBigCode));
                }
                throw new TclException(interp, "integer value too large to represent");
            }
            throw new TclException(interp, "expected integer but got \"" + s + "\"");
        }
        if (res.index < len) {
            i = res.index;
            while (i < len) {
                if (!Character.isWhitespace(s.charAt(i))) {
                    throw new TclException(interp, "expected integer but got \"" + s + "\"");
                }
                ++i;
            }
        }
        if (sign) {
            return (int)(-res.value);
        }
        return (int)res.value;
    }

    static StrtodResult strtod(String s, int start) {
        boolean sign = false;
        int len = s.length();
        int i = start;
        while (i < len && Character.isWhitespace(s.charAt(i))) {
            ++i;
        }
        if (i >= len) {
            return new StrtodResult(0.0, 0, -3);
        }
        char c = s.charAt(i);
        if (c == '-') {
            sign = true;
            ++i;
        } else {
            if (c == '+') {
                ++i;
            }
            sign = false;
        }
        int decPt = -1;
        int mantSize = 0;
        while (true) {
            if (!Character.isDigit(c = Util.CharAt(s, i, len))) {
                if (c != '.' || decPt >= 0) break;
                decPt = mantSize;
            }
            ++i;
            ++mantSize;
        }
        if (Util.CharAt(s, i, len) == 'E' || Util.CharAt(s, i, len) == 'e') {
            if (Util.CharAt(s, ++i, len) == '-') {
                ++i;
            } else if (Util.CharAt(s, i, len) == '+') {
                ++i;
            }
            while (Character.isDigit(Util.CharAt(s, i, len))) {
                ++i;
            }
        }
        s = s.substring(start, i);
        double result = 0.0;
        try {
            result = Double.valueOf(s);
        }
        catch (NumberFormatException e) {
            return new StrtodResult(0.0, 0, -3);
        }
        if (result == Double.NEGATIVE_INFINITY || result == Double.POSITIVE_INFINITY) {
            return new StrtodResult(0.0, i, -4);
        }
        if (result == Double.NaN) {
            return new StrtodResult(0.0, 0, -3);
        }
        return new StrtodResult(result, i, 0);
    }

    static final char CharAt(String s, int index, int len) {
        if (index >= 0 && index < len) {
            return s.charAt(index);
        }
        return '\u0000';
    }

    static double getDouble(Interp interp, String s) throws TclException {
        boolean sign;
        int len = s.length();
        int i = 0;
        while (i < len && Character.isWhitespace(s.charAt(i))) {
            ++i;
        }
        if (i >= len) {
            throw new TclException(interp, "expected floating-point number but got \"" + s + "\"");
        }
        char c = s.charAt(i);
        if (c == '-') {
            sign = true;
            ++i;
        } else {
            if (c == '+') {
                ++i;
            }
            sign = false;
        }
        StrtodResult res = Util.strtod(s, i);
        if (res.errno != 0) {
            if (res.errno == -4) {
                if (interp != null) {
                    interp.setErrorCode(TclString.newInstance((String)fpTooBigCode));
                }
                throw new TclException(interp, "floating-point value too large to represent");
            }
            throw new TclException(interp, "expected floating-point number but got \"" + s + "\"");
        }
        if (res.index < len) {
            i = res.index;
            while (i < len) {
                if (!Character.isWhitespace(s.charAt(i))) {
                    throw new TclException(interp, "expected floating-point number but got \"" + s + "\"");
                }
                ++i;
            }
        }
        if (sign) {
            return -res.value;
        }
        return res.value;
    }

    static String concat(int from, int to, TclObject[] argv) {
        if (from > argv.length) {
            return "";
        }
        if (to <= argv.length) {
            to = argv.length - 1;
        }
        StringBuffer sbuf = new StringBuffer();
        int i = from;
        while (i <= to) {
            String str = Util.TrimLeft(argv[i].toString());
            if ((str = Util.TrimRight(str)).length() != 0) {
                sbuf.append(str);
                if (i < to) {
                    sbuf.append(" ");
                }
            }
            ++i;
        }
        return sbuf.toString();
    }

    public static final boolean stringMatch(String str, String pat) {
        char[] strArr = str.toCharArray();
        char[] patArr = pat.toCharArray();
        int strLen = str.length();
        int patLen = pat.length();
        int pIndex = 0;
        int sIndex = 0;
        boolean incrIndex = false;
        while (true) {
            if (incrIndex) {
                ++pIndex;
                ++sIndex;
                incrIndex = false;
            }
            if (pIndex == patLen) {
                return sIndex == strLen;
            }
            if (sIndex == strLen && patArr[pIndex] != '*') {
                return false;
            }
            if (patArr[pIndex] == '*') {
                if (++pIndex == patLen) {
                    return true;
                }
                while (true) {
                    if (Util.stringMatch(str.substring(sIndex), pat.substring(pIndex))) {
                        return true;
                    }
                    if (sIndex == strLen) {
                        return false;
                    }
                    ++sIndex;
                }
            }
            if (patArr[pIndex] == '?') {
                incrIndex = true;
                continue;
            }
            if (patArr[pIndex] == '[') {
                ++pIndex;
                while (true) {
                    if (pIndex == patLen || patArr[pIndex] == ']') {
                        return false;
                    }
                    if (sIndex == strLen) {
                        return false;
                    }
                    char ch1 = patArr[pIndex];
                    char strch = strArr[sIndex];
                    if (pIndex + 1 != patLen && patArr[pIndex + 1] == '-') {
                        if ((pIndex += 2) == patLen) {
                            return false;
                        }
                        char ch2 = patArr[pIndex];
                        if (ch1 <= strch && ch2 >= strch || ch1 >= strch && ch2 <= strch) {
                            break;
                        }
                    } else if (ch1 == strch) break;
                    ++pIndex;
                }
                ++pIndex;
                while (pIndex != patLen && patArr[pIndex] != ']') {
                    ++pIndex;
                }
                if (pIndex == patLen) {
                    return false;
                }
                incrIndex = true;
                continue;
            }
            if (patArr[pIndex] == '\\' && ++pIndex == patLen) {
                return false;
            }
            if (sIndex == strLen || patArr[pIndex] != strArr[sIndex]) {
                return false;
            }
            incrIndex = true;
        }
    }

    static final RegexMatcher checkRegexPackage() {
        try {
            Class<?> cls = Class.forName("tcl.regex.OroRegexMatcher");
            return (RegexMatcher)cls.newInstance();
        }
        catch (Exception e) {
            return null;
        }
    }

    static final boolean regExpMatch(Interp interp, String string, TclObject pattern) throws TclException {
        if (regexMatcher != null) {
            return regexMatcher.match(interp, string, pattern.toString());
        }
        return false;
    }

    static final void appendElement(Interp interp, StringBuffer sbuf, String s) throws TclException {
        if (sbuf.length() > 0) {
            sbuf.append(' ');
        }
        int flags = Util.scanElement(interp, s);
        sbuf.append(Util.convertElement(s, flags));
    }

    static final FindElemResult findElement(Interp interp, String s, int i, int len) throws TclException {
        int openBraces = 0;
        boolean inQuotes = false;
        while (i < len && Character.isWhitespace(s.charAt(i))) {
            ++i;
        }
        if (i >= len) {
            return null;
        }
        char c = s.charAt(i);
        if (c == '{') {
            openBraces = 1;
            ++i;
        } else if (c == '\"') {
            inQuotes = true;
            ++i;
        }
        StringBuffer sbuf = new StringBuffer();
        while (true) {
            if (i >= len) {
                if (openBraces != 0) {
                    throw new TclException(interp, "unmatched open brace in list");
                }
                if (inQuotes) {
                    throw new TclException(interp, "unmatched open quote in list");
                }
                return new FindElemResult(i, sbuf.toString());
            }
            c = s.charAt(i);
            switch (c) {
                case '{': {
                    if (openBraces != 0) {
                        ++openBraces;
                    }
                    sbuf.append(c);
                    ++i;
                    break;
                }
                case '}': {
                    if (openBraces == 1) {
                        if (i == len - 1 || Character.isWhitespace(s.charAt(i + 1))) {
                            return new FindElemResult(i + 1, sbuf.toString());
                        }
                        int errEnd = i + 1;
                        while (errEnd < len) {
                            if (Character.isWhitespace(s.charAt(errEnd))) break;
                            ++errEnd;
                        }
                        throw new TclException(interp, "list element in braces followed by \"" + s.substring(i + 1, errEnd) + "\" instead of space");
                    }
                    if (openBraces != 0) {
                        --openBraces;
                    }
                    sbuf.append(c);
                    ++i;
                    break;
                }
                case '\\': {
                    if (openBraces > 0) {
                        sbuf.append(c);
                        ++i;
                        break;
                    }
                    BackSlashResult bs = Interp.backslash(s, i, len);
                    sbuf.append(bs.c);
                    i = bs.nextIndex;
                    break;
                }
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    if (openBraces == 0 && !inQuotes) {
                        return new FindElemResult(i + 1, sbuf.toString());
                    }
                    sbuf.append(c);
                    ++i;
                    break;
                }
                case '\"': {
                    if (inQuotes) {
                        if (i == len - 1 || Character.isWhitespace(s.charAt(i + 1))) {
                            return new FindElemResult(i + 1, sbuf.toString());
                        }
                        int errEnd = i + 1;
                        while (errEnd < len) {
                            if (Character.isWhitespace(s.charAt(errEnd))) break;
                            ++errEnd;
                        }
                        throw new TclException(interp, "list element in quotes followed by \"" + s.substring(i + 1, errEnd) + "\" instead of space");
                    }
                    sbuf.append(c);
                    ++i;
                    break;
                }
                default: {
                    sbuf.append(c);
                    ++i;
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    static int scanElement(Interp interp, String string) throws TclException {
        void var2_4;
        char c;
        boolean debug = false;
        int nestingLevel = 0;
        int flags = 0;
        int i = 0;
        int len = string.length();
        if (len == 0) {
            string = String.valueOf('\u0000');
        }
        if ((c = string.charAt(i)) == '{' || c == '\"' || c == '\u0000') {
            flags |= 2;
        }
        while (i < len) {
            c = string.charAt(i);
            switch (c) {
                case '{': {
                    ++nestingLevel;
                    break;
                }
                case '}': {
                    if (--nestingLevel >= 0) break;
                    flags |= 5;
                    break;
                }
                case '\t': 
                case '\n': 
                case '\u000b': 
                case '\f': 
                case '\r': 
                case ' ': 
                case '$': 
                case ';': 
                case '[': {
                    flags |= 2;
                    break;
                }
                case '\\': {
                    if (i >= len - 1 || string.charAt(i + 1) == '\n') {
                        flags = 5;
                        break;
                    }
                    BackSlashResult bs = Interp.backslash(string, i, len);
                    i = bs.nextIndex - 1;
                    flags |= 2;
                    break;
                }
            }
            ++i;
        }
        if (nestingLevel != 0) {
            flags = 5;
        }
        return (int)var2_4;
    }

    /*
     * Unable to fully structure code
     */
    static String convertElement(String s, int flags) {
        block14: {
            block13: {
                i = 0;
                len = s.length();
                if (s == null || s.length() == 0 || s.charAt(0) == '\u0000') {
                    return "{}";
                }
                sbuf = new StringBuffer();
                if ((flags & 2) == 0 || (flags & 1) != 0) break block13;
                sbuf.append('{');
                i = 0;
                while (i < len) {
                    sbuf.append(s.charAt(i));
                    ++i;
                }
                sbuf.append('}');
                break block14;
            }
            c = s.charAt(0);
            if (c == '{') {
                sbuf.append('\\');
                sbuf.append('{');
                ++i;
                flags |= 4;
            }
            while (i < len) {
                c = s.charAt(i);
                switch (c) {
                    case ' ': 
                    case '\"': 
                    case '$': 
                    case ';': 
                    case '[': 
                    case '\\': 
                    case ']': {
                        sbuf.append('\\');
                        ** GOTO lbl69
                    }
                    case '{': 
                    case '}': {
                        if ((flags & 4) == 0) ** GOTO lbl69
                        sbuf.append('\\');
                        ** GOTO lbl69
                    }
                    case '\f': {
                        sbuf.append('\\');
                        sbuf.append('f');
                        break;
                    }
                    case '\n': {
                        sbuf.append('\\');
                        sbuf.append('n');
                        break;
                    }
                    case '\r': {
                        sbuf.append('\\');
                        sbuf.append('r');
                        break;
                    }
                    case '\t': {
                        sbuf.append('\\');
                        sbuf.append('t');
                        break;
                    }
                    case '\u000b': {
                        sbuf.append('\\');
                        sbuf.append('v');
                        break;
                    }
lbl69:
                    // 4 sources

                    default: {
                        sbuf.append(c);
                    }
                }
                ++i;
            }
        }
        return sbuf.toString();
    }

    static String TrimLeft(String str, String pattern) {
        int strLen = str.length();
        int patLen = pattern.length();
        boolean done = false;
        int i = 0;
        while (i < strLen) {
            char c = str.charAt(i);
            done = true;
            int j = 0;
            while (j < patLen) {
                if (c == pattern.charAt(j)) {
                    done = false;
                    break;
                }
                ++j;
            }
            if (done) break;
            ++i;
        }
        return str.substring(i, strLen);
    }

    static String TrimLeft(String str) {
        return Util.TrimLeft(str, " \n\t\r");
    }

    static String TrimRight(String str, String pattern) {
        int last = str.length() - 1;
        char[] strArray = str.toCharArray();
        while (last >= 0) {
            char c = strArray[last];
            if (pattern.indexOf(c) == -1) break;
            --last;
        }
        return str.substring(0, last + 1);
    }

    static String TrimRight(String str) {
        return Util.TrimRight(str, " \n\t\r");
    }

    static boolean getBoolean(Interp interp, String string) throws TclException {
        String s = string.toLowerCase();
        if (s.length() > 0) {
            if ("yes".startsWith(s)) {
                return true;
            }
            if ("no".startsWith(s)) {
                return false;
            }
            if ("true".startsWith(s)) {
                return true;
            }
            if ("false".startsWith(s)) {
                return false;
            }
            if ("on".startsWith(s) && s.length() > 1) {
                return true;
            }
            if ("off".startsWith(s) && s.length() > 1) {
                return false;
            }
            if (s.equals("0")) {
                return false;
            }
            if (s.equals("1")) {
                return true;
            }
        }
        throw new TclException(interp, "expected boolean value but got \"" + string + "\"");
    }

    static final boolean checkIsLetterOrDigit() {
        try {
            Character.isLetterOrDigit('c');
            return false;
        }
        catch (Exception e) {
            return true;
        }
    }

    static final boolean isLetterOrDigit(char c) {
        if (!broken_isLetterOrDigit) {
            return Character.isLetterOrDigit(c);
        }
        return c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9';
    }

    static final int getActualPlatform() {
        if (Util.isWindows()) {
            return 1;
        }
        if (Util.isMac()) {
            return 2;
        }
        return 0;
    }

    static final boolean isUnix() {
        return !Util.isMac() && !Util.isWindows();
    }

    static final boolean isMac() {
        String os = System.getProperty("os.name");
        return os.toLowerCase().startsWith("mac");
    }

    static final boolean isWindows() {
        String os = System.getProperty("os.name");
        return os.toLowerCase().startsWith("win");
    }

    static void setupPrecisionTrace(Interp interp) {
        try {
            interp.traceVar("tcl_precision", (VarTrace)new PrecTraceProc(), 113);
        }
        catch (TclException e) {
            throw new TclRuntimeError("unexpected TclException: " + (Object)((Object)e));
        }
    }

    static String printDouble(double number) {
        String s = FormatCmd.toString(number, precision, 10);
        int length = s.length();
        int i = 0;
        while (i < length) {
            if (s.charAt(i) == '.' || Character.isLetter(s.charAt(i))) {
                return s;
            }
            ++i;
        }
        return s.concat(".0");
    }

    /*
     * WARNING - void declaration
     */
    static String tryGetSystemProperty(String propName, String defautlValue) {
        try {
            return System.getProperty(propName);
        }
        catch (SecurityException e) {
            void var1_1;
            return var1_1;
        }
    }

    private Util() {
    }
}

