/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import tcl.lang.Command;
import tcl.lang.Interp;
import tcl.lang.TclException;
import tcl.lang.TclIndex;
import tcl.lang.TclList;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;
import tcl.lang.Util;

class LsearchCmd
implements Command {
    private static final String[] validCmds = new String[]{"-exact", "-glob", "-regexp"};
    static final int EXACT = 0;
    static final int GLOB = 1;
    static final int REGEXP = 2;

    public void cmdProc(Interp interp, TclObject[] argv) throws TclException {
        int mode = 1;
        TclObject pattern = null;
        TclObject list = null;
        if (argv.length == 4) {
            mode = TclIndex.get((Interp)interp, (TclObject)argv[1], (String[])validCmds, (String)"search mode", (int)0);
            list = argv[2];
            pattern = argv[3];
        } else if (argv.length == 3) {
            list = argv[1];
            pattern = argv[2];
        } else {
            throw new TclNumArgsException(interp, 1, argv, "?mode? list pattern");
        }
        boolean match = false;
        int size = TclList.getLength(interp, list);
        int i = 0;
        while (i < size) {
            TclObject o = TclList.index(interp, list, i);
            if (o == pattern || o.equals((Object)pattern)) {
                match = true;
            } else {
                switch (mode) {
                    case 0: {
                        match = o.toString().compareTo(pattern.toString()) == 0;
                        break;
                    }
                    case 1: {
                        match = Util.stringMatch(o.toString(), pattern.toString());
                        break;
                    }
                    case 2: {
                        match = Util.regExpMatch(interp, o.toString(), pattern);
                    }
                }
            }
            if (match) {
                interp.setResult(i);
                return;
            }
            ++i;
        }
        interp.setResult(-1);
    }

    LsearchCmd() {
    }
}

