/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import java.util.Enumeration;
import java.util.Hashtable;
import tcl.lang.ArrayObject;
import tcl.lang.Command;
import tcl.lang.CommandWithDispose;
import tcl.lang.InternalRep;
import tcl.lang.Interp;
import tcl.lang.JavaInfoCmd;
import tcl.lang.JavaInvoke;
import tcl.lang.TclException;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;
import tcl.lang.TclRuntimeError;
import tcl.lang.TclString;

public class ReflectObject
extends InternalRep
implements CommandWithDispose {
    private static final String NULL_REP = "java0x0";
    protected static final String NOCONVERT = "-noconvert";
    protected static final String CMD_PREFIX = "java0x";
    private static final boolean debug = false;
    Object javaObj;
    Class javaClass;
    Interp ownerInterp;
    String refID;
    private int useCount;
    private boolean isValid;
    Hashtable bindings;
    private static /* synthetic */ Class class$Ljava$lang$Integer;
    private static /* synthetic */ Class class$Ljava$lang$Boolean;
    private static /* synthetic */ Class class$Ljava$lang$Long;
    private static /* synthetic */ Class class$Ljava$lang$Float;
    private static /* synthetic */ Class class$Ljava$lang$Double;
    private static /* synthetic */ Class class$Ljava$lang$Byte;
    private static /* synthetic */ Class class$Ljava$lang$Short;
    private static /* synthetic */ Class class$Ljava$lang$Character;

    /*
     * WARNING - void declaration
     */
    private static ReflectObject makeNullObject(Interp i, Class c) {
        void var2_2;
        ReflectObject ro = new ReflectObject();
        ro.ownerInterp = i;
        ro.refID = NULL_REP;
        ro.useCount = 1;
        ro.isValid = true;
        ro.javaObj = null;
        ro.javaClass = c;
        return var2_2;
    }

    private static void addToReflectTable(ReflectObject roRep) {
        Interp interp = roRep.ownerInterp;
        Class cl = roRep.javaClass;
        Object obj = roRep.javaObj;
        String id = roRep.refID;
        StringBuffer ident_buff = new StringBuffer();
        ident_buff.append(JavaInfoCmd.getNameFromClass(cl));
        ident_buff.append('.');
        ident_buff.append(System.identityHashCode(obj));
        String ident = ident_buff.toString();
        ReflectObject found = (ReflectObject)interp.reflectObjTable.get(ident);
        if (found != null) {
            throw new TclRuntimeError("reflectObjectTable returned null for " + id);
        }
        interp.reflectObjTable.put(ident, roRep);
    }

    private static void removeFromReflectTable(ReflectObject roRep) {
        Interp interp = roRep.ownerInterp;
        Class cl = roRep.javaClass;
        Object obj = roRep.javaObj;
        String id = roRep.refID;
        StringBuffer ident_buff = new StringBuffer();
        ident_buff.append(JavaInfoCmd.getNameFromClass(cl));
        ident_buff.append('.');
        ident_buff.append(System.identityHashCode(obj));
        String ident = ident_buff.toString();
        ReflectObject found = (ReflectObject)interp.reflectObjTable.get(ident);
        if (found == null) {
            throw new TclRuntimeError("reflectObjectTable returned null for " + id);
        }
        if (found != roRep) {
            throw new TclRuntimeError("reflect object did not match object in table");
        }
        interp.reflectObjTable.remove(ident);
    }

    private static ReflectObject findInReflectTable(Interp interp, Class cl, Object obj) {
        StringBuffer ident_buff = new StringBuffer();
        ident_buff.append(JavaInfoCmd.getNameFromClass(cl));
        ident_buff.append('.');
        ident_buff.append(System.identityHashCode(obj));
        String ident = ident_buff.toString();
        ReflectObject found = (ReflectObject)interp.reflectObjTable.get(ident);
        if (found == null) {
            return null;
        }
        if (found.javaClass != cl || found.javaObj != obj || found.ownerInterp != interp) {
            throw new TclRuntimeError("table entry did not match arguments");
        }
        return found;
    }

    public static void dump(Interp interp) {
        try {
            ReflectObject roRep;
            System.out.println("BEGIN DUMP -------------------------------");
            System.out.println("interp.reflectObjCount = " + interp.reflectObjCount);
            System.out.println("interp.reflectIDTable.size() = " + interp.reflectIDTable.size());
            System.out.println("interp.reflectObjTable.size() = " + interp.reflectObjTable.size());
            System.out.println("dumping reflectIDTable");
            Enumeration keys = interp.reflectIDTable.keys();
            while (keys.hasMoreElements()) {
                Command command;
                Class tclass;
                System.out.println();
                String refID = (String)keys.nextElement();
                roRep = (ReflectObject)interp.reflectIDTable.get(refID);
                if (roRep == null) {
                    throw new RuntimeException("Reflect ID Table entry \"" + refID + "\" hashed to null");
                }
                if (!refID.equals(roRep.refID)) {
                    throw new RuntimeException("Reflect ID Table entry \"" + refID + "\" does not match object refID \"" + roRep.refID + "\"");
                }
                if (roRep.ownerInterp != interp) {
                    throw new RuntimeException("roRep.ownerInterp not the same as current interp");
                }
                System.out.println("refID = \"" + roRep.refID + "\"");
                System.out.println("javaClass = \"" + JavaInfoCmd.getNameFromClass(roRep.javaClass) + "\"");
                System.out.println("javaObj.hashCode() = \"" + roRep.javaObj.hashCode() + "\"");
                System.out.println("System.identityHashCode(javaObj) = \"" + System.identityHashCode(roRep.javaObj) + "\"");
                TclObject tobj = TclString.newInstance(roRep.refID);
                try {
                    tclass = ReflectObject.getClass(interp, tobj);
                }
                catch (TclException e) {
                    tclass = null;
                }
                if (tclass != null && roRep.javaClass != tclass) {
                    throw new RuntimeException("javaClass is not the same the reflect class type \"" + JavaInfoCmd.getNameFromClass(tclass) + "\" in the interp");
                }
                System.out.println("useCount = \"" + roRep.useCount + "\"");
                System.out.println("isValid = \"" + roRep.isValid + "\"");
                try {
                    command = interp.getCommand(roRep.refID);
                }
                catch (TclRuntimeError e) {
                    command = null;
                }
                if (command == null) {
                    System.out.println("could not find command named \"" + roRep.refID + "\"");
                }
                StringBuffer ident_buff = new StringBuffer();
                ident_buff.append(JavaInfoCmd.getNameFromClass(roRep.javaClass));
                ident_buff.append('.');
                ident_buff.append(System.identityHashCode(roRep.javaObj));
                String ident = ident_buff.toString();
                ReflectObject found = (ReflectObject)interp.reflectObjTable.get(ident);
                if (roRep == found) continue;
                throw new RuntimeException("Reflect ID table entry \"" + ident + "\" did not hash to its own ReflectObject");
            }
            System.out.println();
            System.out.println("dumping reflectObjTable");
            keys = interp.reflectObjTable.keys();
            while (keys.hasMoreElements()) {
                System.out.println();
                String ident = (String)keys.nextElement();
                roRep = (ReflectObject)interp.reflectObjTable.get(ident);
                if (roRep == null) {
                    throw new RuntimeException("Reflect table entry \"" + ident + "\" hashed to null");
                }
                if (roRep != interp.reflectIDTable.get(roRep.refID)) {
                    throw new RuntimeException("Reflect table entry \"" + ident + "\" did not hash to its own ReflectObject");
                }
                StringBuffer ident_buff = new StringBuffer();
                ident_buff.append(JavaInfoCmd.getNameFromClass(roRep.javaClass));
                ident_buff.append('.');
                ident_buff.append(System.identityHashCode(roRep.javaObj));
                if (!ident.equals(ident_buff.toString())) {
                    throw new RuntimeException("ident \"" + ident + "\" is not equal to calculated" + " ident \"" + ident_buff.toString());
                }
                System.out.println("ident \"" + ident + "\" corresponds to ReflectObject with " + "refID \"" + roRep.refID + "\"");
            }
        }
        catch (Throwable e) {
            e.printStackTrace(System.out);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static ReflectObject makeReflectObject(Interp interp, Class cl, Object obj) throws TclException {
        void var3_3;
        if (obj == null) {
            return ReflectObject.makeNullObject(interp, cl);
        }
        if (cl == null) {
            throw new TclException(interp, "non null reflect object with null class is not valid");
        }
        if (cl == Integer.TYPE) {
            cl = class$Ljava$lang$Integer != null ? class$Ljava$lang$Integer : (class$Ljava$lang$Integer = ReflectObject.class$("java.lang.Integer"));
        } else if (cl == Boolean.TYPE) {
            cl = class$Ljava$lang$Boolean != null ? class$Ljava$lang$Boolean : (class$Ljava$lang$Boolean = ReflectObject.class$("java.lang.Boolean"));
        } else if (cl == Long.TYPE) {
            cl = class$Ljava$lang$Long != null ? class$Ljava$lang$Long : (class$Ljava$lang$Long = ReflectObject.class$("java.lang.Long"));
        } else if (cl == Float.TYPE) {
            cl = class$Ljava$lang$Float != null ? class$Ljava$lang$Float : (class$Ljava$lang$Float = ReflectObject.class$("java.lang.Float"));
        } else if (cl == Double.TYPE) {
            cl = class$Ljava$lang$Double != null ? class$Ljava$lang$Double : (class$Ljava$lang$Double = ReflectObject.class$("java.lang.Double"));
        } else if (cl == Byte.TYPE) {
            cl = class$Ljava$lang$Byte != null ? class$Ljava$lang$Byte : (class$Ljava$lang$Byte = ReflectObject.class$("java.lang.Byte"));
        } else if (cl == Short.TYPE) {
            cl = class$Ljava$lang$Short != null ? class$Ljava$lang$Short : (class$Ljava$lang$Short = ReflectObject.class$("java.lang.Short"));
        } else if (cl == Character.TYPE) {
            cl = class$Ljava$lang$Character != null ? class$Ljava$lang$Character : (class$Ljava$lang$Character = ReflectObject.class$("java.lang.Character"));
        } else if (cl == Void.TYPE) {
            throw new TclException(interp, "void object type can not be reflected");
        }
        ReflectObject roRep = ReflectObject.findInReflectTable(interp, cl, obj);
        if (roRep != null) {
            ++roRep.useCount;
            return roRep;
        }
        roRep = cl.isArray() ? new ArrayObject() : new ReflectObject();
        roRep.ownerInterp = interp;
        roRep.javaObj = obj;
        roRep.javaClass = cl;
        Class<?> obj_class = roRep.javaObj.getClass();
        if (!roRep.javaClass.isAssignableFrom(obj_class)) {
            throw new TclException(interp, "object of type " + JavaInfoCmd.getNameFromClass(obj_class) + " can not be referenced as type " + JavaInfoCmd.getNameFromClass(roRep.javaClass));
        }
        ++interp.reflectObjCount;
        roRep.refID = CMD_PREFIX + Long.toHexString(interp.reflectObjCount);
        interp.createCommand(roRep.refID, (Command)roRep);
        interp.reflectIDTable.put(roRep.refID, roRep);
        ReflectObject.addToReflectTable(roRep);
        roRep.useCount = 1;
        roRep.isValid = true;
        return var3_3;
    }

    protected void dispose() {
        --this.useCount;
        if (this.useCount == 0 && this.refID != NULL_REP) {
            this.ownerInterp.deleteCommand(this.refID);
            this.ownerInterp.reflectIDTable.remove(this.refID);
            ReflectObject.removeFromReflectTable(this);
            this.ownerInterp = null;
            this.javaObj = null;
            this.javaClass = null;
            this.bindings = null;
            this.refID = NULL_REP;
        }
    }

    protected InternalRep duplicate() {
        ++this.useCount;
        return this;
    }

    private static void setReflectObjectFromAny(Interp interp, TclObject tobj) throws TclException {
        String s;
        ReflectObject roRep;
        InternalRep rep = tobj.getInternalRep();
        if (rep instanceof ReflectObject) {
            roRep = (ReflectObject)rep;
            if (roRep.isValid && roRep.ownerInterp == interp) {
                return;
            }
        }
        if ((s = tobj.toString()).startsWith(CMD_PREFIX)) {
            if (s.equals(NULL_REP)) {
                tobj.setInternalRep(ReflectObject.makeReflectObject(interp, null, null));
                return;
            }
            roRep = (ReflectObject)interp.reflectIDTable.get(s);
            if (roRep != null && roRep.isValid) {
                ++roRep.useCount;
                tobj.setInternalRep(roRep);
                return;
            }
        }
        throw new TclException(interp, "unknown java object \"" + tobj + "\"");
    }

    public static TclObject newInstance(Interp interp, Class cl, Object obj) throws TclException {
        return new TclObject(ReflectObject.makeReflectObject(interp, cl, obj));
    }

    public static Object get(Interp interp, TclObject tobj) throws TclException {
        ReflectObject.setReflectObjectFromAny(interp, tobj);
        ReflectObject rep = (ReflectObject)tobj.getInternalRep();
        return rep.javaObj;
    }

    public static Class getClass(Interp interp, TclObject tobj) throws TclException {
        ReflectObject.setReflectObjectFromAny(interp, tobj);
        ReflectObject rep = (ReflectObject)tobj.getInternalRep();
        return rep.javaClass;
    }

    static ReflectObject getReflectObject(Interp interp, TclObject tobj) throws TclException {
        ReflectObject.setReflectObjectFromAny(interp, tobj);
        return (ReflectObject)tobj.getInternalRep();
    }

    public void cmdProc(Interp interp, TclObject[] argv) throws TclException {
        int sigIdx;
        boolean convert;
        if (!this.isValid) {
            throw new TclException(interp, "reflected object is no longer valid");
        }
        if (argv.length < 2) {
            throw new TclNumArgsException(interp, 1, argv, "?-noconvert? signature ?arg arg ...?");
        }
        String arg1 = argv[1].toString();
        if (arg1.length() >= 2 && NOCONVERT.startsWith(arg1)) {
            convert = false;
            sigIdx = 2;
        } else {
            convert = true;
            sigIdx = 1;
        }
        if (argv.length < sigIdx + 1) {
            throw new TclNumArgsException(interp, 1, argv, "?-noconvert? signature ?arg arg ...?");
        }
        int startIdx = sigIdx + 1;
        int count = argv.length - startIdx;
        interp.setResult(JavaInvoke.callMethod(interp, new TclObject(this), argv[sigIdx], argv, startIdx, count, convert));
    }

    public void disposeCmd() {
        this.isValid = false;
    }

    public String toString() {
        return this.refID;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

