/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import java.beans.BeanInfo;
import java.beans.EventSetDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.lang.reflect.Method;
import java.util.Hashtable;
import tcl.lang.BeanEventMgr;
import tcl.lang.Command;
import tcl.lang.Interp;
import tcl.lang.ReflectObject;
import tcl.lang.TclException;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;

class JavaBindCmd
implements Command {
    BeanEventMgr eventMgr = null;
    private Hashtable beanInfoCache = new Hashtable();

    public void cmdProc(Interp interp, TclObject[] argv) throws TclException {
        if (argv.length < 2 || argv.length > 4) {
            throw new TclNumArgsException(interp, 1, argv, "javaObj ?eventName? ?command?");
        }
        ReflectObject robj = ReflectObject.getReflectObject(interp, argv[1]);
        if (this.eventMgr == null) {
            this.eventMgr = BeanEventMgr.getBeanEventMgr(interp);
        }
        if (argv.length == 2) {
            interp.setResult(this.eventMgr.getHandledEvents(robj));
        } else {
            Object[] arr = this.getEventMethod(interp, robj.javaObj, robj.javaClass, argv[2].toString());
            EventSetDescriptor eventDesc = (EventSetDescriptor)arr[0];
            if (!eventDesc.getListenerType().isInterface()) {
                throw new TclException(interp, "Cannot handle event listener: " + "listererType \"" + eventDesc.getListenerType() + "\" is not an interface");
            }
            Method method = (Method)arr[1];
            if (argv.length == 3) {
                TclObject script = this.eventMgr.getBinding(interp, robj, eventDesc, method);
                if (script != null) {
                    interp.setResult(script);
                } else {
                    interp.resetResult();
                }
            } else {
                this.eventMgr.setBinding(interp, robj, eventDesc, method, argv[3]);
            }
        }
    }

    Object[] getEventMethod(Interp interp, Object obj, Class cls, String eventName) throws TclException {
        block14: {
            Method method;
            EventSetDescriptor eventDesc;
            block15: {
                Method[] methods;
                int dotPos;
                EventSetDescriptor[] events;
                block16: {
                    BeanInfo beanInfo;
                    block13: {
                        eventDesc = null;
                        method = null;
                        try {
                            beanInfo = (BeanInfo)this.beanInfoCache.get(cls);
                            if (beanInfo != null) break block13;
                            beanInfo = Introspector.getBeanInfo(cls);
                            this.beanInfoCache.put(cls, beanInfo);
                        }
                        catch (IntrospectionException introspectionException) {
                            break block14;
                        }
                    }
                    events = beanInfo.getEventSetDescriptors();
                    if (events == null) break block14;
                    dotPos = eventName.lastIndexOf(46);
                    if (dotPos != -1) break block16;
                    int i = 0;
                    while (i < events.length) {
                        Method[] methods2 = events[i].getListenerType().getMethods();
                        int j = 0;
                        while (j < methods2.length) {
                            if (methods2[j].getName().equals(eventName)) {
                                if (method == null) {
                                    method = methods2[j];
                                    eventDesc = events[i];
                                } else {
                                    throw new TclException(interp, "ambiguous event \"" + eventName + "\"");
                                }
                            }
                            ++j;
                        }
                        ++i;
                    }
                    break block15;
                }
                String evtCls = eventName.substring(0, dotPos);
                String evtMethod = eventName.substring(dotPos + 1);
                int i = 0;
                while (i < events.length) {
                    Class<?> lsnType = events[i].getListenerType();
                    if (evtCls.equals(lsnType.getName())) {
                        eventDesc = events[i];
                        break;
                    }
                    ++i;
                }
                if (eventDesc != null && (methods = eventDesc.getListenerType().getMethods()) != null) {
                    int j = 0;
                    while (j < methods.length) {
                        if (methods[j].getName().equals(evtMethod)) {
                            method = methods[j];
                            break block15;
                        }
                        ++j;
                    }
                }
                break block14;
            }
            if (method != null) {
                Object[] arr = new Object[]{eventDesc, method};
                return arr;
            }
        }
        throw new TclException(interp, "unknown event \"" + eventName + "\"");
    }

    JavaBindCmd() {
    }
}

