/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import tcl.lang.Command;
import tcl.lang.Interp;
import tcl.lang.TclException;
import tcl.lang.TclInteger;
import tcl.lang.TclList;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;

class LreplaceCmd
implements Command {
    public void cmdProc(Interp interp, TclObject[] argv) throws TclException {
        if (argv.length < 4) {
            throw new TclNumArgsException(interp, 1, argv, "list first last ?element element ...?");
        }
        int size = TclList.getLength(interp, argv[1]);
        int first = TclInteger.getForIndex((Interp)interp, (TclObject)argv[2], (int)(size - 1));
        int last = TclInteger.getForIndex((Interp)interp, (TclObject)argv[3], (int)(size - 1));
        if (first < 0) {
            first = 0;
        }
        if (first >= size) {
            throw new TclException(interp, "list doesn't contain element " + argv[2]);
        }
        if (last >= size) {
            last = size - 1;
        }
        TclObject list = argv[1];
        list.preserve();
        list = list.takeExclusive();
        try {
            TclList.replace(interp, list, first, last - first + 1, argv, 4, argv.length - 1);
            interp.setResult(list);
        }
        finally {
            Object var9_7 = null;
            list.release();
        }
    }

    LreplaceCmd() {
    }
}

