/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import java.io.File;
import java.io.IOException;
import tcl.lang.Command;
import tcl.lang.FileChannel;
import tcl.lang.FileUtil;
import tcl.lang.Interp;
import tcl.lang.TclException;
import tcl.lang.TclIO;
import tcl.lang.TclInteger;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;
import tcl.lang.TclString;

class OpenCmd
implements Command {
    public void cmdProc(Interp interp, TclObject[] argv) throws TclException {
        boolean pipeline = false;
        int prot = 438;
        int modeFlags = 1;
        if (argv.length < 2 || argv.length > 4) {
            throw new TclNumArgsException(interp, 1, argv, "fileName ?access? ?permissions?");
        }
        if (argv.length > 2) {
            String modeStr = argv[2].toString();
            int len = modeStr.length();
            if (len == 0 || len > 2) {
                throw new TclException(interp, "illegal access mode \"" + modeStr + "\"");
            }
            switch (modeStr.charAt(0)) {
                case 'r': {
                    if (len == 1) {
                        modeFlags = 1;
                        break;
                    }
                    if (modeStr.charAt(1) == '+') {
                        modeFlags = 4;
                        break;
                    }
                }
                case 'w': {
                    File f = FileUtil.getNewFileObj(interp, argv[1].toString());
                    if (f.exists()) {
                        f.delete();
                    }
                    if (len == 1) {
                        modeFlags = 18;
                        break;
                    }
                    if (modeStr.charAt(1) == '+') {
                        modeFlags = 20;
                        break;
                    }
                }
                case 'a': {
                    if (len == 1) {
                        modeFlags = 10;
                        break;
                    }
                    if (modeStr.charAt(1) == '+') {
                        modeFlags = 28;
                        break;
                    }
                }
                default: {
                    throw new TclException(interp, "illegal access mode \"" + modeStr + "\"");
                }
            }
        }
        if (argv.length == 4) {
            prot = TclInteger.get((Interp)interp, (TclObject)argv[3]);
            throw new TclException(interp, "setting permissions not implemented yet");
        }
        if (argv[1].toString().length() > 0 && argv[1].toString().charAt(0) == '|') {
            pipeline = true;
            throw new TclException(interp, "pipelines not implemented yet");
        }
        if (!pipeline) {
            try {
                FileChannel file = new FileChannel();
                file.open(interp, argv[1].toString(), modeFlags);
                TclIO.registerChannel(interp, file);
                interp.setResult(TclString.newInstance((String)file.getChanName()));
            }
            catch (IOException iOException) {
                throw new TclException(interp, "cannot open file: " + argv[1].toString());
            }
        }
    }

    OpenCmd() {
    }
}

