/*
 * Decompiled with CFR 0.152.
 */
package tcl.regex;

import com.oroinc.text.regex.MalformedPatternException;
import com.oroinc.text.regex.MatchResult;
import com.oroinc.text.regex.Pattern;
import com.oroinc.text.regex.Perl5Compiler;
import com.oroinc.text.regex.Perl5Matcher;
import tcl.lang.Command;
import tcl.lang.Interp;
import tcl.lang.TclException;
import tcl.lang.TclIndex;
import tcl.lang.TclInteger;
import tcl.lang.TclList;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;
import tcl.lang.TclString;

public class OroRegexpCmd
implements Command {
    private static final String[] validCmds = new String[]{"-indices", "-nocase", "--"};
    private static final int OPT_INDICES = 0;
    private static final int OPT_NOCASE = 1;
    private static final int OPT_LAST = 2;

    public void cmdProc(Interp interp, TclObject[] tclObjectArray) throws TclException {
        String string;
        int n = tclObjectArray.length - 1;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        if (tclObjectArray.length < 3) {
            throw new TclNumArgsException(interp, 1, tclObjectArray, "?switches? exp string ?matchVar? ?subMatchVar subMatchVar ...?");
        }
        int n2 = 1;
        while (n > 0 && !bl3) {
            if (!tclObjectArray[n2].toString().startsWith("-")) break;
            int n3 = TclIndex.get(interp, tclObjectArray[n2], validCmds, "switch", 1);
            switch (n3) {
                case 0: {
                    bl2 = true;
                    break;
                }
                case 1: {
                    bl = true;
                    break;
                }
                case 2: {
                    bl3 = true;
                    break;
                }
                default: {
                    throw new TclException(interp, "RegexpCmd.cmdProc: bad option " + n3 + " index to validCmds");
                }
            }
            --n;
            ++n2;
        }
        if (n < 2) {
            throw new TclNumArgsException(interp, 1, tclObjectArray, "?switches? exp string ?matchVar? ?subMatchVar subMatchVar ...?");
        }
        String string2 = tclObjectArray[n2].toString();
        String string3 = string = tclObjectArray[n2 + 1].toString();
        n2 += 2;
        if (bl) {
            string2 = string2.toLowerCase();
            string3 = string.toLowerCase();
        }
        Perl5Matcher perl5Matcher = new Perl5Matcher();
        Perl5Compiler perl5Compiler = new Perl5Compiler();
        Pattern pattern = null;
        try {
            pattern = perl5Compiler.compile(string2);
        }
        catch (MalformedPatternException malformedPatternException) {
            throw new TclException(interp, "couldn't compile regular expression pattern:  " + malformedPatternException.getMessage());
        }
        if (perl5Matcher.contains(string3, pattern)) {
            MatchResult matchResult = perl5Matcher.getMatch();
            interp.setResult(TclInteger.newInstance(1));
            int n4 = 0;
            while (n > 2 && n4 < matchResult.groups()) {
                int n5 = matchResult.beginOffset(n4);
                if (n5 == -1) {
                    if (bl2) {
                        OroRegexpCmd.setMatchVar(interp, tclObjectArray[n2].toString(), -1, -1);
                    } else {
                        OroRegexpCmd.setEmptyStringVar(interp, tclObjectArray[n2].toString());
                    }
                } else {
                    int n6 = matchResult.endOffset(n4);
                    if (bl2) {
                        OroRegexpCmd.setMatchVar(interp, tclObjectArray[n2].toString(), n5, n6 - 1);
                    } else {
                        OroRegexpCmd.setMatchStringVar(interp, tclObjectArray[n2].toString(), n5, n6, string);
                    }
                }
                ++n4;
                --n;
                ++n2;
            }
        } else {
            interp.setResult(TclInteger.newInstance(0));
        }
        while (n > 2) {
            if (bl2) {
                OroRegexpCmd.setMatchVar(interp, tclObjectArray[n2].toString(), -1, -1);
            } else {
                OroRegexpCmd.setEmptyStringVar(interp, tclObjectArray[n2].toString());
            }
            --n;
            ++n2;
        }
    }

    public static boolean match(Interp interp, String string, String string2) throws TclException {
        Perl5Matcher perl5Matcher = new Perl5Matcher();
        Perl5Compiler perl5Compiler = new Perl5Compiler();
        Pattern pattern = null;
        try {
            pattern = perl5Compiler.compile(string2);
        }
        catch (MalformedPatternException malformedPatternException) {
            throw new TclException(interp, "couldn't compile regular expression pattern:  " + malformedPatternException.getMessage());
        }
        if (string2.length() > 0 && string2.charAt(0) == '^') {
            return perl5Matcher.contains(string, pattern) && perl5Matcher.getMatch().beginOffset(0) == 0;
        }
        return perl5Matcher.matches(string, pattern);
    }

    private static void setMatchVar(Interp interp, String string, int n, int n2) throws TclException {
        try {
            TclObject tclObject = TclList.newInstance();
            TclList.append(interp, tclObject, TclInteger.newInstance(n));
            TclList.append(interp, tclObject, TclInteger.newInstance(n2));
            interp.setVar(string, tclObject, 0);
            return;
        }
        catch (TclException tclException) {
            throw new TclException(interp, "couldn't set variable \"" + string + "\"");
        }
    }

    private static void setMatchStringVar(Interp interp, String string, int n, int n2, String string2) throws TclException {
        TclObject tclObject = n == -1 ? TclString.newInstance("") : TclString.newInstance(string2.substring(n, n2));
        try {
            interp.setVar(string, tclObject, 0);
            return;
        }
        catch (TclException tclException) {
            throw new TclException(interp, "couldn't set variable \"" + string + "\"");
        }
    }

    private static void setEmptyStringVar(Interp interp, String string) throws TclException {
        try {
            interp.setVar(string, TclString.newInstance(""), 0);
            return;
        }
        catch (TclException tclException) {
            throw new TclException(interp, "couldn't set variable \"" + string + "\"");
        }
    }
}

