/*
 * tkgsTk3d.h --
 *
 *	This is a modified tk3D.h that uses TkGS instead of X. All original
 *	names have been prefixed by "TkGS".
 *	Original header follows.
 *
 *	Declarations of types and functions shared by the 3d border
 *	module.
 *
 * Copyright (c) 1996-1997 by Sun Microsystems, Inc.
 *
 * See the file "license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 * RCS: @(#) $Id: tkgsTk3d.h,v 1.2 2001/09/01 21:31:09 fbonnet Exp $
 */

#ifndef _TKGSTK3D
#define _TKGSTK3D

#include <tkgsInt.h>

#ifdef BUILD_TkGS
#   undef TCL_STORAGE_CLASS
#   define TCL_STORAGE_CLASS DLLEXPORT
#endif

/*
 * One of the following data structures is allocated for each 3-D border
 * currently in use.  Structures of this type are indexed by
 * borderTable, so that a single structure can be shared for several
 * uses.
 */

typedef struct TkGSTkBorder {
    int resourceRefCount;	/* Number of active uses of this color (each
				 * active use corresponds to a call to
				 * TkGSTk_Alloc3DBorderFromObj or TkGSTk_Get3DBorder).
				 * If this count is 0, then this structure
				 * is no longer valid and it isn't present
				 * in borderTable: it is being kept around
				 * only because there are objects referring
				 * to it.  The structure is freed when
				 * resourceRefCount and objRefCount are
				 * both 0. */
    int objRefCount;		/* The number of Tcl objects that reference
				 * this structure. */
    TkGS_Color bgColor;		/* Background color (intensity
				 * between lightColorPtr and
				 * darkColorPtr). */
    TkGS_Color darkColor;	/* Color for darker areas (must free when
				 * deleting structure). NULL means shadows
				 * haven't been allocated yet.*/
    TkGS_Color lightColor;	/* Color used for lighter areas of border
				 * (must free this when deleting structure).
				 * NULL means shadows haven't been allocated
				 * yet. */
    Tcl_HashEntry *hashPtr;	/* Entry in borderTable (needed in
				 * order to delete structure). */
} TkGSTkBorder;


/*
 * Maximum intensity for a color:
 */

#define MAX_INTENSITY 65535

/*
 * Declarations for platform specific interfaces used by this module.
 */

EXTERN TkGSTkBorder *	TkGSTkpGetBorder _ANSI_ARGS_((void));
EXTERN void		TkGSTkpGetShadows _ANSI_ARGS_((TkGSTkBorder *borderPtr));
EXTERN void		TkGSTkpFreeBorder _ANSI_ARGS_((TkGSTkBorder *borderPtr));

#undef TCL_STORAGE_CLASS
#define TCL_STORAGE_CLASS DLLIMPORT

#endif /* _TKGSTK3D */
