#ifndef _TKGSFONT
#define _TKGSFONT

/*
 * Font faces
 *
 * A TkGS font face can actually be specified using several
 * desired font face names, in the order of preference. This is
 * due to the fact that we won't always get the same font
 * faces across devices: system fonts (Windows TrueType,
 * X fonts), fonts rasterized from loaded files (GD), 
 * PostScript, PDF...
 * This way, one can specify fonts in a unique and device-independent
 * way. The actual font will depend on the 
 */

/* Base type */
EXTERN TkGS_BaseType*	TkGS_GetFontFamilyBaseType();

/* Structure */
typedef struct TkGS_FontFaces_ {
    TkGS_Obj	header;		/* Must be first */

    int		nbNames;	/* Number of face names, or zero
				 * to represent device-specific default face */
    char	**names;	/* Array of face names, in preference
				 * order. */
    char        *buffer;	/* Used to store the above face names */
} TkGS_FontFaces_;

/* Accessors */
#define TkGSFontFaces_NbNames(objPtr) \
    (((TkGS_FontFaces_*)objPtr)->nbNames)
#define TkGSFontFaces_Names(objPtr) \
    (((TkGS_FontFaces_*)objPtr)->names)
#define TkGSFontFaces_Buffer(objPtr) \
    (((TkGS_FontFaces_*)objPtr)->buffer)

/* Procedures */

EXTERN TkGS_FontFaces_ *	TkGSNewFontFace _ANSI_ARGS_((char *name));
EXTERN TkGS_FontFaces_ *	TkGSNewFontFaces _ANSI_ARGS_((
				    int nbNames, char **names));


/*
 * Fonts
 */

/* Base type */
EXTERN TkGS_BaseType*	TkGS_GetFontBaseType();

/* Structure */
typedef struct TkGS_Font_ {
    TkGS_Obj		header;		/* Must be first */

    TkGS_FontAttributes	attributes;	/* Device-independent font 
					 * attributes */
} TkGS_Font_;

/* Accessors */
#define TkGSFont_Attributes(objPtr) \
    (((TkGS_Font_*)objPtr)->attributes)

/* Procedures */
EXTERN TkGS_Font_ *	TkGSNewFont _ANSI_ARGS_((TkGS_FontAttributes *faPtr));


/* 
 * Internal multi-font Unicode system
 */

/*
 * The following structure represents a font face.  It is assumed that
 * all screen fonts constructed from the same "font face" share certain
 * properties; all screen fonts with the same "font face" point to a
 * shared instance of this structure.  The most important shared property
 * is the character existence metrics, used to determine if a screen font
 * can display a given Unicode character.
 * This structure is not intended to be used as is and is not generic. Thus,
 * it is not based upon TkGS_Obj. Instead, it may be used as a base structure
 * for driver-specific structures, which may store extra information.
 */

#define FONTMAP_SHIFT		10

#define FONTMAP_PAGES	    	(1 << (sizeof(TkGS_UniChar)*8 - FONTMAP_SHIFT))
#define FONTMAP_BITSPERPAGE	(1 << FONTMAP_SHIFT)

typedef struct TkGSFontFamily_ {
    int refCount;		/* How many SubFonts are referring to this
				 * FontFamily.  When the refCount drops to
				 * zero, this TkGSFontFamily may be freed. */

    /*
     * Derived properties.
     */

    Tcl_Encoding encoding;	/* Encoding for this font face. */
    char *fontMap[FONTMAP_PAGES];
				/* Two-level sparse table used to determine
				 * quickly if the specified character exists.
				 * As characters are encountered, more pages
				 * in this table are dynamically added.  The
				 * contents of each page is a bitmask
				 * consisting of FONTMAP_BITSPERPAGE bits,
				 * representing whether this font can be used
				 * to display the given character at the
				 * corresponding bit position.  The high bits
				 * of the character are used to pick which
				 * page of the table is used. */
} TkGSFontFamily_;

typedef void (TkGSFreeFontFamilyProc) _ANSI_ARGS_((TkGSFontFamily fontFamily));

/*
 * The following structure encapsulates an individual screen font.  A font
 * can be made up of however many TkGSSubFonts are necessary to display a
 * stream of multilingual characters.
 * The same remark as for TkGSFontFamily_ applies here.
 */

typedef struct TkGSSubFont_ {
    char **fontMap;		/* Pointer to font map from the FontFamily, 
				 * cached here to save a dereference. */
    TkGSFontFamily family;	/* The TkGSFontFamily for this SubFont. */
} TkGSSubFont_;

typedef void (TkGSFreeSubFontProc) _ANSI_ARGS_((TkGSMultiFont font, 
	TkGSSubFont subFont));

/*
 * The following structure represents a font made of several subfonts.
 * The same remark as for TkGSFontFamily_ applies here.
 */

typedef struct TkGSMultiFont_ {
    int numSubFonts;		/* Length of following array. */
    TkGSSubFont subFontArray;	/* First element of an array of 
				 * TkGSSubFont-based objects that have been 
				 * loaded in order to draw/measure all the 
				 * characters encountered by this font so far.
				 * All fonts start off with one TkGSSubFont 
				 * initialized from the original set of font
				 * attributes. Do not access its elements with
				 * [], as the size of the actual elements 
				 * will differ from sizeof(TkGSSubFont). It is
				 * safe to cast its address to a pointer to 
				 * a device-specific TkGSSubFont-based 
				 * structure prior to accessing its elements
				 * with []. */
} TkGSMultiFont_;

/*
 * Procedures used by the multi-font Unicode system.
 */

/*  - Generic */
EXTERN TkGSSubFontId	TkGSFindSubFontForChar _ANSI_ARGS_((
			    TkGS_Drawable d, TkGS_Font font,
			    TkGSMultiFont multiFont, TkGS_UniChar ch));
EXTERN void		TkGSFontMapInsert _ANSI_ARGS_((TkGS_Drawable d,
			    TkGSSubFont subFont, int ch));
EXTERN void		TkGSFontMapInitPage _ANSI_ARGS_((TkGSSubFont subFont, 
			    int row));
EXTERN int		TkGSFontMapLookup _ANSI_ARGS_((TkGS_Drawable d,
			    TkGSSubFont subFont, int ch));
EXTERN char **		TkGSFontGetAliasList _ANSI_ARGS_((
			    CONST char *faceName));
EXTERN char ***		TkGSFontGetFallbacks _ANSI_ARGS_((void));
EXTERN char **		TkGSFontGetGlobalClass _ANSI_ARGS_((void));
EXTERN char **		TkGSFontGetSymbolClass _ANSI_ARGS_((void));
EXTERN void		TkGSFreeMultiFont _ANSI_ARGS_((TkGSMultiFont multiFont,
			    int stride, TkGSFreeSubFontProc freeSubFontProc));
EXTERN void		TkGSFreeSubFont _ANSI_ARGS_((TkGSSubFont subFont,
			    TkGSFreeFontFamilyProc freeFontFamilyProc));
EXTERN char *		TkGSFontFamilyOrAliasExists _ANSI_ARGS_((
			    TkGS_Drawable d, CONST char *faceName));
EXTERN char *		TkGSGetClosestFaceName _ANSI_ARGS_((TkGS_Drawable d, 
			    CONST char *faceName));
EXTERN void		TkGSInitMultiFont _ANSI_ARGS_((
			    TkGSMultiFont multiFont));
EXTERN void		TkGSInitSubFont _ANSI_ARGS_((TkGSSubFont subFont,
			    TkGSFontFamily family));
EXTERN void		TkGSInitFontFamily _ANSI_ARGS_((
			    TkGSFontFamily family, Tcl_Encoding encoding));

/*  - Unicode */
EXTERN void		TkGSMultiFontDrawCharsUni _ANSI_ARGS_((TkGS_Drawable d,
			    TkGS_Font font, TkGSMultiFont multiFont, 
			    CONST TkGS_UniChar *source, int length, int x, 
			    int y, int *widthPtr));
EXTERN int		TkGSMultiFontMeasureCharsUni _ANSI_ARGS_((
			    TkGS_Drawable d, TkGS_Font font, 
			    TkGSMultiFont multiFont, 
			    CONST TkGS_UniChar *source, int length, 
			    int maxPixels, int flags, int *lengthPtr));

/*  - UTF-8 */
EXTERN void		TkGSMultiFontDrawCharsUtf _ANSI_ARGS_((TkGS_Drawable d,
			    TkGS_Font font, TkGSMultiFont multiFont, 
			    CONST char *source, int length, int x, int y, 
			    int *widthPtr));
EXTERN int		TkGSMultiFontMeasureCharsUtf _ANSI_ARGS_((
			    TkGS_Drawable d, TkGS_Font font, 
			    TkGSMultiFont multiFont, 
			    CONST char *source, int length, int maxPixels, 
			    int flags, int *lengthPtr));

/*  - Device-specific */
#define TkGSTryHomonymousFonts(d) \
    TKGS_GETDEVICEMEMBER(d, tryHomonymousFonts)

#define TkGSGetSubFont(d, multiFont, subFontId) \
    TKGS_GETDEVICEMEMBER(d, getSubFont)(d, multiFont, subFontId)

#define TkGSSetDrawableSubFont(d, subFontId) \
    TKGS_GETDEVICEMEMBER(d, setDrawableSubFont)(d, subFontId)

#define TkGSFontMapLoadPage(d, subFont, row) \
    TKGS_GETDEVICEMEMBER(d, fontMapLoadPage)(d, subFont, row)

#define TkGSCanUseFont(d, font, multiFont, ch) \
    TKGS_GETDEVICEMEMBER(d, canUseFont)(d, font, multiFont, ch)

#define TkGSCanUseFallback(d, font, multiFont, fallbackName, ch) \
    TKGS_GETDEVICEMEMBER(d, canUseFallback)(d, font, multiFont, fallbackName, ch)

#define TkGSDefaultSubFont(d, font, multiFont) \
    TKGS_GETDEVICEMEMBER(d, defaultSubFont)(d, font, multiFont)

#define TkGSSubFontMeasureCharsUni(d, string, length, maxPixels, flags, lengthPtr) \
    TKGS_GETDEVICEMEMBER(d, subFontMeasureCharsUni)(d, string, length, maxPixels, flags, lengthPtr)

#define TkGSSubFontTextWidthUni(d, string, length) \
    TKGS_GETDEVICEMEMBER(d, subFontTextWidthUni)(d, string, length)

#define TkGSSubFontDrawCharsUni(d, string, length, x, y, widthPtr) \
    TKGS_GETDEVICEMEMBER(d, subFontDrawCharsUni)(d, string, length, x, y, widthPtr)

#define TkGSSubFontMeasureCharsUtf(d, string, length, maxPixels, flags, lengthPtr) \
    TKGS_GETDEVICEMEMBER(d, subFontMeasureCharsUtf)(d, string, length, maxPixels, flags, lengthPtr)

#define TkGSSubFontTextWidthUtf(d, string, length) \
    TKGS_GETDEVICEMEMBER(d, subFontTextWidthUtf)(d, string, length)

#define TkGSSubFontDrawCharsUtf(d, string, length, x, y, widthPtr) \
    TKGS_GETDEVICEMEMBER(d, subFontDrawCharsUtf)(d, string, length, x, y, widthPtr)


#endif /* _TKGSFONT */

