#include "tkgs.h"
#include "tkgsInt.h"

/*
 * Driver procs
 */


static Tcl_HashTable driverTable;

void
TkGSInitDriverTable() 
{
    Tcl_InitHashTable(&driverTable, TCL_STRING_KEYS);
}


void
TkGS_RegisterDeviceDriver(deviceDriverPtr)
    TkGS_DeviceDriver *deviceDriverPtr;
{
    int created;
    Tcl_HashEntry *entryPtr = Tcl_CreateHashEntry(&driverTable, deviceDriverPtr->name, &created);
    Tcl_SetHashValue(entryPtr, (ClientData) deviceDriverPtr);
}


TkGS_Device
TkGS_GetDevice(deviceName)
    char *deviceName;
{
    Tcl_HashEntry *entryPtr = Tcl_FindHashEntry(&driverTable, deviceName);

    if (!entryPtr) {
	return (TkGS_Device) NULL;
    } else {
	return (TkGS_Device) Tcl_GetHashValue(entryPtr);
    }
}


