#ifndef _TKGSCANVAS
#define _TKGSCANVAS

#include <tkgs.h>
#include <tk.h>

/*
 *--------------------------------------------------------------
 *
 * Tcl package initialization
 *
 *--------------------------------------------------------------
 */


/*
 * if the BUILD_CanvasTkGS macro is defined, the assumption is that we are
 * building the dynamic library.
 */

#ifdef BUILD_CanvasTkGS
#   undef TCL_STORAGE_CLASS
#   define TCL_STORAGE_CLASS DLLEXPORT
#endif

#define EXPORT(a,b) a b

#ifdef WIN32
#   define WIN32_LEAN_AND_MEAN
#   include <windows.h>
#   undef WIN32_LEAN_AND_MEAN

#   ifndef STATIC_BUILD
#	if defined(__BORLANDC__)
#           undef EXPORT
#           define EXPORT(a,b) a _export b
#	endif
#   endif
#endif	/* WIN32 */

/*
 * The DLL's main entry point
 */

EXTERN EXPORT(int,Canvastkgs_Init) _ANSI_ARGS_((Tcl_Interp *interp));
EXTERN EXPORT(int,Canvastkgs_SafeInit) _ANSI_ARGS_((Tcl_Interp *interp));

void CanvasTkGS_StaticPackage _ANSI_ARGS_((Tcl_Interp *interp));


/*
 * Canvas-dependent structures
 */

/* Drawable initialization structure */

typedef void (CanvasDrawableAppendResultProc) _ANSI_ARGS_((ClientData clientData,
			    char *string, int length));

typedef struct CanvasDrawableCreateData {
    CanvasDrawableAppendResultProc *appendResultProc;
    ClientData clientData;
} CanvasDrawableCreateData;


/*
 * end of tkgsCanvas.h
 * reset TCL_STORAGE_CLASS to DLLIMPORT.
 */

#undef TCL_STORAGE_CLASS
#define TCL_STORAGE_CLASS DLLIMPORT

#endif /* _TKGSCANVAS */
