/*
 * tkgsTkFont.h --
 *
 *	This is a modified tkFont.h that uses TkGS instead of the old
 *	platform-specific calls. All original names have been prefixed by 
 *	"TkGS". Original header follows.
 *
 *	Declarations for interfaces between the generic and platform-
 *	specific parts of the font package.  This information is not
 *	visible outside of the font package.
 *
 * Copyright (c) 1996-1997 Sun Microsystems, Inc.
 *
 * See the file "license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 * RCS: @(#) $Id: tkgsTkFont.h,v 1.1 2001/03/08 12:30:44 fbonnet Exp $
 */

#ifndef _TKGSTKFONT
#define _TKGSTKFONT

#ifdef BUILD_TkGS
# undef TCL_STORAGE_CLASS
# define TCL_STORAGE_CLASS DLLEXPORT
#endif

/*
 * The following structure is used to keep track of the generic information
 * about a font. 
 */

typedef struct TkGSTkFont {
    TkGS_Font font;		/* The TkGS font object. */

    int resourceRefCount;	/* Number of active uses of this font (each
				 * active use corresponds to a call to
				 * Tk_AllocFontFromTable or Tk_GetFont).
				 * If this count is 0, then this TkFont
				 * structure is no longer valid and it isn't
				 * present in a hash table: it is being
				 * kept around only because there are objects
				 * referring to it.  The structure is freed
				 * when resourceRefCount and objRefCount
				 * are both 0. */
    int objRefCount;		/* The number of Tcl objects that reference
				 * this structure. */
    Tcl_HashEntry *cacheHashPtr;/* Entry in font cache for this structure,
				 * used when deleting it. */
    Tcl_HashEntry *namedHashPtr;/* Pointer to hash table entry that
				 * corresponds to the named font that the
				 * tkfont was based on, or NULL if the tkfont
				 * was not based on a named font. */
} TkGSTkFont;

/*
 * The following structure is used to return attributes when parsing an
 * XLFD.  The extra information is of interest to the Unix-specific code
 * when attempting to find the closest matching font.
 */

typedef struct TkGSTkXLFDAttributes {
    Tk_Uid foundry;		/* The foundry of the font. */
    int slant;			/* The tristate value for the slant, which
				 * is significant under X. */
    int setwidth;		/* The proportionate width, see below for
				 * definition. */
    Tk_Uid charset;		/* The actual charset string. */
} TkGSTkXLFDAttributes;

/*
 * Possible values for the "setwidth" field in a TkGSTkXLFDAttributes structure.
 * The setwidth is whether characters are considered wider or narrower than
 * normal.
 */

#define TKGSTK_SW_NORMAL	0
#define TKGSTK_SW_CONDENSE	1
#define TKGSTK_SW_EXPAND	2
#define TKGSTK_SW_UNKNOWN	3
				/* Unknown setwidth.  This value may be
				 * stored in the setwidth field. */

/*
 * The following defines specify the meaning of the fields in a fully
 * qualified XLFD.
 */

#define XLFD_FOUNDRY	    0
#define XLFD_FAMILY	    1
#define XLFD_WEIGHT	    2
#define XLFD_SLANT	    3
#define XLFD_SETWIDTH	    4
#define XLFD_ADD_STYLE	    5
#define XLFD_PIXEL_SIZE	    6
#define XLFD_POINT_SIZE	    7
#define XLFD_RESOLUTION_X   8
#define XLFD_RESOLUTION_Y   9
#define XLFD_SPACING	    10
#define XLFD_AVERAGE_WIDTH  11
#define XLFD_CHARSET	    12
#define XLFD_NUMFIELDS	    13	/* Number of fields in XLFD. */

/*
 * Low-level API exported by generic code to platform-specific code.
 */

/* TODO: keep these??? */
#define TkGSTkInitFontAttributes(fa)   memset((fa), 0, sizeof(TkGS_FontAttributes));
#define TkGSTkInitXLFDAttributes(xa)   memset((xa), 0, sizeof(TkGSTkXLFDAttributes));

EXTERN int		TkGSTkFontParseXLFD _ANSI_ARGS_((CONST char *string,
			    TkGS_FontAttributes *faPtr, 
			    TkGSTkXLFDAttributes *xaPtr));

/* TODO: keep these??? */
EXTERN int		TkGSTkFontGetPixels _ANSI_ARGS_((Tk_Window tkwin, 
			    int size));
EXTERN int		TkGSTkFontGetPoints _ANSI_ARGS_((Tk_Window tkwin, 
			    int size));

# undef TCL_STORAGE_CLASS
# define TCL_STORAGE_CLASS DLLIMPORT

#endif	/* _TKGSTKFONT */
